/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.Delaunay;
import visad.SetException;
import visad.VisADException;

public class DelaunayClarkson
extends Delaunay {
    private static final double DBL_MANT_DIG = 53.0;
    private static final double FLT_RADIX = 2.0;
    private static final double DBL_EPSILON = 2.220446049250313E-16;
    private static final double ln2 = Math.log(2.0);
    private static final int INFINITY = -2;
    private static final int NOVAL = -1;
    private float[][] site_blocks;
    private int[][] a3s;
    private int a3size;
    private int nts = 0;
    private static final int max_blocks = 10000;
    private static final int Nobj = 10000;
    private static final int MAXDIM = 8;
    private int dim;
    private int p;
    private long pnum;
    private int rdim;
    private int cdim;
    private int exact_bits;
    private double b_err_min;
    private double b_err_min_sq;
    private double ldetbound = 0.0;
    private int failcount = 0;
    private int lscale;
    private double max_scale;
    private float Sb;
    private int nsb = 0;
    private int nbb = 0;
    private int ss = 8;
    private int ss2 = 2000;
    private long vnum = -1L;
    private int p_neigh_vert = -1;
    private int[] voidp = new int[1];
    private int[] voidp_bn = new int[1];
    private int[][] bbt_next = new int[10000][];
    private int[][] bbt_next_bn = new int[10000][];
    private int[][] bbt_ref_count = new int[10000][];
    private int[][] bbt_lscale = new int[10000][];
    private double[][] bbt_sqa = new double[10000][];
    private double[][] bbt_sqb = new double[10000][];
    private double[][][] bbt_vecs = new double[10000][][];
    private int ttbp;
    private int ttbp_bn;
    private int ib;
    private int ib_bn;
    private int basis_s_list = -1;
    private int basis_s_list_bn;
    private int pnb = -1;
    private int pnb_bn;
    private int b = -1;
    private int b_bn;
    private int[][] sbt_next = new int[10000][];
    private int[][] sbt_next_bn = new int[10000][];
    private long[][] sbt_visit = new long[10000][];
    private short[][] sbt_mark = new short[10000][];
    private int[][] sbt_normal = new int[10000][];
    private int[][] sbt_normal_bn = new int[10000][];
    private int[][] sbt_peak_vert = new int[10000][];
    private int[][] sbt_peak_simp = new int[10000][];
    private int[][] sbt_peak_simp_bn = new int[10000][];
    private int[][] sbt_peak_basis = new int[10000][];
    private int[][] sbt_peak_basis_bn = new int[10000][];
    private int[][][] sbt_neigh_vert = new int[10000][][];
    private int[][][] sbt_neigh_simp = new int[10000][][];
    private int[][][] sbt_neigh_simp_bn = new int[10000][][];
    private int[][][] sbt_neigh_basis = new int[10000][][];
    private int[][][] sbt_neigh_basis_bn = new int[10000][][];
    private int simplex_list = -1;
    private int simplex_list_bn;
    private int ch_root;
    private int ch_root_bn;
    private int ns;
    private int ns_bn;
    private int[] st = new int[this.ss + 8 + 1];
    private int[] st_bn = new int[this.ss + 8 + 1];
    private int[] st2 = new int[this.ss2 + 8 + 1];
    private int[] st2_bn = new int[this.ss2 + 8 + 1];

    private int new_block_basis_s() {
        this.bbt_next[this.nbb] = new int[10000];
        this.bbt_next_bn[this.nbb] = new int[10000];
        this.bbt_ref_count[this.nbb] = new int[10000];
        this.bbt_lscale[this.nbb] = new int[10000];
        this.bbt_sqa[this.nbb] = new double[10000];
        this.bbt_sqb[this.nbb] = new double[10000];
        this.bbt_vecs[this.nbb] = new double[2 * this.rdim][];
        int i = 0;
        while (i < 2 * this.rdim) {
            this.bbt_vecs[this.nbb][i] = new double[10000];
            ++i;
        }
        int i2 = 0;
        while (i2 < 10000) {
            this.bbt_next[this.nbb][i2] = i2 + 1;
            this.bbt_next_bn[this.nbb][i2] = this.nbb;
            this.bbt_ref_count[this.nbb][i2] = 0;
            this.bbt_lscale[this.nbb][i2] = 0;
            this.bbt_sqa[this.nbb][i2] = 0.0;
            this.bbt_sqb[this.nbb][i2] = 0.0;
            int j = 0;
            while (j < 2 * this.rdim) {
                this.bbt_vecs[this.nbb][j][i2] = 0.0;
                ++j;
            }
            ++i2;
        }
        this.bbt_next[this.nbb][9999] = -1;
        this.basis_s_list = 0;
        this.basis_s_list_bn = this.nbb++;
        return this.basis_s_list;
    }

    private int reduce_inner(int v, int v_bn, int s, int s_bn, int k) {
        double Sb = 0.0;
        this.bbt_sqa[v_bn][v] = 0.0;
        int i = 0;
        while (i < this.rdim) {
            double[] dArray = this.bbt_sqa[v_bn];
            int n = v;
            dArray[n] = dArray[n] + this.bbt_vecs[v_bn][i][v] * this.bbt_vecs[v_bn][i][v];
            ++i;
        }
        this.bbt_sqb[v_bn][v] = this.bbt_sqa[v_bn][v];
        if (k <= 1) {
            int i2 = 0;
            while (i2 < this.rdim) {
                this.bbt_vecs[v_bn][i2][v] = this.bbt_vecs[v_bn][this.rdim + i2][v];
                ++i2;
            }
            return 1;
        }
        int j = 0;
        while (j < 250) {
            double scale;
            double dd;
            int q_bn;
            int q;
            int xx = this.rdim;
            int i3 = 0;
            while (i3 < this.rdim) {
                this.bbt_vecs[v_bn][i3][v] = this.bbt_vecs[v_bn][this.rdim + i3][v];
                ++i3;
            }
            int i4 = k - 1;
            while (i4 > 0) {
                q = this.sbt_neigh_basis[s_bn][i4][s];
                q_bn = this.sbt_neigh_basis_bn[s_bn][i4][s];
                dd = 0.0;
                int l = 0;
                while (l < this.rdim) {
                    dd -= this.bbt_vecs[q_bn][l][q] * this.bbt_vecs[v_bn][l][v];
                    ++l;
                }
                dd /= this.bbt_sqb[q_bn][q];
                int l2 = 0;
                while (l2 < this.rdim) {
                    double[] dArray = this.bbt_vecs[v_bn][l2];
                    int n = v;
                    dArray[n] = dArray[n] + dd * this.bbt_vecs[q_bn][this.rdim + l2][q];
                    ++l2;
                }
                --i4;
            }
            this.bbt_sqb[v_bn][v] = 0.0;
            int i5 = 0;
            while (i5 < this.rdim) {
                double[] dArray = this.bbt_sqb[v_bn];
                int n = v;
                dArray[n] = dArray[n] + this.bbt_vecs[v_bn][i5][v] * this.bbt_vecs[v_bn][i5][v];
                ++i5;
            }
            this.bbt_sqa[v_bn][v] = 0.0;
            int i6 = 0;
            while (i6 < this.rdim) {
                double[] dArray = this.bbt_sqa[v_bn];
                int n = v;
                dArray[n] = dArray[n] + this.bbt_vecs[v_bn][this.rdim + i6][v] * this.bbt_vecs[v_bn][this.rdim + i6][v];
                ++i6;
            }
            if (2.0 * this.bbt_sqb[v_bn][v] >= this.bbt_sqa[v_bn][v]) {
                return 1;
            }
            if (j < 10) {
                double labound = Math.floor(Math.log(this.bbt_sqa[v_bn][v]) / ln2) / 2.0;
                this.max_scale = (double)this.exact_bits - labound - 0.66 * (double)(k - 2) - 1.0;
                if (this.max_scale < 1.0) {
                    this.max_scale = 1.0;
                }
                if (j == 0) {
                    this.ldetbound = 0.0;
                    Sb = 0.0;
                    int l = k - 1;
                    while (l > 0) {
                        q = this.sbt_neigh_basis[s_bn][l][s];
                        q_bn = this.sbt_neigh_basis_bn[s_bn][l][s];
                        Sb += this.bbt_sqb[q_bn][q];
                        this.ldetbound += Math.floor(Math.log(this.bbt_sqb[q_bn][q]) / ln2) / 2.0 + 1.0;
                        this.ldetbound -= (double)this.bbt_lscale[q_bn][q];
                        --l;
                    }
                }
            }
            if (this.ldetbound - (double)this.bbt_lscale[v_bn][v] + Math.floor(Math.log(this.bbt_sqb[v_bn][v]) / ln2) / 2.0 + 1.0 < 0.0) {
                scale = 0.0;
            } else {
                this.lscale = (int)(Math.log(2.0 * Sb / (this.bbt_sqb[v_bn][v] + this.bbt_sqa[v_bn][v] * this.b_err_min)) / ln2) / 2;
                if ((double)this.lscale > this.max_scale) {
                    this.lscale = (int)this.max_scale;
                } else if (this.lscale < 0) {
                    this.lscale = 0;
                }
                int[] nArray = this.bbt_lscale[v_bn];
                int n = v;
                nArray[n] = nArray[n] + this.lscale;
                scale = this.lscale < 20 ? (double)(1 << this.lscale) : Math.pow(2.0, this.lscale);
            }
            while (xx < 2 * this.rdim) {
                double[] dArray = this.bbt_vecs[v_bn][xx++];
                int n = v;
                dArray[n] = dArray[n] * scale;
            }
            int i7 = k - 1;
            while (i7 > 0) {
                q = this.sbt_neigh_basis[s_bn][i7][s];
                q_bn = this.sbt_neigh_basis_bn[s_bn][i7][s];
                dd = 0.0;
                int l = 0;
                while (l < this.rdim) {
                    dd -= this.bbt_vecs[q_bn][l][q] * this.bbt_vecs[v_bn][this.rdim + l][v];
                    ++l;
                }
                dd /= this.bbt_sqb[q_bn][q];
                dd = Math.floor(dd + 0.5);
                int l3 = 0;
                while (l3 < this.rdim) {
                    double[] dArray = this.bbt_vecs[v_bn][this.rdim + l3];
                    int n = v;
                    dArray[n] = dArray[n] + dd * this.bbt_vecs[q_bn][this.rdim + l3][q];
                    ++l3;
                }
                --i7;
            }
            ++j;
        }
        if (this.failcount++ < 10) {
            System.out.println("reduce_inner failed!");
        }
        return 0;
    }

    private int reduce(int[] v, int[] v_bn, int rp, int s, int s_bn, int k) {
        if (v[0] == -1) {
            v[0] = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
            v_bn[0] = this.basis_s_list_bn;
            this.basis_s_list = this.bbt_next[v_bn[0]][v[0]];
            this.basis_s_list_bn = this.bbt_next_bn[v_bn[0]][v[0]];
            this.bbt_ref_count[v_bn[0]][v[0]] = 1;
        } else {
            this.bbt_lscale[v_bn[0]][v[0]] = 0;
        }
        if (rp == -2) {
            this.bbt_next[v_bn[0]][v[0]] = this.bbt_next[this.ib_bn][this.ib];
            this.bbt_next_bn[v_bn[0]][v[0]] = this.bbt_next_bn[this.ib_bn][this.ib];
            this.bbt_ref_count[v_bn[0]][v[0]] = this.bbt_ref_count[this.ib_bn][this.ib];
            this.bbt_lscale[v_bn[0]][v[0]] = this.bbt_lscale[this.ib_bn][this.ib];
            this.bbt_sqa[v_bn[0]][v[0]] = this.bbt_sqa[this.ib_bn][this.ib];
            this.bbt_sqb[v_bn[0]][v[0]] = this.bbt_sqb[this.ib_bn][this.ib];
            int i = 0;
            while (i < 2 * this.rdim) {
                this.bbt_vecs[v_bn[0]][i][v[0]] = this.bbt_vecs[this.ib_bn][i][this.ib];
                ++i;
            }
        } else {
            int i;
            double sum = 0.0;
            int sbt_nv = this.sbt_neigh_vert[s_bn][0][s];
            if (sbt_nv == -2) {
                i = 0;
                while (i < this.dim) {
                    double d = this.site_blocks[i][rp];
                    this.bbt_vecs[v_bn[0]][i][v[0]] = d;
                    this.bbt_vecs[v_bn[0]][i + this.rdim][v[0]] = d;
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.dim) {
                    double d = this.site_blocks[i][rp] - this.site_blocks[i][sbt_nv];
                    this.bbt_vecs[v_bn[0]][i][v[0]] = d;
                    this.bbt_vecs[v_bn[0]][i + this.rdim][v[0]] = d;
                    ++i;
                }
            }
            i = 0;
            while (i < this.dim) {
                sum += this.bbt_vecs[v_bn[0]][i][v[0]] * this.bbt_vecs[v_bn[0]][i][v[0]];
                ++i;
            }
            this.bbt_vecs[v_bn[0]][2 * this.rdim - 1][v[0]] = sum;
            this.bbt_vecs[v_bn[0]][this.rdim - 1][v[0]] = sum;
        }
        return this.reduce_inner(v[0], v_bn[0], s, s_bn, k);
    }

    /*
     * Unable to fully structure code
     */
    private void get_basis_sede(int s, int s_bn) {
        block9: {
            block8: {
                k = 1;
                curt = new int[1];
                curt_bn = new int[1];
                if (this.sbt_neigh_vert[s_bn][0][s] != -2 || this.cdim <= 1) break block8;
                t_vert = this.sbt_neigh_vert[s_bn][0][s];
                t_simp = this.sbt_neigh_simp[s_bn][0][s];
                t_simp_bn = this.sbt_neigh_simp_bn[s_bn][0][s];
                t_basis = this.sbt_neigh_basis[s_bn][0][s];
                t_basis_bn = this.sbt_neigh_basis_bn[s_bn][0][s];
                this.sbt_neigh_vert[s_bn][0][s] = this.sbt_neigh_vert[s_bn][k][s];
                this.sbt_neigh_simp[s_bn][0][s] = this.sbt_neigh_simp[s_bn][k][s];
                this.sbt_neigh_simp_bn[s_bn][0][s] = this.sbt_neigh_simp_bn[s_bn][k][s];
                this.sbt_neigh_basis[s_bn][0][s] = this.sbt_neigh_basis[s_bn][k][s];
                this.sbt_neigh_basis_bn[s_bn][0][s] = this.sbt_neigh_basis_bn[s_bn][k][s];
                this.sbt_neigh_vert[s_bn][k][s] = t_vert;
                this.sbt_neigh_simp[s_bn][k][s] = t_simp;
                this.sbt_neigh_simp_bn[s_bn][k][s] = t_simp_bn;
                this.sbt_neigh_basis[s_bn][k][s] = t_basis;
                this.sbt_neigh_basis_bn[s_bn][k][s] = t_basis_bn;
                q = this.sbt_neigh_basis[s_bn][0][s];
                q_bn = this.sbt_neigh_basis_bn[s_bn][0][s];
                if (q != -1) {
                    v0 = this.bbt_ref_count[q_bn];
                    v1 = q;
                    v0[v1] = v0[v1] - 1;
                    if (v0[v1] == 0) {
                        this.bbt_next[q_bn][q] = this.basis_s_list;
                        this.bbt_next_bn[q_bn][q] = this.basis_s_list_bn;
                        this.bbt_ref_count[q_bn][q] = 0;
                        this.bbt_lscale[q_bn][q] = 0;
                        this.bbt_sqa[q_bn][q] = 0.0;
                        this.bbt_sqb[q_bn][q] = 0.0;
                        j = 0;
                        while (j < 2 * this.rdim) {
                            this.bbt_vecs[q_bn][j][q] = 0.0;
                            ++j;
                        }
                        this.basis_s_list = q;
                        this.basis_s_list_bn = q_bn;
                    }
                }
                this.sbt_neigh_basis[s_bn][0][s] = this.ttbp;
                this.sbt_neigh_basis_bn[s_bn][0][s] = this.ttbp_bn;
                v2 = this.bbt_ref_count[this.ttbp_bn];
                v3 = this.ttbp;
                v2[v3] = v2[v3] + 1;
                break block9;
            }
            if (this.sbt_neigh_basis[s_bn][0][s] != -1) ** GOTO lbl55
            this.sbt_neigh_basis[s_bn][0][s] = this.ttbp;
            this.sbt_neigh_basis_bn[s_bn][0][s] = this.ttbp_bn;
            v4 = this.bbt_ref_count[this.ttbp_bn];
            v5 = this.ttbp;
            v4[v5] = v4[v5] + 1;
            break block9;
lbl-1000:
            // 1 sources

            {
                ++k;
lbl55:
                // 2 sources

                ** while (k < this.cdim && this.sbt_neigh_basis[s_bn][k][s] != -1)
            }
        }
        while (k < this.cdim) {
            q = this.sbt_neigh_basis[s_bn][k][s];
            q_bn = this.sbt_neigh_basis_bn[s_bn][k][s];
            if (q != -1) {
                v6 = this.bbt_ref_count[q_bn];
                v7 = q;
                v6[v7] = v6[v7] - 1;
                if (v6[v7] == 0) {
                    this.bbt_next[q_bn][q] = this.basis_s_list;
                    this.bbt_next_bn[q_bn][q] = this.basis_s_list_bn;
                    this.bbt_ref_count[q_bn][q] = 0;
                    this.bbt_lscale[q_bn][q] = 0;
                    this.bbt_sqa[q_bn][q] = 0.0;
                    this.bbt_sqb[q_bn][q] = 0.0;
                    j = 0;
                    while (j < 2 * this.rdim) {
                        this.bbt_vecs[q_bn][j][q] = 0.0;
                        ++j;
                    }
                    this.basis_s_list = q;
                    this.basis_s_list_bn = q_bn;
                }
            }
            this.sbt_neigh_basis[s_bn][k][s] = -1;
            curt[0] = this.sbt_neigh_basis[s_bn][k][s];
            curt_bn[0] = this.sbt_neigh_basis_bn[s_bn][k][s];
            this.reduce(curt, curt_bn, this.sbt_neigh_vert[s_bn][k][s], s, s_bn, k);
            this.sbt_neigh_basis[s_bn][k][s] = curt[0];
            this.sbt_neigh_basis_bn[s_bn][k][s] = curt_bn[0];
            ++k;
        }
    }

    private int sees(int rp, int s, int s_bn) {
        int l;
        int i;
        int q_bn;
        int q;
        int[] curt = new int[1];
        int[] curt_bn = new int[1];
        if (this.b == -1) {
            this.b = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
            this.b_bn = this.basis_s_list_bn;
            this.basis_s_list = this.bbt_next[this.b_bn][this.b];
            this.basis_s_list_bn = this.bbt_next_bn[this.b_bn][this.b];
        } else {
            this.bbt_lscale[this.b_bn][this.b] = 0;
        }
        if (this.cdim == 0) {
            return 0;
        }
        if (this.sbt_normal[s_bn][s] == -1) {
            this.get_basis_sede(s, s_bn);
            if (this.rdim == 3 && this.cdim == 3) {
                this.sbt_normal[s_bn][s] = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
                this.sbt_normal_bn[s_bn][s] = this.basis_s_list_bn;
                q = this.sbt_normal[s_bn][s];
                q_bn = this.sbt_normal_bn[s_bn][s];
                this.basis_s_list = this.bbt_next[q_bn][q];
                this.basis_s_list_bn = this.bbt_next_bn[q_bn][q];
                int q1 = this.sbt_neigh_basis[s_bn][1][s];
                int q1_bn = this.sbt_neigh_basis_bn[s_bn][1][s];
                int q2 = this.sbt_neigh_basis[s_bn][2][s];
                int q2_bn = this.sbt_neigh_basis_bn[s_bn][2][s];
                this.bbt_ref_count[q_bn][q] = 1;
                this.bbt_vecs[q_bn][0][q] = this.bbt_vecs[q1_bn][1][q1] * this.bbt_vecs[q2_bn][2][q2] - this.bbt_vecs[q1_bn][2][q1] * this.bbt_vecs[q2_bn][1][q2];
                this.bbt_vecs[q_bn][1][q] = this.bbt_vecs[q1_bn][2][q1] * this.bbt_vecs[q2_bn][0][q2] - this.bbt_vecs[q1_bn][0][q1] * this.bbt_vecs[q2_bn][2][q2];
                this.bbt_vecs[q_bn][2][q] = this.bbt_vecs[q1_bn][0][q1] * this.bbt_vecs[q2_bn][1][q2] - this.bbt_vecs[q1_bn][1][q1] * this.bbt_vecs[q2_bn][0][q2];
                this.bbt_sqb[q_bn][q] = 0.0;
                i = 0;
                while (i < this.rdim) {
                    double[] dArray = this.bbt_sqb[q_bn];
                    int n = q;
                    dArray[n] = dArray[n] + this.bbt_vecs[q_bn][i][q] * this.bbt_vecs[q_bn][i][q];
                    ++i;
                }
                int i2 = this.cdim + 1;
                while (i2 > 0) {
                    int m = i2 > 1 ? this.sbt_neigh_vert[this.ch_root_bn][i2 - 2][this.ch_root] : -2;
                    int j = 0;
                    while (j < this.cdim && m != this.sbt_neigh_vert[s_bn][j][s]) {
                        ++j;
                    }
                    if (j >= this.cdim && !(m == -2 ? this.bbt_vecs[q_bn][2][q] > -this.b_err_min : this.sees(m, s, s_bn) == 0)) {
                        this.bbt_vecs[q_bn][0][q] = -this.bbt_vecs[q_bn][0][q];
                        this.bbt_vecs[q_bn][1][q] = -this.bbt_vecs[q_bn][1][q];
                        this.bbt_vecs[q_bn][2][q] = -this.bbt_vecs[q_bn][2][q];
                        break;
                    }
                    --i2;
                }
            } else {
                i = this.cdim + 1;
                while (i > 0) {
                    int m = i > 1 ? this.sbt_neigh_vert[this.ch_root_bn][i - 2][this.ch_root] : -2;
                    int j = 0;
                    while (j < this.cdim && m != this.sbt_neigh_vert[s_bn][j][s]) {
                        ++j;
                    }
                    if (j >= this.cdim) {
                        curt[0] = this.sbt_normal[s_bn][s];
                        curt_bn[0] = this.sbt_normal_bn[s_bn][s];
                        this.reduce(curt, curt_bn, m, s, s_bn, this.cdim);
                        int n = curt[0];
                        this.sbt_normal[s_bn][s] = n;
                        q = n;
                        int n2 = curt_bn[0];
                        this.sbt_normal_bn[s_bn][s] = n2;
                        q_bn = n2;
                        if (this.bbt_sqb[q_bn][q] != 0.0) break;
                    }
                    --i;
                }
            }
            i = 0;
            while (i < this.cdim) {
                q = this.sbt_neigh_basis[s_bn][i][s];
                q_bn = this.sbt_neigh_basis_bn[s_bn][i][s];
                if (q != -1) {
                    int[] nArray = this.bbt_ref_count[q_bn];
                    int n = q;
                    nArray[n] = nArray[n] - 1;
                    if (nArray[n] == 0) {
                        this.bbt_next[q_bn][q] = this.basis_s_list;
                        this.bbt_next_bn[q_bn][q] = this.basis_s_list_bn;
                        this.bbt_ref_count[q_bn][q] = 0;
                        this.bbt_lscale[q_bn][q] = 0;
                        this.bbt_sqa[q_bn][q] = 0.0;
                        this.bbt_sqb[q_bn][q] = 0.0;
                        int l2 = 0;
                        while (l2 < 2 * this.rdim) {
                            this.bbt_vecs[q_bn][l2][q] = 0.0;
                            ++l2;
                        }
                        this.basis_s_list = q;
                        this.basis_s_list_bn = q_bn;
                    }
                }
                this.sbt_neigh_basis[s_bn][i][s] = -1;
                ++i;
            }
        }
        if (rp == -2) {
            this.bbt_next[this.b_bn][this.b] = this.bbt_next[this.ib_bn][this.ib];
            this.bbt_next_bn[this.b_bn][this.b] = this.bbt_next_bn[this.ib_bn][this.ib];
            this.bbt_ref_count[this.b_bn][this.b] = this.bbt_ref_count[this.ib_bn][this.ib];
            this.bbt_lscale[this.b_bn][this.b] = this.bbt_lscale[this.ib_bn][this.ib];
            this.bbt_sqa[this.b_bn][this.b] = this.bbt_sqa[this.ib_bn][this.ib];
            this.bbt_sqb[this.b_bn][this.b] = this.bbt_sqb[this.ib_bn][this.ib];
            i = 0;
            while (i < 2 * this.rdim) {
                this.bbt_vecs[this.b_bn][i][this.b] = this.bbt_vecs[this.ib_bn][i][this.ib];
                ++i;
            }
        } else {
            double sum = 0.0;
            int sbt_nv = this.sbt_neigh_vert[s_bn][0][s];
            if (sbt_nv == -2) {
                l = 0;
                while (l < this.dim) {
                    double d = this.site_blocks[l][rp];
                    this.bbt_vecs[this.b_bn][l][this.b] = d;
                    this.bbt_vecs[this.b_bn][l + this.rdim][this.b] = d;
                    ++l;
                }
            } else {
                l = 0;
                while (l < this.dim) {
                    double d = this.site_blocks[l][rp] - this.site_blocks[l][sbt_nv];
                    this.bbt_vecs[this.b_bn][l][this.b] = d;
                    this.bbt_vecs[this.b_bn][l + this.rdim][this.b] = d;
                    ++l;
                }
            }
            l = 0;
            while (l < this.dim) {
                sum += this.bbt_vecs[this.b_bn][l][this.b] * this.bbt_vecs[this.b_bn][l][this.b];
                ++l;
            }
            double d = sum;
            this.bbt_vecs[this.b_bn][this.rdim - 1][this.b] = d;
            this.bbt_vecs[this.b_bn][2 * this.rdim - 1][this.b] = d;
        }
        q = this.sbt_normal[s_bn][s];
        q_bn = this.sbt_normal_bn[s_bn][s];
        int i3 = 0;
        while (i3 < 3) {
            double sum = 0.0;
            double dd = 0.0;
            l = 0;
            while (l < this.rdim) {
                dd += this.bbt_vecs[this.b_bn][l][this.b] * this.bbt_vecs[q_bn][l][q];
                ++l;
            }
            if (dd == 0.0) {
                return 0;
            }
            int l3 = 0;
            while (l3 < this.rdim) {
                sum += this.bbt_vecs[this.b_bn][l3][this.b] * this.bbt_vecs[this.b_bn][l3][this.b];
                ++l3;
            }
            double dds = dd * dd / this.bbt_sqb[q_bn][q] / sum;
            if (dds > this.b_err_min_sq) {
                return dd < 0.0 ? 1 : 0;
            }
            this.get_basis_sede(s, s_bn);
            this.reduce_inner(this.b, this.b_bn, s, s_bn, this.cdim);
            ++i3;
        }
        return 0;
    }

    private int new_block_simplex() {
        this.sbt_next[this.nsb] = new int[10000];
        this.sbt_next_bn[this.nsb] = new int[10000];
        this.sbt_visit[this.nsb] = new long[10000];
        this.sbt_mark[this.nsb] = new short[10000];
        this.sbt_normal[this.nsb] = new int[10000];
        this.sbt_normal_bn[this.nsb] = new int[10000];
        this.sbt_peak_vert[this.nsb] = new int[10000];
        this.sbt_peak_simp[this.nsb] = new int[10000];
        this.sbt_peak_simp_bn[this.nsb] = new int[10000];
        this.sbt_peak_basis[this.nsb] = new int[10000];
        this.sbt_peak_basis_bn[this.nsb] = new int[10000];
        this.sbt_neigh_vert[this.nsb] = new int[this.rdim][];
        this.sbt_neigh_simp[this.nsb] = new int[this.rdim][];
        this.sbt_neigh_simp_bn[this.nsb] = new int[this.rdim][];
        this.sbt_neigh_basis[this.nsb] = new int[this.rdim][];
        this.sbt_neigh_basis_bn[this.nsb] = new int[this.rdim][];
        int i = 0;
        while (i < this.rdim) {
            this.sbt_neigh_vert[this.nsb][i] = new int[10000];
            this.sbt_neigh_simp[this.nsb][i] = new int[10000];
            this.sbt_neigh_simp_bn[this.nsb][i] = new int[10000];
            this.sbt_neigh_basis[this.nsb][i] = new int[10000];
            this.sbt_neigh_basis_bn[this.nsb][i] = new int[10000];
            ++i;
        }
        int i2 = 0;
        while (i2 < 10000) {
            this.sbt_next[this.nsb][i2] = i2 + 1;
            this.sbt_next_bn[this.nsb][i2] = this.nsb;
            this.sbt_visit[this.nsb][i2] = 0L;
            this.sbt_mark[this.nsb][i2] = 0;
            this.sbt_normal[this.nsb][i2] = -1;
            this.sbt_peak_vert[this.nsb][i2] = -1;
            this.sbt_peak_simp[this.nsb][i2] = -1;
            this.sbt_peak_basis[this.nsb][i2] = -1;
            int j = 0;
            while (j < this.rdim) {
                this.sbt_neigh_vert[this.nsb][j][i2] = -1;
                this.sbt_neigh_simp[this.nsb][j][i2] = -1;
                this.sbt_neigh_basis[this.nsb][j][i2] = -1;
                ++j;
            }
            ++i2;
        }
        this.sbt_next[this.nsb][9999] = -1;
        this.simplex_list = 0;
        this.simplex_list_bn = this.nsb++;
        return this.simplex_list;
    }

    private void visit_triang_gen(int s, int s_bn, int whichfunc, int[] ret, int[] ret_bn) {
        int tms = 0;
        --this.vnum;
        if (s != -1) {
            this.st2[tms] = s;
            this.st2_bn[tms] = s_bn;
            ++tms;
        }
        while (tms != 0) {
            if (tms > this.ss2) {
                this.ss2 += this.ss2;
                int[] newst2 = new int[this.ss2 + 8 + 1];
                int[] newst2_bn = new int[this.ss2 + 8 + 1];
                System.arraycopy(this.st2, 0, newst2, 0, this.st2.length);
                System.arraycopy(this.st2_bn, 0, newst2_bn, 0, this.st2_bn.length);
                this.st2 = newst2;
                this.st2_bn = newst2_bn;
            }
            int t = this.st2[--tms];
            int t_bn = this.st2_bn[tms];
            if (t == -1 || this.sbt_visit[t_bn][t] == this.vnum) continue;
            this.sbt_visit[t_bn][t] = this.vnum;
            if (whichfunc == 1) {
                int v_bn;
                int v;
                if (this.sbt_peak_vert[t_bn][t] == -1) {
                    v = t;
                    v_bn = t_bn;
                } else {
                    v = -1;
                    v_bn = -1;
                }
                if (v != -1) {
                    ret[0] = v;
                    ret_bn[0] = v_bn;
                    return;
                }
            } else {
                int[] vfp = new int[this.cdim];
                if (t != -1) {
                    int j = 0;
                    while (j < this.cdim) {
                        vfp[j] = this.sbt_neigh_vert[t_bn][j][t];
                        ++j;
                    }
                    int j2 = 0;
                    while (j2 < this.cdim) {
                        this.a3s[j2][this.nts] = vfp[j2] == -2 ? -1 : vfp[j2];
                        ++j2;
                    }
                    ++this.nts;
                    if (this.nts > this.a3size) {
                        this.a3size += this.a3size;
                        int[][] newa3s = new int[this.rdim][this.a3size + 8 + 1];
                        int i = 0;
                        while (i < this.rdim) {
                            System.arraycopy(this.a3s[i], 0, newa3s[i], 0, this.a3s[i].length);
                            ++i;
                        }
                        this.a3s = newa3s;
                    }
                }
            }
            int i = 0;
            while (i < this.cdim) {
                int j = this.sbt_neigh_simp[t_bn][i][t];
                int j_bn = this.sbt_neigh_simp_bn[t_bn][i][t];
                if (j != -1 && this.sbt_visit[j_bn][j] != this.vnum) {
                    this.st2[tms] = j;
                    this.st2_bn[tms] = j_bn;
                    ++tms;
                }
                ++i;
            }
        }
        ret[0] = -1;
    }

    private void connect(int s, int s_bn) {
        if (s == -1) {
            return;
        }
        int i = 0;
        while (this.sbt_neigh_vert[s_bn][i][s] != this.p && i < this.cdim) {
            ++i;
        }
        if (this.sbt_visit[s_bn][s] == this.pnum) {
            return;
        }
        this.sbt_visit[s_bn][s] = this.pnum;
        int ccj = this.sbt_peak_simp[s_bn][s];
        int ccj_bn = this.sbt_peak_simp_bn[s_bn][s];
        int xfi = 0;
        while ((this.sbt_neigh_simp[ccj_bn][xfi][ccj] != s || this.sbt_neigh_simp_bn[ccj_bn][xfi][ccj] != s_bn) && xfi < this.cdim) {
            ++xfi;
        }
        int i2 = 0;
        while (i2 < this.cdim) {
            block10: {
                int l;
                int xf;
                int sf_bn;
                int sf;
                block12: {
                    int tf;
                    int tf_bn;
                    int sb_bn;
                    int sb;
                    block11: {
                        if (this.p == this.sbt_neigh_vert[s_bn][i2][s]) break block10;
                        sb = this.sbt_peak_simp[s_bn][s];
                        sb_bn = this.sbt_peak_simp_bn[s_bn][s];
                        sf = this.sbt_neigh_simp[s_bn][i2][s];
                        sf_bn = this.sbt_neigh_simp_bn[s_bn][i2][s];
                        xf = this.sbt_neigh_vert[ccj_bn][xfi][ccj];
                        if (this.sbt_peak_vert[sf_bn][sf] != -1) break block11;
                        l = 0;
                        while (this.sbt_neigh_vert[ccj_bn][l][ccj] != this.sbt_neigh_vert[s_bn][i2][s] && l < this.cdim) {
                            ++l;
                        }
                        sf_bn = this.sbt_neigh_simp_bn[ccj_bn][l][ccj];
                        sf = this.sbt_neigh_simp[ccj_bn][l][ccj];
                        if (this.sbt_peak_vert[sf_bn][sf] == -1) break block12;
                        break block10;
                    }
                    do {
                        int xb = xf;
                        l = 0;
                        while ((this.sbt_neigh_simp[sf_bn][l][sf] != sb || this.sbt_neigh_simp_bn[sf_bn][l][sf] != sb_bn) && l < this.cdim) {
                            ++l;
                        }
                        xf = this.sbt_neigh_vert[sf_bn][l][sf];
                        sb = sf;
                        sb_bn = sf_bn;
                        l = 0;
                        while (this.sbt_neigh_vert[sb_bn][l][sb] != xb && l < this.cdim) {
                            ++l;
                        }
                    } while (this.sbt_peak_vert[sf_bn = (tf_bn = this.sbt_neigh_simp_bn[sf_bn][l][sf])][sf = (tf = this.sbt_neigh_simp[sf_bn][l][sf])] != -1);
                }
                this.sbt_neigh_simp[s_bn][i2][s] = sf;
                this.sbt_neigh_simp_bn[s_bn][i2][s] = sf_bn;
                l = 0;
                while (this.sbt_neigh_vert[sf_bn][l][sf] != xf && l < this.cdim) {
                    ++l;
                }
                this.sbt_neigh_simp[sf_bn][l][sf] = s;
                this.sbt_neigh_simp_bn[sf_bn][l][sf] = s_bn;
                this.connect(sf, sf_bn);
            }
            ++i2;
        }
    }

    private void make_facets(int seen, int seen_bn, int[] ret, int[] ret_bn) {
        if (seen == -1) {
            ret[0] = -1;
            return;
        }
        this.sbt_peak_vert[seen_bn][seen] = this.p;
        int i = 0;
        while (i < this.cdim) {
            int n_bn = this.sbt_neigh_simp_bn[seen_bn][i][seen];
            int n = this.sbt_neigh_simp[seen_bn][i][seen];
            if (this.pnum != this.sbt_visit[n_bn][n]) {
                this.sbt_visit[n_bn][n] = this.pnum;
                if (this.sees(this.p, n, n_bn) != 0) {
                    this.make_facets(n, n_bn, this.voidp, this.voidp_bn);
                }
            }
            if (this.sbt_peak_vert[n_bn][n] == -1) {
                int q_bn;
                int q;
                this.ns = this.simplex_list != -1 ? this.simplex_list : this.new_block_simplex();
                this.ns_bn = this.simplex_list_bn;
                this.simplex_list = this.sbt_next[this.ns_bn][this.ns];
                this.simplex_list_bn = this.sbt_next_bn[this.ns_bn][this.ns];
                this.sbt_next[this.ns_bn][this.ns] = this.sbt_next[seen_bn][seen];
                this.sbt_next_bn[this.ns_bn][this.ns] = this.sbt_next_bn[seen_bn][seen];
                this.sbt_visit[this.ns_bn][this.ns] = this.sbt_visit[seen_bn][seen];
                this.sbt_mark[this.ns_bn][this.ns] = this.sbt_mark[seen_bn][seen];
                this.sbt_normal[this.ns_bn][this.ns] = this.sbt_normal[seen_bn][seen];
                this.sbt_normal_bn[this.ns_bn][this.ns] = this.sbt_normal_bn[seen_bn][seen];
                this.sbt_peak_vert[this.ns_bn][this.ns] = this.sbt_peak_vert[seen_bn][seen];
                this.sbt_peak_simp[this.ns_bn][this.ns] = this.sbt_peak_simp[seen_bn][seen];
                this.sbt_peak_simp_bn[this.ns_bn][this.ns] = this.sbt_peak_simp_bn[seen_bn][seen];
                this.sbt_peak_basis[this.ns_bn][this.ns] = this.sbt_peak_basis[seen_bn][seen];
                this.sbt_peak_basis_bn[this.ns_bn][this.ns] = this.sbt_peak_basis_bn[seen_bn][seen];
                int j = 0;
                while (j < this.rdim) {
                    this.sbt_neigh_vert[this.ns_bn][j][this.ns] = this.sbt_neigh_vert[seen_bn][j][seen];
                    this.sbt_neigh_simp[this.ns_bn][j][this.ns] = this.sbt_neigh_simp[seen_bn][j][seen];
                    this.sbt_neigh_simp_bn[this.ns_bn][j][this.ns] = this.sbt_neigh_simp_bn[seen_bn][j][seen];
                    this.sbt_neigh_basis[this.ns_bn][j][this.ns] = this.sbt_neigh_basis[seen_bn][j][seen];
                    this.sbt_neigh_basis_bn[this.ns_bn][j][this.ns] = this.sbt_neigh_basis_bn[seen_bn][j][seen];
                    ++j;
                }
                j = 0;
                while (j < this.cdim) {
                    q = this.sbt_neigh_basis[seen_bn][j][seen];
                    q_bn = this.sbt_neigh_basis_bn[seen_bn][j][seen];
                    if (q != -1) {
                        int[] nArray = this.bbt_ref_count[q_bn];
                        int n2 = q;
                        nArray[n2] = nArray[n2] + 1;
                    }
                    ++j;
                }
                this.sbt_visit[this.ns_bn][this.ns] = 0L;
                this.sbt_peak_vert[this.ns_bn][this.ns] = -1;
                this.sbt_normal[this.ns_bn][this.ns] = -1;
                this.sbt_peak_simp[this.ns_bn][this.ns] = seen;
                this.sbt_peak_simp_bn[this.ns_bn][this.ns] = seen_bn;
                q = this.sbt_neigh_basis[this.ns_bn][i][this.ns];
                q_bn = this.sbt_neigh_basis_bn[this.ns_bn][i][this.ns];
                if (q != -1) {
                    int[] nArray = this.bbt_ref_count[q_bn];
                    int n3 = q;
                    nArray[n3] = nArray[n3] - 1;
                    if (nArray[n3] == 0) {
                        this.bbt_next[q_bn][q] = this.basis_s_list;
                        this.bbt_next_bn[q_bn][q] = this.basis_s_list_bn;
                        this.bbt_ref_count[q_bn][q] = 0;
                        this.bbt_lscale[q_bn][q] = 0;
                        this.bbt_sqa[q_bn][q] = 0.0;
                        this.bbt_sqb[q_bn][q] = 0.0;
                        int l = 0;
                        while (l < 2 * this.rdim) {
                            this.bbt_vecs[q_bn][l][q] = 0.0;
                            ++l;
                        }
                        this.basis_s_list = q;
                        this.basis_s_list_bn = q_bn;
                    }
                }
                this.sbt_neigh_basis[this.ns_bn][i][this.ns] = -1;
                this.sbt_neigh_vert[this.ns_bn][i][this.ns] = this.p;
                j = 0;
                while ((this.sbt_neigh_simp[n_bn][j][n] != seen || this.sbt_neigh_simp_bn[n_bn][j][n] != seen_bn) && j < this.cdim) {
                    ++j;
                }
                int n4 = this.ns;
                this.sbt_neigh_simp[n_bn][j][n] = n4;
                this.sbt_neigh_simp[seen_bn][i][seen] = n4;
                this.sbt_neigh_simp_bn[seen_bn][i][seen] = this.ns_bn;
                this.sbt_neigh_simp_bn[n_bn][j][n] = this.ns_bn;
            }
            ++i;
        }
        ret[0] = this.ns;
        ret_bn[0] = this.ns_bn;
    }

    private void extend_simplices(int s, int s_bn, int[] ret, int[] ret_bn) {
        int j;
        if (this.sbt_visit[s_bn][s] == this.pnum) {
            if (this.sbt_peak_vert[s_bn][s] != -1) {
                ret[0] = this.sbt_neigh_simp[s_bn][this.cdim - 1][s];
                ret_bn[0] = this.sbt_neigh_simp_bn[s_bn][this.cdim - 1][s];
            } else {
                ret[0] = s;
                ret_bn[0] = s_bn;
            }
            return;
        }
        this.sbt_visit[s_bn][s] = this.pnum;
        this.sbt_neigh_vert[s_bn][this.cdim - 1][s] = this.p;
        int q = this.sbt_normal[s_bn][s];
        int q_bn = this.sbt_normal_bn[s_bn][s];
        if (q != -1) {
            int[] nArray = this.bbt_ref_count[q_bn];
            int n = q;
            nArray[n] = nArray[n] - 1;
            if (nArray[n] == 0) {
                this.bbt_next[q_bn][q] = this.basis_s_list;
                this.bbt_next_bn[q_bn][q] = this.basis_s_list_bn;
                this.bbt_ref_count[q_bn][q] = 0;
                this.bbt_lscale[q_bn][q] = 0;
                this.bbt_sqa[q_bn][q] = 0.0;
                this.bbt_sqb[q_bn][q] = 0.0;
                j = 0;
                while (j < 2 * this.rdim) {
                    this.bbt_vecs[q_bn][j][q] = 0.0;
                    ++j;
                }
                this.basis_s_list = q;
                this.basis_s_list_bn = q_bn;
            }
        }
        this.sbt_normal[s_bn][s] = -1;
        q = this.sbt_neigh_basis[s_bn][0][s];
        q_bn = this.sbt_neigh_basis_bn[s_bn][0][s];
        if (q != -1) {
            int[] nArray = this.bbt_ref_count[q_bn];
            int n = q;
            nArray[n] = nArray[n] - 1;
            if (nArray[n] == 0) {
                this.bbt_next[q_bn][q] = this.basis_s_list;
                this.bbt_ref_count[q_bn][q] = 0;
                this.bbt_lscale[q_bn][q] = 0;
                this.bbt_sqa[q_bn][q] = 0.0;
                this.bbt_sqb[q_bn][q] = 0.0;
                j = 0;
                while (j < 2 * this.rdim) {
                    this.bbt_vecs[q_bn][j][q] = 0.0;
                    ++j;
                }
                this.basis_s_list = q;
                this.basis_s_list_bn = q_bn;
            }
        }
        this.sbt_neigh_basis[s_bn][0][s] = -1;
        if (this.sbt_peak_vert[s_bn][s] == -1) {
            int[] esretp = new int[1];
            int[] esretp_bn = new int[1];
            this.extend_simplices(this.sbt_peak_simp[s_bn][s], this.sbt_peak_simp_bn[s_bn][s], esretp, esretp_bn);
            this.sbt_neigh_simp[s_bn][this.cdim - 1][s] = esretp[0];
            this.sbt_neigh_simp_bn[s_bn][this.cdim - 1][s] = esretp_bn[0];
            ret[0] = s;
            ret_bn[0] = s_bn;
            return;
        }
        int ns = this.simplex_list != -1 ? this.simplex_list : this.new_block_simplex();
        int ns_bn = this.simplex_list_bn;
        this.simplex_list = this.sbt_next[ns_bn][ns];
        this.simplex_list_bn = this.sbt_next_bn[ns_bn][ns];
        this.sbt_next[ns_bn][ns] = this.sbt_next[s_bn][s];
        this.sbt_next_bn[ns_bn][ns] = this.sbt_next_bn[s_bn][s];
        this.sbt_visit[ns_bn][ns] = this.sbt_visit[s_bn][s];
        this.sbt_mark[ns_bn][ns] = this.sbt_mark[s_bn][s];
        this.sbt_normal[ns_bn][ns] = this.sbt_normal[s_bn][s];
        this.sbt_normal_bn[ns_bn][ns] = this.sbt_normal_bn[s_bn][s];
        this.sbt_peak_vert[ns_bn][ns] = this.sbt_peak_vert[s_bn][s];
        this.sbt_peak_simp[ns_bn][ns] = this.sbt_peak_simp[s_bn][s];
        this.sbt_peak_simp_bn[ns_bn][ns] = this.sbt_peak_simp_bn[s_bn][s];
        this.sbt_peak_basis[ns_bn][ns] = this.sbt_peak_basis[s_bn][s];
        this.sbt_peak_basis_bn[ns_bn][ns] = this.sbt_peak_basis_bn[s_bn][s];
        j = 0;
        while (j < this.rdim) {
            this.sbt_neigh_vert[ns_bn][j][ns] = this.sbt_neigh_vert[s_bn][j][s];
            this.sbt_neigh_simp[ns_bn][j][ns] = this.sbt_neigh_simp[s_bn][j][s];
            this.sbt_neigh_simp_bn[ns_bn][j][ns] = this.sbt_neigh_simp_bn[s_bn][j][s];
            this.sbt_neigh_basis[ns_bn][j][ns] = this.sbt_neigh_basis[s_bn][j][s];
            this.sbt_neigh_basis_bn[ns_bn][j][ns] = this.sbt_neigh_basis_bn[s_bn][j][s];
            ++j;
        }
        int j2 = 0;
        while (j2 < this.cdim) {
            q = this.sbt_neigh_basis[s_bn][j2][s];
            q_bn = this.sbt_neigh_basis_bn[s_bn][j2][s];
            if (q != -1) {
                int[] nArray = this.bbt_ref_count[q_bn];
                int n = q;
                nArray[n] = nArray[n] + 1;
            }
            ++j2;
        }
        this.sbt_neigh_simp[s_bn][this.cdim - 1][s] = ns;
        this.sbt_neigh_simp_bn[s_bn][this.cdim - 1][s] = ns_bn;
        this.sbt_peak_vert[ns_bn][ns] = -1;
        this.sbt_peak_simp[ns_bn][ns] = s;
        this.sbt_peak_simp_bn[ns_bn][ns] = s_bn;
        this.sbt_neigh_vert[ns_bn][this.cdim - 1][ns] = this.sbt_peak_vert[s_bn][s];
        this.sbt_neigh_simp[ns_bn][this.cdim - 1][ns] = this.sbt_peak_simp[s_bn][s];
        this.sbt_neigh_simp_bn[ns_bn][this.cdim - 1][ns] = this.sbt_peak_simp_bn[s_bn][s];
        this.sbt_neigh_basis[ns_bn][this.cdim - 1][ns] = this.sbt_peak_basis[s_bn][s];
        this.sbt_neigh_basis_bn[ns_bn][this.cdim - 1][ns] = this.sbt_peak_basis_bn[s_bn][s];
        q = this.sbt_peak_basis[s_bn][s];
        q_bn = this.sbt_peak_basis_bn[s_bn][s];
        if (q != -1) {
            int[] nArray = this.bbt_ref_count[q_bn];
            int n = q;
            nArray[n] = nArray[n] + 1;
        }
        int i = 0;
        while (i < this.cdim) {
            int[] esretp = new int[1];
            int[] esretp_bn = new int[1];
            this.extend_simplices(this.sbt_neigh_simp[ns_bn][i][ns], this.sbt_neigh_simp_bn[ns_bn][i][ns], esretp, esretp_bn);
            this.sbt_neigh_simp[ns_bn][i][ns] = esretp[0];
            this.sbt_neigh_simp_bn[ns_bn][i][ns] = esretp_bn[0];
            ++i;
        }
        ret[0] = ns;
        ret_bn[0] = ns_bn;
    }

    private void search(int root, int root_bn, int[] ret, int[] ret_bn) {
        int tms = 0;
        this.st[tms] = this.sbt_peak_simp[root_bn][root];
        this.st_bn[tms] = this.sbt_peak_simp_bn[root_bn][root];
        ++tms;
        this.sbt_visit[root_bn][root] = this.pnum;
        if (this.sees(this.p, root, root_bn) == 0) {
            int i = 0;
            while (i < this.cdim) {
                this.st[tms] = this.sbt_neigh_simp[root_bn][i][root];
                this.st_bn[tms] = this.sbt_neigh_simp_bn[root_bn][i][root];
                ++tms;
                ++i;
            }
        }
        while (tms != 0) {
            int s;
            int s_bn;
            if (tms > this.ss) {
                this.ss += this.ss;
                int[] newst = new int[this.ss + 8 + 1];
                int[] newst_bn = new int[this.ss + 8 + 1];
                System.arraycopy(this.st, 0, newst, 0, this.st.length);
                System.arraycopy(this.st_bn, 0, newst_bn, 0, this.st_bn.length);
                this.st = newst;
                this.st_bn = newst_bn;
            }
            if (this.sbt_visit[s_bn = this.st_bn[--tms]][s = this.st[tms]] == this.pnum) continue;
            this.sbt_visit[s_bn][s] = this.pnum;
            if (this.sees(this.p, s, s_bn) == 0) continue;
            if (this.sbt_peak_vert[s_bn][s] == -1) {
                ret[0] = s;
                ret_bn[0] = s_bn;
                return;
            }
            int i = 0;
            while (i < this.cdim) {
                this.st[tms] = this.sbt_neigh_simp[s_bn][i][s];
                this.st_bn[tms] = this.sbt_neigh_simp_bn[s_bn][i][s];
                ++tms;
                ++i;
            }
        }
        ret[0] = -1;
    }

    public DelaunayClarkson(float[][] samples) throws VisADException {
        boolean positive;
        int q_bn;
        int q;
        boolean k = false;
        int[] retp = new int[1];
        int[] retp_bn = new int[1];
        int[] ret2p = new int[1];
        int[] ret2p_bn = new int[1];
        int[] curt = new int[1];
        int[] curt_bn = new int[1];
        int s_num = 0;
        this.dim = samples.length;
        int nrs = samples[0].length;
        int i = 1;
        while (i < this.dim) {
            nrs = Math.min(nrs, samples[i].length);
            ++i;
        }
        if (nrs <= this.dim) {
            throw new SetException("DelaunayClarkson: not enough samples");
        }
        if (this.dim > 8) {
            throw new SetException("DelaunayClarkson: dimension bound MAXDIM exceeded");
        }
        this.site_blocks = new float[this.dim][nrs];
        int j = 0;
        while (j < this.dim) {
            System.arraycopy(samples[j], 0, this.site_blocks[j], 0, nrs);
            ++j;
        }
        this.exact_bits = (int)(53.0 * Math.log(2.0) / ln2);
        this.b_err_min = 1.0950316209346055E-11;
        this.b_err_min_sq = this.b_err_min * this.b_err_min;
        this.cdim = 0;
        this.rdim = this.dim + 1;
        if (this.rdim > 8) {
            throw new SetException("dimension bound MAXDIM exceeded; rdim=" + this.rdim + "; dim=" + this.dim);
        }
        this.pnb = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
        this.pnb_bn = this.basis_s_list_bn;
        this.basis_s_list = this.bbt_next[this.pnb_bn][this.pnb];
        this.basis_s_list_bn = this.bbt_next_bn[this.pnb_bn][this.pnb];
        this.bbt_next[this.pnb_bn][this.pnb] = -1;
        this.ttbp = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
        this.ttbp_bn = this.basis_s_list_bn;
        this.basis_s_list = this.bbt_next[this.ttbp_bn][this.ttbp];
        this.basis_s_list_bn = this.bbt_next_bn[this.ttbp_bn][this.ttbp];
        this.bbt_next[this.ttbp_bn][this.ttbp] = -1;
        this.bbt_ref_count[this.ttbp_bn][this.ttbp] = 1;
        this.bbt_lscale[this.ttbp_bn][this.ttbp] = -1;
        this.bbt_sqa[this.ttbp_bn][this.ttbp] = 0.0;
        this.bbt_sqb[this.ttbp_bn][this.ttbp] = 0.0;
        int j2 = 0;
        while (j2 < 2 * this.rdim) {
            this.bbt_vecs[this.ttbp_bn][j2][this.ttbp] = 0.0;
            ++j2;
        }
        int root = -1;
        this.p = -2;
        this.ib = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
        this.ib_bn = this.basis_s_list_bn;
        this.basis_s_list = this.bbt_next[this.ib_bn][this.ib];
        this.basis_s_list_bn = this.bbt_next_bn[this.ib_bn][this.ib];
        this.bbt_ref_count[this.ib_bn][this.ib] = 1;
        this.bbt_vecs[this.ib_bn][this.rdim - 1][this.ib] = 1.0;
        this.bbt_vecs[this.ib_bn][2 * this.rdim - 1][this.ib] = 1.0;
        this.bbt_sqb[this.ib_bn][this.ib] = 1.0;
        this.bbt_sqa[this.ib_bn][this.ib] = 1.0;
        root = this.simplex_list != -1 ? this.simplex_list : this.new_block_simplex();
        int root_bn = this.simplex_list_bn;
        this.simplex_list = this.sbt_next[root_bn][root];
        this.simplex_list_bn = this.sbt_next_bn[root_bn][root];
        this.ch_root = root;
        this.ch_root_bn = root_bn;
        int s = this.simplex_list != -1 ? this.simplex_list : this.new_block_simplex();
        int s_bn = this.simplex_list_bn;
        this.simplex_list = this.sbt_next[s_bn][s];
        this.simplex_list_bn = this.sbt_next_bn[s_bn][s];
        this.sbt_next[s_bn][s] = this.sbt_next[root_bn][root];
        this.sbt_next_bn[s_bn][s] = this.sbt_next_bn[root_bn][root];
        this.sbt_visit[s_bn][s] = this.sbt_visit[root_bn][root];
        this.sbt_mark[s_bn][s] = this.sbt_mark[root_bn][root];
        this.sbt_normal[s_bn][s] = this.sbt_normal[root_bn][root];
        this.sbt_normal_bn[s_bn][s] = this.sbt_normal_bn[root_bn][root];
        this.sbt_peak_vert[s_bn][s] = this.sbt_peak_vert[root_bn][root];
        this.sbt_peak_simp[s_bn][s] = this.sbt_peak_simp[root_bn][root];
        this.sbt_peak_simp_bn[s_bn][s] = this.sbt_peak_simp_bn[root_bn][root];
        this.sbt_peak_basis[s_bn][s] = this.sbt_peak_basis[root_bn][root];
        this.sbt_peak_basis_bn[s_bn][s] = this.sbt_peak_basis_bn[root_bn][root];
        int i2 = 0;
        while (i2 < this.rdim) {
            this.sbt_neigh_vert[s_bn][i2][s] = this.sbt_neigh_vert[root_bn][i2][root];
            this.sbt_neigh_simp[s_bn][i2][s] = this.sbt_neigh_simp[root_bn][i2][root];
            this.sbt_neigh_simp_bn[s_bn][i2][s] = this.sbt_neigh_simp_bn[root_bn][i2][root];
            this.sbt_neigh_basis[s_bn][i2][s] = this.sbt_neigh_basis[root_bn][i2][root];
            this.sbt_neigh_basis_bn[s_bn][i2][s] = this.sbt_neigh_basis_bn[root_bn][i2][root];
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.cdim) {
            q = this.sbt_neigh_basis[root_bn][i3][root];
            q_bn = this.sbt_neigh_basis_bn[root_bn][i3][root];
            if (q != -1) {
                int[] nArray = this.bbt_ref_count[q_bn];
                int n = q;
                nArray[n] = nArray[n] + 1;
            }
            ++i3;
        }
        this.sbt_peak_vert[root_bn][root] = this.p;
        this.sbt_peak_simp[root_bn][root] = s;
        this.sbt_peak_simp_bn[root_bn][root] = s_bn;
        this.sbt_peak_simp[s_bn][s] = root;
        this.sbt_peak_simp_bn[s_bn][s] = root_bn;
        while (this.cdim < this.rdim) {
            boolean oof = false;
            this.p = s_num == 0 ? 0 : ++this.p;
            int i4 = 0;
            while (i4 < this.dim) {
                this.site_blocks[i4][this.p] = (float)Math.floor((double)this.site_blocks[i4][this.p] + 0.5);
                ++i4;
            }
            this.pnum = (++s_num * this.dim - 1) / this.dim + 2;
            ++this.cdim;
            this.sbt_neigh_vert[root_bn][this.cdim - 1][root] = this.sbt_peak_vert[root_bn][root];
            q = this.sbt_neigh_basis[root_bn][this.cdim - 1][root];
            q_bn = this.sbt_neigh_basis_bn[root_bn][this.cdim - 1][root];
            if (q != -1) {
                int[] nArray = this.bbt_ref_count[q_bn];
                int n = q;
                nArray[n] = nArray[n] - 1;
                if (nArray[n] == 0) {
                    this.bbt_next[q_bn][q] = this.basis_s_list;
                    this.bbt_next_bn[q_bn][q] = this.basis_s_list_bn;
                    this.bbt_ref_count[q_bn][q] = 0;
                    this.bbt_lscale[q_bn][q] = 0;
                    this.bbt_sqa[q_bn][q] = 0.0;
                    this.bbt_sqb[q_bn][q] = 0.0;
                    int l = 0;
                    while (l < 2 * this.rdim) {
                        this.bbt_vecs[q_bn][l][q] = 0.0;
                        ++l;
                    }
                    this.basis_s_list = q;
                    this.basis_s_list_bn = q_bn;
                }
            }
            this.sbt_neigh_basis[root_bn][this.cdim - 1][root] = -1;
            this.get_basis_sede(root, root_bn);
            if (this.sbt_neigh_vert[root_bn][0][root] == -2) {
                oof = true;
            } else {
                curt[0] = this.pnb;
                curt_bn[0] = this.pnb_bn;
                this.reduce(curt, curt_bn, this.p, root, root_bn, this.cdim);
                this.pnb = curt[0];
                this.pnb_bn = curt_bn[0];
                if (this.bbt_sqa[this.pnb_bn][this.pnb] != 0.0) {
                    oof = true;
                } else {
                    --this.cdim;
                }
            }
            if (oof) {
                this.extend_simplices(root, root_bn, this.voidp, this.voidp_bn);
                continue;
            }
            this.search(root, root_bn, retp, retp_bn);
            this.make_facets(retp[0], retp_bn[0], ret2p, ret2p_bn);
            this.connect(ret2p[0], ret2p_bn[0]);
        }
        int i5 = s_num;
        while (i5 < nrs) {
            ++this.p;
            ++s_num;
            int j3 = 0;
            while (j3 < this.dim) {
                this.site_blocks[j3][this.p] = (float)Math.floor((double)this.site_blocks[j3][this.p] + 0.5);
                ++j3;
            }
            this.pnum = (s_num * this.dim - 1) / this.dim + 2;
            this.search(root, root_bn, retp, retp_bn);
            this.make_facets(retp[0], retp_bn[0], ret2p, ret2p_bn);
            this.connect(ret2p[0], ret2p_bn[0]);
            ++i5;
        }
        this.a3size = this.rdim * nrs;
        this.a3s = new int[this.rdim][this.a3size + 8 + 1];
        this.visit_triang_gen(root, root_bn, 1, retp, retp_bn);
        this.visit_triang_gen(retp[0], retp_bn[0], 0, this.voidp, this.voidp_bn);
        this.site_blocks = null;
        this.st = null;
        this.st_bn = null;
        this.st2 = null;
        this.st2_bn = null;
        this.sbt_next = null;
        this.sbt_next_bn = null;
        this.sbt_visit = null;
        this.sbt_mark = null;
        this.sbt_normal = null;
        this.sbt_normal_bn = null;
        this.sbt_peak_vert = null;
        this.sbt_peak_simp = null;
        this.sbt_peak_simp_bn = null;
        this.sbt_peak_basis = null;
        this.sbt_peak_basis_bn = null;
        this.sbt_neigh_vert = null;
        this.sbt_neigh_simp = null;
        this.sbt_neigh_simp_bn = null;
        this.sbt_neigh_basis = null;
        this.sbt_neigh_basis_bn = null;
        this.bbt_next = null;
        this.bbt_next_bn = null;
        this.bbt_ref_count = null;
        this.bbt_lscale = null;
        this.bbt_sqa = null;
        this.bbt_sqb = null;
        this.bbt_vecs = null;
        int[] nverts = new int[nrs];
        int i6 = 0;
        while (i6 < nrs) {
            nverts[i6] = 0;
            ++i6;
        }
        int ntris = 0;
        int i7 = 0;
        while (i7 < this.nts) {
            positive = true;
            int j4 = 0;
            while (j4 < this.rdim) {
                if (this.a3s[j4][i7] < 0) {
                    positive = false;
                }
                ++j4;
            }
            if (positive) {
                ++ntris;
                int j5 = 0;
                while (j5 < this.rdim) {
                    int n = this.a3s[j5][i7];
                    nverts[n] = nverts[n] + 1;
                    ++j5;
                }
            }
            ++i7;
        }
        this.Vertices = new int[nrs][];
        int i8 = 0;
        while (i8 < nrs) {
            this.Vertices[i8] = new int[nverts[i8]];
            ++i8;
        }
        int i9 = 0;
        while (i9 < nrs) {
            nverts[i9] = 0;
            ++i9;
        }
        this.Tri = new int[ntris][this.rdim];
        int itri = 0;
        int i10 = 0;
        while (i10 < this.nts) {
            positive = true;
            int j6 = 0;
            while (j6 < this.rdim) {
                if (this.a3s[j6][i10] < 0) {
                    positive = false;
                }
                ++j6;
            }
            if (positive) {
                int j7 = 0;
                while (j7 < this.rdim) {
                    int n = this.a3s[j7][i10];
                    int n2 = nverts[n];
                    nverts[n] = n2 + 1;
                    this.Vertices[this.a3s[j7][i10]][n2] = itri;
                    this.Tri[itri][j7] = this.a3s[j7][i10];
                    ++j7;
                }
                ++itri;
            }
            ++i10;
        }
        this.a3s = null;
        this.finish_triang(samples);
    }
}

