/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import ucar.multiarray.AbstractAccessor;
import ucar.multiarray.Accessor;
import ucar.multiarray.MultiArray;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.OffsetIndexIterator;
import ucar.netcdf.AbstractNetcdf;
import ucar.netcdf.Attribute;
import ucar.netcdf.AttributeIterator;
import ucar.netcdf.AttributeSet;
import ucar.netcdf.Dimension;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.DimensionSet;
import ucar.netcdf.HTTPRandomAccessFile;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.RandomAccessFile;
import ucar.netcdf.Schema;
import ucar.netcdf.UnlimitedDimension;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;

public class NetcdfFile
extends AbstractNetcdf {
    static final int v1magic = 1128547841;
    static final int NC_BYTE = 1;
    static final int NC_CHAR = 2;
    static final int NC_SHORT = 3;
    static final int NC_INT = 4;
    static final int NC_FLOAT = 5;
    static final int NC_DOUBLE = 6;
    static final int NC_DIMENSION = 10;
    static final int NC_VARIABLE = 11;
    static final int NC_ATTRIBUTE = 12;
    static final int X_ALIGN = 4;
    static final int X_SIZEOF_CHAR = 1;
    static final int X_SIZEOF_BYTE = 1;
    static final int X_SIZEOF_SHORT = 2;
    static final int X_SIZEOF_INT = 4;
    static final int X_SIZEOF_FLOAT = 4;
    static final int X_SIZEOF_DOUBLE = 8;
    static final String _FillValue = "_FillValue";
    static final byte NC_FILL_BYTE = -127;
    static final byte NC_FILL_CHAR = 0;
    static final short NC_FILL_SHORT = -32767;
    static final int NC_FILL_INT = -2147483647;
    static final float NC_FILL_FLOAT = 9.96921E36f;
    static final double NC_FILL_DOUBLE = (double)9.96921E36f;
    private URL url;
    private File file;
    private RandomAccessFile raf;
    private UnlimitedDimension recDim;
    private int recsize;
    private boolean doFill;

    public NetcdfFile(File file, boolean clobber, boolean fill, Schema template) throws IOException {
        super(new Schema(template), true);
        if (!clobber && file.exists()) {
            throw new SecurityException(file.getName() + " exists");
        }
        this.file = file;
        this.raf = new RandomAccessFile(file, "rw");
        this.doFill = fill;
        this.compileBegins();
        this.initRecSize();
        this.writeV1();
        this.fillerup();
        this.url = null;
    }

    public NetcdfFile(String path, boolean clobber, boolean fill, Schema template) throws IOException {
        this(new File(path), clobber, fill, template);
    }

    public NetcdfFile(File file, boolean readonly) throws IOException {
        this.file = file;
        this.raf = new RandomAccessFile(file, readonly ? "r" : "rw");
        this.readV1(this.raf);
        this.initRecSize();
        this.doFill = true;
        this.url = null;
    }

    public NetcdfFile(String path, boolean ro) throws IOException {
        this(new File(path), ro);
    }

    public NetcdfFile(URL url) throws FileNotFoundException, IOException {
        String path = url.getFile();
        int i = path.indexOf(63);
        if (i != -1) {
            path = path.substring(0, i);
        }
        if (url.getProtocol().equalsIgnoreCase("file")) {
            this.url = null;
            this.file = new File(path);
            this.raf = new RandomAccessFile(path, "r", 204800);
        } else {
            this.url = new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
            this.file = null;
            this.raf = new HTTPRandomAccessFile(this.url, 204800);
        }
        this.readV1(this.raf);
        this.initRecSize();
        this.doFill = true;
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public void flush() throws IOException {
        this.raf.flush();
    }

    public final File getFile() {
        return this.file;
    }

    public final String getName() {
        return this.file != null ? this.file.getPath() : this.url.toString();
    }

    public synchronized void setFill(boolean pleaseFill) {
        this.doFill = pleaseFill;
    }

    public final boolean getFill() {
        return this.doFill;
    }

    public final UnlimitedDimension unlimitedDimension() {
        return this.recDim;
    }

    public void toCdl(StringBuffer buf) {
        buf.append("netcdf ");
        if (this.file != null) {
            buf.append(this.file.getName());
        } else {
            buf.append(this.url.toString());
        }
        buf.append(" ");
        super.toCdl(buf);
    }

    private int padsz(int xsz) {
        int rem = xsz % 4;
        if (rem == 0) {
            return 0;
        }
        return 4 - rem;
    }

    private int rndup(int xsz) {
        return xsz + this.padsz(xsz);
    }

    private int xszofV1String(String str) {
        int xsz = 4;
        return xsz += this.rndup(str.length());
    }

    private void writeV1String(String str) throws IOException {
        int rndup = str.length() % 4;
        if (rndup != 0) {
            rndup = 4 - rndup;
        }
        this.raf.writeInt(str.length());
        this.raf.writeBytes(str);
        while (rndup != 0) {
            this.raf.writeByte(0);
            --rndup;
        }
    }

    private String readV1String(DataInput hgs, int size) throws IOException {
        int rndup = size % 4;
        if (rndup != 0) {
            rndup = 4 - rndup;
        }
        byte[] bytes = new byte[size];
        hgs.readFully(bytes);
        hgs.skipBytes(rndup);
        return new String(bytes).intern();
    }

    private String readV1String(DataInput hgs) throws IOException {
        return this.readV1String(hgs, hgs.readInt());
    }

    private void writeV1Bytes(byte[] bytes) throws IOException {
        int rndup = bytes.length % 4;
        if (rndup != 0) {
            rndup = 4 - rndup;
        }
        this.raf.writeInt(bytes.length);
        this.raf.write(bytes);
        while (rndup != 0) {
            this.raf.writeByte(0);
            --rndup;
        }
    }

    private int v1TypeEncode(Class componentType) {
        if (componentType.isPrimitive()) {
            if (componentType.equals(Character.TYPE)) {
                return 2;
            }
            if (componentType.equals(Byte.TYPE)) {
                return 1;
            }
            if (componentType.equals(Short.TYPE)) {
                return 3;
            }
            if (componentType.equals(Integer.TYPE)) {
                return 4;
            }
            if (componentType.equals(Float.TYPE)) {
                return 5;
            }
            if (componentType.equals(Double.TYPE)) {
                return 6;
            }
        }
        throw new IllegalArgumentException("Not a V1 type: " + componentType);
    }

    private Class v1TypeDecode(int v1type) {
        switch (v1type) {
            case 2: {
                return Character.TYPE;
            }
            case 1: {
                return Byte.TYPE;
            }
            case 3: {
                return Short.TYPE;
            }
            case 4: {
                return Integer.TYPE;
            }
            case 5: {
                return Float.TYPE;
            }
            case 6: {
                return Double.TYPE;
            }
        }
        return null;
    }

    private int xszofElement(Class componentType) {
        if (componentType.equals(Short.TYPE)) {
            return 2;
        }
        if (componentType.equals(Integer.TYPE)) {
            return 4;
        }
        if (componentType.equals(Float.TYPE)) {
            return 4;
        }
        if (componentType.equals(Double.TYPE)) {
            return 8;
        }
        return 1;
    }

    private int initVsize(DimensionIterator ee, int xsz) {
        int size = 1;
        while (ee.hasNext()) {
            Dimension dim = ee.next();
            if (dim instanceof UnlimitedDimension) continue;
            size *= dim.getLength();
        }
        return size *= xsz;
    }

    private void writeV1(Dimension dim) throws IOException {
        this.writeV1String(dim.getName());
        if (dim instanceof UnlimitedDimension) {
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(dim.getLength());
        }
    }

    private int xszof(Dimension dim) {
        int xsz = this.xszofV1String(dim.getName());
        return xsz += 4;
    }

    private void writeV1(Attribute attr) throws IOException {
        this.writeV1String(attr.getName());
        if (attr.isString()) {
            this.raf.writeInt(2);
            this.writeV1String((String)attr.getValue());
            return;
        }
        int v1type = this.v1TypeEncode(attr.getComponentType());
        this.raf.writeInt(v1type);
        if (v1type == 2) {
            this.writeV1String((String)attr.getValue());
            return;
        }
        if (v1type == 1) {
            this.writeV1Bytes((byte[])attr.getValue());
            return;
        }
        int length = Array.getLength(attr.getValue());
        this.raf.writeInt(length);
        int ii = 0;
        while (ii < length) {
            switch (v1type) {
                case 3: {
                    this.raf.writeShort(((short[])attr.getValue())[ii]);
                    if (length % 2 == 0) break;
                    this.raf.writeShort(0);
                    break;
                }
                case 4: {
                    this.raf.writeInt(((int[])attr.getValue())[ii]);
                    break;
                }
                case 5: {
                    this.raf.writeFloat(((float[])attr.getValue())[ii]);
                    break;
                }
                case 6: {
                    this.raf.writeDouble(((double[])attr.getValue())[ii]);
                }
            }
            ++ii;
        }
    }

    private int xszof(Attribute attr) {
        int xsz = this.xszofV1String(attr.getName());
        xsz += 4;
        if (attr.isString()) {
            return xsz + this.xszofV1String((String)attr.getValue());
        }
        xsz += 4;
        int v1type = this.v1TypeEncode(attr.getComponentType());
        int length = Array.getLength(attr.getValue());
        switch (v1type) {
            case 1: 
            case 2: {
                xsz += this.rndup(length);
                break;
            }
            case 3: {
                xsz += this.rndup(length * 2);
                break;
            }
            case 4: {
                xsz += length * 4;
                break;
            }
            case 5: {
                xsz += length * 4;
                break;
            }
            case 6: {
                xsz += length * 8;
            }
        }
        return xsz;
    }

    private Dimension[] readV1DimensionArray(DataInput hgs) throws IOException {
        int numrecs = hgs.readInt();
        int tag = hgs.readInt();
        if (tag != 10 && tag != 0) {
            throw new IllegalArgumentException("Not a netcdf file (dimensions)");
        }
        int ndims = hgs.readInt();
        Dimension[] dimArray = new Dimension[ndims];
        int ii = 0;
        while (ii < ndims) {
            String name = this.readV1String(hgs);
            int length = hgs.readInt();
            if (length == 0) {
                if (this.recDim != null) {
                    throw new IllegalArgumentException("Multiple UnlimitedDimensions");
                }
                this.recDim = new UnlimitedDimension(name, numrecs);
                dimArray[ii] = this.recDim;
            } else {
                dimArray[ii] = new Dimension(name, length);
            }
            ++ii;
        }
        return dimArray;
    }

    private void writeV1(DimensionSet ds) throws IOException {
        this.writeV1numrecs();
        int size = ds.size();
        if (size != 0) {
            this.raf.writeInt(10);
        } else {
            this.raf.writeInt(0);
        }
        this.raf.writeInt(size);
        DimensionIterator ee = ds.iterator();
        while (ee.hasNext()) {
            this.writeV1(ee.next());
        }
    }

    private int xszof(DimensionSet ds) {
        int xsz = 4;
        xsz += 4;
        xsz += 4;
        DimensionIterator ee = ds.iterator();
        while (ee.hasNext()) {
            xsz += this.xszof(ee.next());
        }
        return xsz;
    }

    private void writeV1numrecs() throws IOException {
        if (this.recDim == null) {
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(this.recDim.getLength());
        }
    }

    private void writeV1(AttributeSet as) throws IOException {
        int size = as.size();
        if (size != 0) {
            this.raf.writeInt(12);
        } else {
            this.raf.writeInt(0);
        }
        this.raf.writeInt(size);
        AttributeIterator ee = as.iterator();
        while (ee.hasNext()) {
            this.writeV1(ee.next());
        }
    }

    private Object readV1AttrVal(DataInput hgs) throws IOException {
        int v1type = hgs.readInt();
        int nelems = hgs.readInt();
        switch (v1type) {
            case 2: {
                int rndup = nelems % 4;
                if (rndup != 0) {
                    rndup = 4 - rndup;
                }
                char[] values = new char[nelems];
                int ii = 0;
                while (ii < nelems) {
                    values[ii] = (char)hgs.readUnsignedByte();
                    ++ii;
                }
                hgs.skipBytes(rndup);
                return values;
            }
            case 1: {
                int rndup = nelems % 4;
                if (rndup != 0) {
                    rndup = 4 - rndup;
                }
                byte[] values = new byte[nelems];
                hgs.readFully(values);
                hgs.skipBytes(rndup);
                return values;
            }
            case 3: {
                short[] values = new short[nelems];
                int ii = 0;
                while (ii < nelems) {
                    values[ii] = hgs.readShort();
                    ++ii;
                }
                if (nelems % 2 != 0) {
                    hgs.skipBytes(2);
                }
                return values;
            }
            case 4: {
                int[] values = new int[nelems];
                int ii = 0;
                while (ii < nelems) {
                    values[ii] = hgs.readInt();
                    ++ii;
                }
                return values;
            }
            case 5: {
                float[] values = new float[nelems];
                int ii = 0;
                while (ii < nelems) {
                    values[ii] = hgs.readFloat();
                    ++ii;
                }
                return values;
            }
            case 6: {
                double[] values = new double[nelems];
                int ii = 0;
                while (ii < nelems) {
                    values[ii] = hgs.readDouble();
                    ++ii;
                }
                return values;
            }
        }
        return null;
    }

    private Attribute[] readV1AttributeArray(DataInput hgs) throws IOException {
        int tag = hgs.readInt();
        if (tag != 12 && tag != 0) {
            throw new IllegalArgumentException("Not a netcdf file (attributes)");
        }
        int nelems = hgs.readInt();
        Attribute[] attrArray = new Attribute[nelems];
        int ii = 0;
        while (ii < nelems) {
            String name = this.readV1String(hgs);
            Object value = this.readV1AttrVal(hgs);
            attrArray[ii] = new Attribute(name, value);
            ++ii;
        }
        return attrArray;
    }

    private int xszof(AttributeSet as) {
        int xsz = 4;
        xsz += 4;
        AttributeIterator ee = as.iterator();
        while (ee.hasNext()) {
            xsz += this.xszof(ee.next());
        }
        return xsz;
    }

    private V1Io V1IoFactory(ProtoVariable proto) {
        Class componentType = proto.getComponentType();
        V1Io io = null;
        if (componentType.equals(Character.TYPE)) {
            io = new V1CharacterIo(proto);
        } else if (componentType.equals(Byte.TYPE)) {
            io = new V1ByteIo(proto);
        } else if (componentType.equals(Short.TYPE)) {
            io = new V1ShortIo(proto);
        } else if (componentType.equals(Integer.TYPE)) {
            io = new V1IntegerIo(proto);
        } else if (componentType.equals(Float.TYPE)) {
            io = new V1FloatIo(proto);
        } else if (componentType.equals(Double.TYPE)) {
            io = new V1DoubleIo(proto);
        }
        return io;
    }

    protected Accessor ioFactory(ProtoVariable proto) {
        return this.V1IoFactory(proto);
    }

    private void writeV1(Variable var) throws IOException {
        this.writeV1String(var.getName());
        this.raf.writeInt(var.getRank());
        DimensionIterator ee = var.getDimensionIterator();
        while (ee.hasNext()) {
            this.raf.writeInt(this.indexOf(ee.next()));
        }
        this.writeV1(var.getAttributes());
        this.raf.writeInt(this.v1TypeEncode(var.getComponentType()));
        V1Io io = (V1Io)var.io;
        this.raf.writeInt(io.vsize);
        this.raf.writeInt(io.begin);
    }

    private int xszof(Variable var) {
        int xsz = this.xszofV1String(var.getName());
        xsz += 4;
        xsz += var.getRank() * 4;
        xsz += this.xszof(var.getAttributes());
        xsz += 4;
        xsz += 4;
        return xsz += 4;
    }

    private void readV1VarArray(DataInput hgs, Dimension[] allDims) throws IOException {
        int tag = hgs.readInt();
        if (tag != 11 && tag != 0) {
            throw new IllegalArgumentException("Not a netcdf file (variables)");
        }
        int nelems = hgs.readInt();
        int ii = 0;
        while (ii < nelems) {
            String name = this.readV1String(hgs);
            int ndims = hgs.readInt();
            Dimension[] dimArray = new Dimension[ndims];
            int jj = 0;
            while (jj < ndims) {
                dimArray[jj] = allDims[hgs.readInt()];
                ++jj;
            }
            Attribute[] attrArray = this.readV1AttributeArray(hgs);
            Class type = this.v1TypeDecode(hgs.readInt());
            ProtoVariable proto = new ProtoVariable(name, type, dimArray, attrArray);
            V1Io io = this.V1IoFactory(proto);
            io.vsize = hgs.readInt();
            io.begin = hgs.readInt();
            try {
                this.add(proto, io);
            }
            catch (InstantiationException ie) {
                throw new Error();
            }
            catch (IllegalAccessException iae) {
                throw new Error();
            }
            catch (InvocationTargetException ite) {
                throw (RuntimeException)ite.getTargetException();
            }
            ++ii;
        }
    }

    private void writeV1(int size, VariableIterator ee) throws IOException {
        if (size != 0) {
            this.raf.writeInt(11);
        } else {
            this.raf.writeInt(0);
        }
        this.raf.writeInt(size);
        while (ee.hasNext()) {
            this.writeV1(ee.next());
        }
    }

    private int xszof(VariableIterator ee) {
        int xsz = 4;
        xsz += 4;
        while (ee.hasNext()) {
            xsz += this.xszof(ee.next());
        }
        return xsz;
    }

    private void writeV1() throws IOException {
        this.raf.writeInt(1128547841);
        this.writeV1(this.getDimensions());
        this.writeV1(this.getAttributes());
        this.writeV1(this.size(), this.iterator());
    }

    private int xszof() {
        int xsz = 4;
        xsz += this.xszof(this.getDimensions());
        xsz += this.xszof(this.getAttributes());
        return xsz += this.xszof(this.iterator());
    }

    private void readV1(DataInput hgs) throws IOException {
        int magic = hgs.readInt();
        if (magic != 1128547841) {
            throw new IllegalArgumentException("Not a netcdf file");
        }
        Dimension[] dimArray = this.readV1DimensionArray(hgs);
        int ii = 0;
        while (ii < dimArray.length) {
            this.putDimension(dimArray[ii]);
            ++ii;
        }
        Attribute[] gAttrArray = this.readV1AttributeArray(hgs);
        int ii2 = 0;
        while (ii2 < gAttrArray.length) {
            this.putAttribute(gAttrArray[ii2]);
            ++ii2;
        }
        this.readV1VarArray(hgs, dimArray);
    }

    private void compileBegins() {
        V1Io io;
        Variable var;
        int index = this.xszof();
        VariableIterator ee = this.iterator();
        while (ee.hasNext()) {
            var = ee.next();
            if (var.isUnlimited()) continue;
            io = (V1Io)var.io;
            io.begin = index;
            index += io.vsize;
        }
        ee = this.iterator();
        while (ee.hasNext()) {
            var = ee.next();
            if (!var.isUnlimited()) continue;
            if (this.recDim == null) {
                Dimension dim0 = var.getDimensionIterator().next();
                if (!(dim0 instanceof UnlimitedDimension)) {
                    throw new IllegalArgumentException("Unlimited Dim not leftmost");
                }
                this.recDim = (UnlimitedDimension)dim0;
            }
            io = (V1Io)var.io;
            io.begin = index;
            index += io.vsize;
        }
    }

    private void initRecSize() {
        this.recsize = 0;
        VariableIterator ee = this.iterator();
        while (ee.hasNext()) {
            Variable var = ee.next();
            if (!var.isUnlimited()) continue;
            V1Io io = (V1Io)var.io;
            if (this.recsize == 0 && !ee.hasNext()) {
                this.recsize = this.initVsize(var.getDimensionIterator(), io.xsz);
                break;
            }
            this.recsize += io.vsize;
        }
    }

    void fillRec(int recno) throws IOException {
        VariableIterator ee = this.iterator();
        while (ee.hasNext()) {
            Variable var = ee.next();
            if (!var.isUnlimited()) continue;
            V1Io io = (V1Io)var.io;
            long offset = (long)io.begin + (long)recno * (long)this.recsize;
            io.fillO(offset);
        }
    }

    private void fillerup() throws IOException {
        if (!this.doFill) {
            return;
        }
        VariableIterator ee = this.iterator();
        while (ee.hasNext()) {
            Variable var = ee.next();
            if (var.isUnlimited()) continue;
            V1Io io = (V1Io)var.io;
            io.fillO(io.begin);
        }
        if (this.recDim != null) {
            int nrecs = this.recDim.getLength();
            int recno = 0;
            while (recno < nrecs) {
                this.fillRec(recno);
                ++recno;
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private final class V1ByteIo
    extends V1Io {
        V1ByteIo(ProtoVariable var) {
            super(var);
        }

        void readArray(long offset, Object into, int begin, int nelems) throws IOException {
            byte[] values = (byte[])into;
            NetcdfFile.this.raf.seek(offset);
            NetcdfFile.this.raf.read(values, begin, nelems);
        }

        public byte getByte(int[] index) throws IOException {
            NetcdfFile.this.raf.seek(this.computeOffset(index));
            return NetcdfFile.this.raf.readByte();
        }

        public Object get(int[] index) throws IOException {
            return new Byte(this.getByte(index));
        }

        void writeArray(long offset, Object from, int begin, int nelems) throws IOException {
            byte[] values = (byte[])from;
            NetcdfFile.this.raf.seek(offset);
            NetcdfFile.this.raf.write(values, begin, nelems);
        }

        public void setByte(int[] index, byte value) throws IOException {
            if (this.isUnlimited) {
                this.checkfill(index[0] + 1);
            }
            NetcdfFile.this.raf.seek(this.computeOffset(index));
            NetcdfFile.this.raf.writeByte(value);
        }

        public void set(int[] index, Object value) throws IOException {
            this.setByte(index, ((Number)value).byteValue());
        }

        final void fill(DataOutput dos, int nbytes, Attribute fAttr) throws IOException {
            int fv = -127;
            if (fAttr != null) {
                fv = fAttr.getNumericValue().byteValue();
            }
            int ii = 0;
            while (ii < nbytes) {
                dos.write(fv);
                ++ii;
            }
        }
    }

    private final class V1CharacterIo
    extends V1Io {
        V1CharacterIo(ProtoVariable var) {
            super(var);
        }

        void readArray(long offset, Object into, int begin, int nelems) throws IOException {
            char[] values = (char[])into;
            NetcdfFile.this.raf.seek(offset);
            int end = begin + nelems;
            int ii = begin;
            while (ii < end) {
                values[ii] = (char)NetcdfFile.this.raf.readUnsignedByte();
                ++ii;
            }
        }

        public char getChar(int[] index) throws IOException {
            NetcdfFile.this.raf.seek(this.computeOffset(index));
            return (char)NetcdfFile.this.raf.readUnsignedByte();
        }

        public Object get(int[] index) throws IOException {
            return new Character(this.getChar(index));
        }

        void writeArray(long offset, Object from, int begin, int nelems) throws IOException {
            char[] values = (char[])from;
            NetcdfFile.this.raf.seek(offset);
            int end = begin + nelems;
            int ii = begin;
            while (ii < end) {
                NetcdfFile.this.raf.writeByte((byte)values[ii]);
                ++ii;
            }
        }

        public void setChar(int[] index, char value) throws IOException {
            if (this.isUnlimited) {
                this.checkfill(index[0] + 1);
            }
            NetcdfFile.this.raf.seek(this.computeOffset(index));
            NetcdfFile.this.raf.writeByte((byte)value);
        }

        public void set(int[] index, Object value) throws IOException {
            this.setChar(index, ((Character)value).charValue());
        }

        final void fill(DataOutput dos, int nbytes, Attribute fAttr) throws IOException {
            byte fv = 0;
            if (fAttr != null) {
                fv = fAttr.getLength() == 0 ? (byte)0 : fAttr.getNumericValue().byteValue();
            }
            int ii = 0;
            while (ii < nbytes) {
                dos.write(fv);
                ++ii;
            }
        }
    }

    private final class V1DoubleIo
    extends V1Io {
        V1DoubleIo(ProtoVariable var) {
            super(var);
        }

        void readArray(long offset, Object into, int begin, int nelems) throws IOException {
            double[] values = (double[])into;
            NetcdfFile.this.raf.seek(offset);
            int end = begin + nelems;
            int ii = begin;
            while (ii < end) {
                values[ii] = NetcdfFile.this.raf.readDouble();
                ++ii;
            }
        }

        public double getDouble(int[] index) throws IOException {
            NetcdfFile.this.raf.seek(this.computeOffset(index));
            return NetcdfFile.this.raf.readDouble();
        }

        public Object get(int[] index) throws IOException {
            return new Double(this.getDouble(index));
        }

        void writeArray(long offset, Object from, int begin, int nelems) throws IOException {
            double[] values = (double[])from;
            NetcdfFile.this.raf.seek(offset);
            int end = begin + nelems;
            int ii = begin;
            while (ii < end) {
                NetcdfFile.this.raf.writeDouble(values[ii]);
                ++ii;
            }
        }

        public void setDouble(int[] index, double value) throws IOException {
            if (this.isUnlimited) {
                this.checkfill(index[0] + 1);
            }
            NetcdfFile.this.raf.seek(this.computeOffset(index));
            NetcdfFile.this.raf.writeDouble(value);
        }

        public void set(int[] index, Object value) throws IOException {
            this.setDouble(index, ((Number)value).doubleValue());
        }

        final void fill(DataOutput dos, int nbytes, Attribute fAttr) throws IOException {
            double fv = 9.96921E36f;
            if (fAttr != null) {
                fv = fAttr.getNumericValue().doubleValue();
            }
            int ii = 0;
            while (ii < nbytes) {
                dos.writeDouble(fv);
                ++ii;
            }
        }
    }

    private final class V1FloatIo
    extends V1Io {
        V1FloatIo(ProtoVariable var) {
            super(var);
        }

        void readArray(long offset, Object into, int begin, int nelems) throws IOException {
            float[] values = (float[])into;
            NetcdfFile.this.raf.seek(offset);
            int end = begin + nelems;
            int ii = begin;
            while (ii < end) {
                values[ii] = NetcdfFile.this.raf.readFloat();
                ++ii;
            }
        }

        public float getFloat(int[] index) throws IOException {
            NetcdfFile.this.raf.seek(this.computeOffset(index));
            return NetcdfFile.this.raf.readFloat();
        }

        public Object get(int[] index) throws IOException {
            return new Float(this.getFloat(index));
        }

        void writeArray(long offset, Object from, int begin, int nelems) throws IOException {
            float[] values = (float[])from;
            NetcdfFile.this.raf.seek(offset);
            int end = begin + nelems;
            int ii = begin;
            while (ii < end) {
                NetcdfFile.this.raf.writeFloat(values[ii]);
                ++ii;
            }
        }

        public void setFloat(int[] index, float value) throws IOException {
            if (this.isUnlimited) {
                this.checkfill(index[0] + 1);
            }
            NetcdfFile.this.raf.seek(this.computeOffset(index));
            NetcdfFile.this.raf.writeFloat(value);
        }

        public void set(int[] index, Object value) throws IOException {
            this.setFloat(index, ((Number)value).floatValue());
        }

        final void fill(DataOutput dos, int nbytes, Attribute fAttr) throws IOException {
            float fv = 9.96921E36f;
            if (fAttr != null) {
                fv = fAttr.getNumericValue().floatValue();
            }
            int ii = 0;
            while (ii < nbytes) {
                dos.writeFloat(fv);
                ++ii;
            }
        }
    }

    private final class V1IntegerIo
    extends V1Io {
        V1IntegerIo(ProtoVariable var) {
            super(var);
        }

        void readArray(long offset, Object into, int begin, int nelems) throws IOException {
            int[] values = (int[])into;
            NetcdfFile.this.raf.seek(offset);
            int end = begin + nelems;
            int ii = begin;
            while (ii < end) {
                values[ii] = NetcdfFile.this.raf.readInt();
                ++ii;
            }
        }

        public int getInt(int[] index) throws IOException {
            NetcdfFile.this.raf.seek(this.computeOffset(index));
            return NetcdfFile.this.raf.readInt();
        }

        public Object get(int[] index) throws IOException {
            return new Integer(this.getInt(index));
        }

        void writeArray(long offset, Object from, int begin, int nelems) throws IOException {
            int[] values = (int[])from;
            NetcdfFile.this.raf.seek(offset);
            int end = begin + nelems;
            int ii = begin;
            while (ii < end) {
                NetcdfFile.this.raf.writeInt(values[ii]);
                ++ii;
            }
        }

        public void setInt(int[] index, int value) throws IOException {
            if (this.isUnlimited) {
                this.checkfill(index[0] + 1);
            }
            NetcdfFile.this.raf.seek(this.computeOffset(index));
            NetcdfFile.this.raf.writeInt(value);
        }

        public void set(int[] index, Object value) throws IOException {
            this.setInt(index, ((Number)value).intValue());
        }

        final void fill(DataOutput dos, int nbytes, Attribute fAttr) throws IOException {
            int fv = -2147483647;
            if (fAttr != null) {
                fv = fAttr.getNumericValue().intValue();
            }
            int ii = 0;
            while (ii < nbytes) {
                dos.writeInt(fv);
                ++ii;
            }
        }
    }

    abstract class V1Io
    extends AbstractAccessor {
        private final ProtoVariable meta;
        private final int[] lengths;
        byte[] fillbytes;
        int vsize;
        int begin;
        final boolean isUnlimited;
        final int[] dsizes;
        int xsz;

        protected V1Io(ProtoVariable proto) {
            this.meta = proto;
            this.lengths = proto.getLengths();
            this.initFillValue(proto);
            this.vsize = NetcdfFile.this.rndup(NetcdfFile.this.initVsize(proto.getDimensionIterator(), NetcdfFile.this.xszofElement(proto.getComponentType())));
            this.begin = 0;
            this.isUnlimited = proto.isUnlimited();
            this.dsizes = this.compileDsizes(proto.getLengths());
            this.xsz = NetcdfFile.this.xszofElement(proto.getComponentType());
        }

        abstract void readArray(long var1, Object var3, int var4, int var5) throws IOException;

        private final int iocount(int[] origin, int[] shape) {
            int product = 1;
            int minIndex = 0;
            if (this.isUnlimited) {
                minIndex = 1;
            }
            int ii = shape.length - 1;
            while (ii >= minIndex) {
                int si = shape[ii];
                product *= si;
                if (origin[ii] != 0 || si < this.lengths[ii]) break;
                --ii;
            }
            return product;
        }

        public MultiArray copyout(int[] origin, int[] shape) throws IOException {
            int[] dimensions = (int[])shape.clone();
            int[] products = new int[dimensions.length];
            int product = MultiArrayImpl.numberOfElements(dimensions, products);
            Object storage = Array.newInstance(this.meta.getComponentType(), product);
            int contig = this.iocount(origin, shape);
            int[] limits = (int[])dimensions.clone();
            int ii = 0;
            while (ii < limits.length) {
                int n = ii;
                limits[n] = limits[n] + origin[ii];
                ++ii;
            }
            OffsetIndexIterator odo = new OffsetIndexIterator(origin, limits);
            int cnt = 0;
            int begin = 0;
            while (odo.notDone()) {
                long offset = this.computeOffset(odo.value());
                this.readArray(offset, storage, begin, contig);
                ++cnt;
                odo.advance(contig);
                begin += contig;
            }
            MultiArrayImpl result = new MultiArrayImpl(dimensions, products, storage);
            return result;
        }

        abstract void writeArray(long var1, Object var3, int var4, int var5) throws IOException;

        public void copyin(int[] origin, MultiArray data) throws IOException {
            if (data instanceof MultiArrayImpl) {
                this.copyin(origin, (MultiArrayImpl)data);
            } else {
                if (this.isUnlimited) {
                    this.checkfill(origin[0] + data.getLengths()[0]);
                }
                super.copyin(origin, data);
            }
        }

        public void copyin(int[] origin, MultiArrayImpl data) throws IOException {
            int[] dimensions = data.getLengths();
            int contig = this.iocount(origin, dimensions);
            int ii = 0;
            while (ii < dimensions.length) {
                int n = ii;
                dimensions[n] = dimensions[n] + origin[ii];
                ++ii;
            }
            if (this.isUnlimited) {
                this.checkfill(dimensions[0]);
            }
            Object storage = data.storage;
            OffsetIndexIterator odo = new OffsetIndexIterator(origin, dimensions);
            int begin = 0;
            while (odo.notDone()) {
                long offset = this.computeOffset(odo.value());
                this.writeArray(offset, storage, begin, contig);
                odo.advance(contig);
                begin += contig;
            }
        }

        public Object toArray() throws IOException {
            return this.toArray(null, null, null);
        }

        public Object toArray(Object dst, int[] origin, int[] shape) throws IOException {
            int rank = this.getRank();
            if (origin == null) {
                origin = new int[rank];
            } else if (origin.length != rank) {
                throw new IllegalArgumentException("Rank Mismatch");
            }
            int[] shp = null;
            if (shape == null) {
                shp = (int[])this.lengths.clone();
            } else if (shape.length == rank) {
                shp = (int[])shape.clone();
            } else {
                throw new IllegalArgumentException("Rank Mismatch");
            }
            int product = MultiArrayImpl.numberOfElements(shp);
            dst = MultiArrayImpl.fixDest(dst, product, this.meta.getComponentType());
            int contig = this.iocount(origin, shp);
            int[] limits = (int[])shp.clone();
            int ii = 0;
            while (ii < limits.length) {
                int n = ii;
                limits[n] = limits[n] + origin[ii];
                ++ii;
            }
            OffsetIndexIterator odo = new OffsetIndexIterator(origin, limits);
            int begin = 0;
            while (odo.notDone()) {
                long offset = this.computeOffset(odo.value());
                this.readArray(offset, dst, begin, contig);
                odo.advance(contig);
                begin += contig;
            }
            return dst;
        }

        private final int[] compileDsizes(int[] shape) {
            int[] ds = new int[shape.length];
            int product = 1;
            int ii = shape.length - 1;
            while (ii >= 0) {
                if (ii != 0 || !this.isUnlimited) {
                    product *= shape[ii];
                }
                ds[ii] = product;
                --ii;
            }
            return ds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void checkfill(int newLength) throws IOException {
            UnlimitedDimension unlimitedDimension = NetcdfFile.this.recDim;
            synchronized (unlimitedDimension) {
                int length = NetcdfFile.this.recDim.getLength();
                if (newLength > length) {
                    if (NetcdfFile.this.doFill) {
                        while (length < newLength) {
                            NetcdfFile.this.fillRec(length);
                            ++length;
                        }
                    }
                    NetcdfFile.this.recDim.setLength(newLength);
                    NetcdfFile.this.raf.seek(4L);
                    NetcdfFile.this.raf.writeInt(NetcdfFile.this.recDim.getLength());
                }
            }
        }

        final int getRank() {
            return this.dsizes.length;
        }

        final boolean isScalar() {
            return 0 == this.getRank();
        }

        final long computeOffset(int[] origin) {
            if (this.isScalar()) {
                return this.begin;
            }
            if (this.getRank() == 1) {
                if (this.isUnlimited) {
                    return this.begin + origin[0] * NetcdfFile.this.recsize;
                }
                return this.begin + origin[0] * this.xsz;
            }
            int end = this.dsizes.length - 1;
            int lcoord = origin[end];
            int index = 0;
            if (this.isUnlimited) {
                ++index;
            }
            while (index < end) {
                lcoord += this.dsizes[index + 1] * origin[index];
                ++index;
            }
            lcoord *= this.xsz;
            if (this.isUnlimited) {
                lcoord += origin[0] * NetcdfFile.this.recsize;
            }
            return lcoord += this.begin;
        }

        abstract void fill(DataOutput var1, int var2, Attribute var3) throws IOException;

        private final void initFillValue(Attribute fAttr) {
            int nbytes = 32;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(32);
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                this.fill(dos, 32, fAttr);
                dos.flush();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.fillbytes = bos.toByteArray();
        }

        private final void initFillValue(ProtoVariable proto) {
            this.initFillValue(proto.getAttribute(NetcdfFile._FillValue));
        }

        private final void initFillValue(Attribute[] attrArray) {
            Attribute fAttr = null;
            int ii = 0;
            while (ii < attrArray.length) {
                if (attrArray[ii].getName() == NetcdfFile._FillValue) {
                    fAttr = attrArray[ii];
                }
                ++ii;
            }
            this.initFillValue(fAttr);
        }

        void fillO(long offset) throws IOException {
            NetcdfFile.this.raf.seek(offset);
            int remainder = this.vsize;
            while (remainder >= this.fillbytes.length) {
                NetcdfFile.this.raf.write(this.fillbytes);
                remainder -= this.fillbytes.length;
            }
            if (remainder > 0) {
                int ii = 0;
                while (ii < remainder) {
                    NetcdfFile.this.raf.write(this.fillbytes[ii]);
                    ++ii;
                }
            }
        }

        void fill(int recno) throws IOException {
            long offset = this.begin;
            if (this.isUnlimited) {
                offset += (long)recno * (long)NetcdfFile.this.recsize;
            }
            this.fillO(offset);
        }
    }

    private final class V1ShortIo
    extends V1Io {
        V1ShortIo(ProtoVariable var) {
            super(var);
        }

        void readArray(long offset, Object into, int begin, int nelems) throws IOException {
            short[] values = (short[])into;
            NetcdfFile.this.raf.seek(offset);
            int end = begin + nelems;
            int ii = begin;
            while (ii < end) {
                values[ii] = NetcdfFile.this.raf.readShort();
                ++ii;
            }
        }

        public short getShort(int[] index) throws IOException {
            NetcdfFile.this.raf.seek(this.computeOffset(index));
            return NetcdfFile.this.raf.readShort();
        }

        public Object get(int[] index) throws IOException {
            return new Short(this.getShort(index));
        }

        void writeArray(long offset, Object from, int begin, int nelems) throws IOException {
            short[] values = (short[])from;
            NetcdfFile.this.raf.seek(offset);
            int end = begin + nelems;
            int ii = begin;
            while (ii < end) {
                NetcdfFile.this.raf.writeShort(values[ii]);
                ++ii;
            }
        }

        public void setShort(int[] index, short value) throws IOException {
            if (this.isUnlimited) {
                this.checkfill(index[0] + 1);
            }
            NetcdfFile.this.raf.seek(this.computeOffset(index));
            NetcdfFile.this.raf.writeShort(value);
        }

        public void set(int[] index, Object value) throws IOException {
            this.setShort(index, ((Number)value).shortValue());
        }

        final void fill(DataOutput dos, int nbytes, Attribute fAttr) throws IOException {
            int fv = -32767;
            if (fAttr != null) {
                fv = fAttr.getNumericValue().shortValue();
            }
            int ii = 0;
            while (ii < nbytes) {
                dos.writeShort(fv);
                ++ii;
            }
        }
    }
}

