/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.NoSuchElementException;
import nom.tam.fits.CardTable;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.ImageData;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;

public class Header {
    private CardTable cards = new CardTable();
    private int mark = -2;

    public Header() {
    }

    public int size() {
        return this.cards.size();
    }

    public Header(BufferedDataInputStream is) throws TruncatedFileException, IOException {
        this.read(is);
    }

    public Header(String[] newCards) {
        int i = 0;
        while (i < newCards.length) {
            this.cards.addElement(new HeaderCard(newCards[i]));
            ++i;
        }
    }

    public int trueDataSize() {
        if (!this.isValidHeader()) {
            return 0;
        }
        int size = 1;
        int naxis = this.getIntValue("NAXIS", 0);
        int axis = 1;
        while (axis <= naxis) {
            int nval = this.getIntValue("NAXIS" + axis, 0);
            if (axis != 1 || nval != 0) {
                size *= nval;
            }
            ++axis;
        }
        size += this.getIntValue("PCOUNT", 0);
        size *= this.getIntValue("GCOUNT", 1);
        return size *= Math.abs(this.getIntValue("BITPIX", 0)) / 8;
    }

    public int paddedDataSize() {
        return (this.trueDataSize() + 2879) / 2880 * 2880;
    }

    public int headerSize() {
        if (!this.isValidHeader()) {
            return 0;
        }
        return (this.cards.size() * 80 + 2879) / 2880 * 2880;
    }

    public boolean isValidHeader() {
        return this.cards != null && this.cards.size() >= 5;
    }

    public String getCard(int n) {
        try {
            if (n >= 0 && n < this.cards.size()) {
                return this.cards.elementAt(n).toString();
            }
        }
        catch (NoSuchElementException e) {}
        return null;
    }

    public String getKey(int n) {
        String card = this.getCard(n);
        if (card == null) {
            return null;
        }
        String key = card.substring(0, 8);
        if (key.charAt(0) == ' ') {
            return "";
        }
        if (key.indexOf(32) >= 1) {
            key = key.substring(0, key.indexOf(32));
        }
        return key;
    }

    public long getLongValue(String key, long dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        try {
            String v = fcard.getValue();
            if (v != null) {
                return Long.parseLong(v);
            }
        }
        catch (NumberFormatException e) {}
        return dft;
    }

    public double getDoubleValue(String key, double dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        try {
            String v = fcard.getValue();
            if (v != null) {
                return new Double(v);
            }
        }
        catch (NumberFormatException e) {}
        return dft;
    }

    public boolean getBooleanValue(String key, boolean dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        String val = fcard.getValue();
        if (val == null) {
            return dft;
        }
        if (val.equals("T")) {
            return true;
        }
        if (val.equals("F")) {
            return false;
        }
        return dft;
    }

    public long getLongValue(String key) {
        return this.getLongValue(key, 0L);
    }

    public double getDoubleValue(String key) {
        return this.getDoubleValue(key, 0.0);
    }

    public boolean getBooleanValue(String key) {
        return this.getBooleanValue(key, false);
    }

    public int getIntValue(String key, int dft) {
        return (int)this.getLongValue(key, dft);
    }

    public int getIntValue(String key) {
        return (int)this.getLongValue(key);
    }

    public float getFloatValue(String key, float dft) {
        return (float)this.getDoubleValue(key, dft);
    }

    public float getFloatValue(String key) {
        return (float)this.getDoubleValue(key);
    }

    public String getStringValue(String key) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null || !fcard.isStringValue()) {
            return null;
        }
        return fcard.getValue();
    }

    protected void addLine(HeaderCard fcard) {
        if (fcard != null) {
            if (this.markSet() && this.getMark() < this.cards.size() - 1) {
                this.cards.insertElementAt(fcard, this.getMark() + 1);
                this.setMark(this.getMark() + 1);
            } else {
                this.cards.addElement(fcard);
            }
        }
    }

    protected void addLine(String card) throws HeaderCardException {
        this.addLine(new HeaderCard(card));
    }

    public static Header readHeader(BufferedDataInputStream dis) throws TruncatedFileException, IOException {
        Header myHeader = new Header();
        try {
            myHeader.read(dis);
        }
        catch (EOFException e) {
            return null;
        }
        return myHeader;
    }

    public void read(BufferedDataInputStream dis) throws TruncatedFileException, IOException {
        byte[] buffer = new byte[80];
        boolean firstCard = true;
        while (true) {
            String endKey;
            String key;
            int need = 80;
            try {
                while (need > 0) {
                    int len = dis.read(buffer, 80 - need, need);
                    if (len == 0) {
                        throw new TruncatedFileException();
                    }
                    need -= len;
                }
            }
            catch (EOFException e) {
                if (firstCard) {
                    throw e;
                }
                throw new TruncatedFileException(e.getMessage());
            }
            HeaderCard fcard = new HeaderCard(new String(buffer));
            if (firstCard && ((key = fcard.getKey()) == null || !key.equals("SIMPLE") && !key.equals("XTENSION"))) {
                throw new IOException("Not a FITS file");
            }
            this.addLine(fcard);
            if (!fcard.isKeyValuePair() && (endKey = fcard.getKey()) != null && endKey.equals("END")) break;
            firstCard = false;
        }
        int blanks = 36 - this.cards.size() % 36;
        if (blanks != 36) {
            while (blanks > 0) {
                int need = 80;
                try {
                    while (need > 0) {
                        int len = dis.read(buffer, 80 - need, need);
                        if (len == 0) {
                            throw new TruncatedFileException();
                        }
                        need -= len;
                    }
                }
                catch (EOFException e) {
                    throw new TruncatedFileException(e.getMessage());
                }
                --blanks;
            }
        }
    }

    protected HeaderCard findCard(String key) {
        HeaderCard card = this.cards.findKey(key);
        if (card == null) {
            this.unsetMark();
            return null;
        }
        int newMark = this.cards.indexOf(card);
        this.setMark(newMark);
        return card;
    }

    public String findKey(String key) {
        HeaderCard card = this.findCard(key);
        if (card == null) {
            return null;
        }
        return card.toString();
    }

    boolean replaceKey(String oldKey, String newKey) throws HeaderCardException {
        HeaderCard oldCard = this.findCard(oldKey);
        if (oldCard == null) {
            return false;
        }
        String v = oldCard.getValue();
        if (v != null && oldCard.isStringValue()) {
            v = "'" + v + "'";
        }
        String c = oldCard.getComment();
        HeaderCard newCard = new HeaderCard(newKey, v, c);
        this.cards.setElementAt(newCard, this.getMark());
        return true;
    }

    public void write(BufferedDataOutputStream dos) throws FitsException {
        this.checkEnd();
        if (this.cards.size() <= 0) {
            return;
        }
        String[] header = new String[this.cards.size()];
        int i = 0;
        while (i < this.cards.size()) {
            header[i] = this.cards.elementAt(i).toString();
            ++i;
        }
        try {
            dos.writePrimitiveArray(header);
            int pad = 36 - this.cards.size() % 36;
            if (pad != 36) {
                String blankBuffer = "                                                                                ";
                int i2 = 0;
                while (i2 < pad) {
                    dos.writeBytes(blankBuffer);
                    ++i2;
                }
            }
        }
        catch (IOException e) {
            throw new FitsException("IO Error writing header: " + e);
        }
    }

    public void addBooleanValue(String key, boolean val, String comment) throws HeaderCardException {
        String tf = val ? "T" : "F";
        this.replaceCard(key, tf, comment);
    }

    public void addFloatValue(String key, float val, String comment) throws HeaderCardException {
        String sval = "" + val;
        this.replaceCard(key, sval, comment);
    }

    public void addDoubleValue(String key, double val, String comment) throws HeaderCardException {
        String sval = "" + val;
        this.replaceCard(key, sval, comment);
    }

    public void addStringValue(String key, String val, String comment) throws HeaderCardException {
        if (val == null) {
            val = "";
        }
        if (val.length() < 8) {
            val = (val + "        ").substring(0, 8);
        } else if (val.length() > 67) {
            val = val.substring(0, 67);
        }
        val = "'" + val + "'";
        this.replaceCard(key, val, comment);
    }

    public void replaceCard(String key, String val, String comment) throws HeaderCardException {
        HeaderCard fcard = new HeaderCard(key, val, comment);
        int oldMark = this.getMark();
        this.findCard(key);
        if (this.markSet()) {
            this.cards.setElementAt(fcard, this.getMark());
        } else {
            this.setMark(oldMark);
            this.insertCard(fcard);
        }
    }

    public void addIntValue(String key, int val, String comment) throws HeaderCardException {
        this.addLongValue(key, val, comment);
    }

    public void addLongValue(String key, long val, String comment) throws HeaderCardException {
        String sval = "" + val;
        this.replaceCard(key, sval, comment);
    }

    private void insertCard(HeaderCard fcard) {
        if (this.markSet() && this.getMark() < this.cards.size() - 1) {
            this.cards.insertElementAt(fcard, this.getMark() + 1);
            ++this.mark;
        } else {
            this.cards.addElement(fcard);
            this.unsetMark();
        }
    }

    public static String formatFields(String key, String val, String comment) throws HeaderCardException {
        return new HeaderCard(key, val, comment).toString();
    }

    public void insertCard(String card) {
        this.insertCard(new HeaderCard(card));
    }

    public void insertCommentStyle(String header, String value) throws HeaderCardException {
        this.insertCard(new HeaderCard(header, null, value));
    }

    public void insertComment(String value) throws HeaderCardException {
        this.insertCommentStyle("COMMENT", value);
    }

    public void insertHistory(String value) throws HeaderCardException {
        this.insertCommentStyle("HISTORY", value);
    }

    public boolean markSet() {
        return this.mark >= -1;
    }

    public int getMark() {
        return this.mark;
    }

    public void setMark(int newMark) {
        this.mark = newMark;
    }

    public void unsetMark() {
        this.mark = -2;
    }

    public void deleteKey(String key) {
        this.findCard(key);
        if (this.markSet()) {
            this.cards.removeElementAt(this.getMark());
        }
        if (this.getMark() >= this.cards.size()) {
            this.unsetMark();
        }
    }

    public void removeCardAt(int i) {
        if (i < this.cards.size() && i >= 0) {
            this.cards.removeElementAt(i);
        }
        if (i < this.cards.size()) {
            this.setMark(i);
        } else {
            this.unsetMark();
        }
    }

    public final boolean containsKey(String key) {
        return this.cards.containsKey(key);
    }

    public void pointToData(Data o) throws FitsException {
        if (!(o instanceof ImageData)) {
            throw new FitsException("Cannot point to class:" + o.getClass().getName());
        }
        this.pointToImage(o.getData());
    }

    protected void pointToImage(Object o) throws FitsException {
        String str;
        int bitpix;
        if (o == null) {
            this.nullImage();
        }
        String classname = o.getClass().getName();
        int[] dimens = ArrayFuncs.getDimensions(o);
        if (dimens == null || dimens.length == 0) {
            throw new FitsException("Image data object not array");
        }
        switch (classname.charAt(dimens.length)) {
            case 'B': {
                bitpix = 8;
                break;
            }
            case 'S': {
                bitpix = 16;
                break;
            }
            case 'I': {
                bitpix = 32;
                break;
            }
            case 'J': {
                bitpix = 64;
                break;
            }
            case 'F': {
                bitpix = -32;
                break;
            }
            case 'D': {
                bitpix = -64;
                break;
            }
            default: {
                throw new FitsException("Invalid Object Type for FITS data");
            }
        }
        if (!(this.getBooleanValue("SIMPLE") || (str = this.getStringValue("XTENSION")) != null && str.equals("IMAGE") && this.getMark() == 0)) {
            this.setSimple(true);
        }
        this.setBitpix(bitpix);
        this.setNaxes(dimens.length);
        int i = 1;
        while (i <= dimens.length) {
            if (dimens[i - 1] == -1) {
                throw new FitsException("Unfilled array for dimension: " + i);
            }
            this.setNaxis(i, dimens[i - 1]);
            ++i;
        }
        this.setPcount(0);
        this.setGcount(1);
        this.setExtend(true);
    }

    void nullImage() {
        this.setSimple(true);
        this.setBitpix(8);
        this.setNaxes(0);
        this.setPcount(0);
        this.setGcount(0);
        this.setExtend(true);
        int i = 1;
        while (i < 9) {
            this.deleteKey("NAXIS" + i);
            ++i;
        }
    }

    void setSimple(boolean val) {
        this.deleteKey("SIMPLE");
        this.deleteKey("XTENSION");
        if (this.cards.size() >= 0) {
            this.setMark(-1);
        }
        try {
            this.addBooleanValue("SIMPLE", val, "Java FITS: " + new Date());
        }
        catch (HeaderCardException e) {
            throw new RuntimeException("Impossible error: " + e.getMessage());
        }
    }

    void setXtension(String val) {
        this.deleteKey("SIMPLE");
        this.deleteKey("XTENSION");
        if (this.cards.size() >= 0) {
            this.setMark(-1);
        }
        try {
            this.addStringValue("XTENSION", val, "Java FITS: " + new Date());
        }
        catch (HeaderCardException e) {
            throw new RuntimeException("Impossible error: " + e.getMessage());
        }
    }

    void setBitpix(int val) {
        if (this.cards.size() > 1) {
            this.setMark(0);
        }
        try {
            this.addIntValue("BITPIX", val, null);
        }
        catch (HeaderCardException e) {
            throw new RuntimeException("Impossible error: " + e.getMessage());
        }
    }

    void setNaxes(int val) {
        if (this.cards.size() > 2) {
            this.setMark(1);
        }
        try {
            this.addIntValue("NAXIS", val, "Dimensionality");
        }
        catch (HeaderCardException e) {
            throw new RuntimeException("Impossible error: " + e.getMessage());
        }
    }

    void checkEnd() {
        HeaderCard blankCard = null;
        int i = 0;
        while (i < this.cards.size()) {
            HeaderCard card = this.cards.elementAt(i);
            try {
                if (!card.isKeyValuePair() && card.getKey().equals("END")) {
                    if (i == this.cards.size() - 1) {
                        return;
                    }
                    if (blankCard == null) {
                        blankCard = new HeaderCard(null, null, null);
                    }
                    this.cards.setElementAt(blankCard, i);
                }
            }
            catch (HeaderCardException e) {
                // empty catch block
            }
            ++i;
        }
        this.unsetMark();
        try {
            this.addLine("END");
        }
        catch (HeaderCardException e) {
            throw new RuntimeException("Impossible error: " + e.getMessage());
        }
    }

    void setNaxis(int dim, int val) {
        if (dim <= 0) {
            return;
        }
        if (this.cards.size() > 2 + dim) {
            this.setMark(1 + dim);
        }
        try {
            this.addIntValue("NAXIS" + dim, val, null);
        }
        catch (HeaderCardException e) {
            throw new RuntimeException("Impossible error: " + e.getMessage());
        }
    }

    void setGcount(int val) {
        try {
            this.addIntValue("GCOUNT", val, "Number of Groups");
        }
        catch (HeaderCardException e) {
            throw new RuntimeException("Impossible error: " + e.getMessage());
        }
    }

    void setPcount(int val) {
        try {
            this.addIntValue("PCOUNT", val, "Group params/Variable cols buffer");
        }
        catch (HeaderCardException e) {
            throw new RuntimeException("Impossible error: " + e.getMessage());
        }
    }

    void setExtend(boolean val) {
        try {
            this.addBooleanValue("EXTEND", val, "Can there be extensions?");
        }
        catch (HeaderCardException e) {
            throw new RuntimeException("Impossible error: " + e.getMessage());
        }
    }

    protected boolean primaryToImage() {
        if (this.getBooleanValue("SIMPLE") && this.getMark() == 0) {
            this.setXtension("IMAGE");
            return true;
        }
        String str = this.getStringValue("XTENSION");
        if (str == null) {
            this.setXtension("IMAGE");
            return true;
        }
        return str.equals("IMAGE");
    }

    protected boolean imageToPrimary() {
        if (this.getBooleanValue("SIMPLE") && this.getMark() == 0) {
            return true;
        }
        String str = this.getStringValue("XTENSION");
        if (str == null) {
            this.setSimple(true);
            return true;
        }
        if (str.equals("IMAGE") && this.getMark() == 0) {
            this.setSimple(true);
            return true;
        }
        return false;
    }

    protected void dumpHeader(PrintStream ps) {
        int i = 0;
        while (i < this.cards.size()) {
            ps.println(this.cards.elementAt(i));
            ++i;
        }
    }
}

