/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.TableHDU;
import nom.tam.util.BufferedDataInputStream;

public class AsciiTableHDU
extends TableHDU {
    public AsciiTableHDU(Header header) throws FitsException {
        super(header);
        if (!this.isHeader()) {
            throw new FitsException("Not a valid ascii table header");
        }
    }

    public static boolean isHeader(Header header) {
        String card0 = header.getCard(0);
        return card0 != null && card0.startsWith("XTENSION= 'TABLE   '");
    }

    public boolean isHeader() {
        return AsciiTableHDU.isHeader(this.myHeader);
    }

    Data manufactureData() throws FitsException {
        throw new FitsException("ASCII tables are currently not supported");
    }

    public void readData(BufferedDataInputStream stream) throws FitsException {
        try {
            this.skipData(stream);
        }
        catch (IOException e) {
            // empty catch block
        }
        throw new FitsException("ASCII tables are currently not supported");
    }

    public void info() {
        System.out.println("ASCII Table: unimplemented");
    }
}

