/*
 * Decompiled with CFR 0.152.
 */
package dods.dap.Server;

import dods.dap.BaseType;
import dods.dap.DSequence;
import dods.dap.NoSuchVariableException;
import dods.dap.Server.CEEvaluator;
import dods.dap.Server.InvalidOperatorException;
import dods.dap.Server.RegExpException;
import dods.dap.Server.RelOps;
import dods.dap.Server.SBHException;
import dods.dap.Server.SDODSException;
import dods.dap.Server.ServerMethods;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public abstract class SDSequence
extends DSequence
implements ServerMethods,
RelOps {
    private static final boolean _Debug = false;
    private boolean Project = false;
    private boolean Synthesized = false;
    private boolean ReadMe = false;

    public SDSequence() {
    }

    public SDSequence(String n) {
        super(n);
    }

    public Vector getRowVector() throws NoSuchVariableException {
        if (this.getRowCount() == 0) {
            Vector<BaseType> rv = new Vector<BaseType>();
            int i = 0;
            while (i < this.elementCount(false)) {
                rv.add(this.getVar(i));
                ++i;
            }
            this.addRow(rv);
        }
        return this.getRow(0);
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        if (constrained && !this.Project) {
            return;
        }
        super.printDecl(os, space, print_semi, constrained);
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (!this.Project) {
            return;
        }
        if (print_decl_p) {
            this.printDecl(os, space, false, true);
            os.print(" = ");
        }
        os.print("{ ");
        try {
            boolean firstPass = true;
            Vector v = this.getRowVector();
            Enumeration e2 = v.elements();
            while (e2.hasMoreElements()) {
                BaseType bt = (BaseType)e2.nextElement();
                if (!((ServerMethods)((Object)bt)).isProject()) continue;
                if (!firstPass) {
                    os.print(", ");
                }
                bt.printVal(os, "", false);
                firstPass = false;
            }
        }
        catch (NoSuchVariableException e) {
            os.println("Very Bad Things Happened When I Tried To Print A Row Of The Sequence: " + this.getName());
        }
        os.print(" }");
        if (print_decl_p) {
            os.println(";");
        }
    }

    public void setProject(boolean state, boolean all) {
        this.Project = state;
        if (all) {
            Enumeration e = this.varTemplate.elements();
            while (e.hasMoreElements()) {
                ServerMethods sm = (ServerMethods)e.nextElement();
                sm.setProject(state);
            }
        }
    }

    public void setProject(boolean state) {
        this.setProject(state, true);
    }

    public boolean isProject() {
        return this.Project;
    }

    public boolean equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Equals (=) operator does not work with the type SDSequence!");
    }

    public boolean not_equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Not Equals (!=) operator does not work with the type SDSequence!");
    }

    public boolean greater(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Greater Than (>)operator does not work with the type SDSequence!");
    }

    public boolean greater_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("GreaterThan or equals (<=) operator does not work with the type SDSequence!");
    }

    public boolean less(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan (<) operator does not work with the type SDSequence!");
    }

    public boolean less_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan oe equals (<=) operator does not work with the type SDSequence!");
    }

    public boolean regexp(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Regular Expression's don't work with the type SDSequence!");
    }

    public void setSynthesized(boolean state) {
        this.Synthesized = state;
    }

    public boolean isSynthesized() {
        return this.Synthesized;
    }

    public void setRead(boolean state) {
        this.ReadMe = state;
    }

    public void setAllReadFlags(boolean state) {
        this.ReadMe = state;
        Enumeration e = this.varTemplate.elements();
        while (e.hasMoreElements()) {
            ServerMethods sm = (ServerMethods)e.nextElement();
            sm.setRead(state);
        }
    }

    public boolean isRead() {
        return this.ReadMe;
    }

    public abstract boolean read(String var1, Object var2) throws NoSuchVariableException, IOException, EOFException;

    public void serialize(String dataset, DataOutputStream sink, CEEvaluator ce, Object specialO) throws NoSuchVariableException, SDODSException, IOException {
        boolean moreToRead = true;
        while (moreToRead) {
            if (!this.isRead()) {
                moreToRead = this.read(dataset, specialO);
            }
            if (ce.evalClauses(specialO)) {
                this.writeMarker(sink, DSequence.START_OF_INSTANCE);
                Enumeration e = this.varTemplate.elements();
                while (e.hasMoreElements()) {
                    ServerMethods sm = (ServerMethods)e.nextElement();
                    if (!sm.isProject()) continue;
                    sm.serialize(dataset, sink, ce, specialO);
                }
            }
            if (!moreToRead) continue;
            this.setAllReadFlags(false);
        }
        this.writeMarker(sink, DSequence.END_OF_SEQUENCE);
    }
}

