/*
 * Decompiled with CFR 0.152.
 */
package dods.dap.Server;

import dods.dap.BaseType;
import dods.dap.NoSuchFunctionException;
import dods.dap.Server.BTFunction;
import dods.dap.Server.BTFunctionClause;
import dods.dap.Server.BoolFunction;
import dods.dap.Server.BoolFunctionClause;
import dods.dap.Server.DereferenceClause;
import dods.dap.Server.FunctionLibrary;
import dods.dap.Server.RelOpClause;
import dods.dap.Server.SDODSException;
import dods.dap.Server.SubClause;
import dods.dap.Server.TopLevelClause;
import dods.dap.Server.ValueClause;
import java.util.List;

public class ClauseFactory {
    protected FunctionLibrary functionLibrary;

    public ClauseFactory() {
        this.functionLibrary = new FunctionLibrary();
    }

    public ClauseFactory(FunctionLibrary functionLibrary) {
        this.functionLibrary = functionLibrary;
    }

    public TopLevelClause newRelOpClause(int operator, SubClause lhs, List rhs) throws SDODSException {
        return new RelOpClause(operator, lhs, rhs);
    }

    public TopLevelClause newBoolFunctionClause(String functionName, List children) throws SDODSException, NoSuchFunctionException {
        BoolFunction function = this.functionLibrary.getBoolFunction(functionName);
        if (function == null) {
            if (this.functionLibrary.getBTFunction(functionName) != null) {
                throw new NoSuchFunctionException("The function " + functionName + "() does not return a " + "boolean value, and must be used in a comparison or " + "as an argument to another function.");
            }
            throw new NoSuchFunctionException("This server does not support a " + functionName + "() function");
        }
        return new BoolFunctionClause(function, children);
    }

    public SubClause newValueClause(BaseType value, boolean constant) throws SDODSException {
        return new ValueClause(value, constant);
    }

    public SubClause newBTFunctionClause(String functionName, List children) throws SDODSException, NoSuchFunctionException {
        BTFunction function = this.functionLibrary.getBTFunction(functionName);
        if (function == null) {
            if (this.functionLibrary.getBoolFunction(functionName) != null) {
                throw new NoSuchFunctionException("The function " + functionName + "() cannot be used as a " + "sub-expression in a constraint clause");
            }
            throw new NoSuchFunctionException("This server does not support a " + functionName + "() function");
        }
        return new BTFunctionClause(function, children);
    }

    public SubClause newDereferenceClause(String url) throws SDODSException {
        return new DereferenceClause(url);
    }
}

