/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BadSemanticsException;
import dods.dap.BaseType;
import dods.dap.ClientIO;
import dods.dap.DConstructor;
import dods.dap.DataReadException;
import dods.dap.NoSuchVariableException;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import dods.dap.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class DSequence
extends DConstructor
implements ClientIO {
    protected static byte START_OF_INSTANCE = (byte)90;
    protected static byte END_OF_SEQUENCE = (byte)-91;
    protected Vector varTemplate = new Vector();
    protected Vector allValues = new Vector();
    private int level = 0;

    public DSequence() {
        this(null);
    }

    public DSequence(String n) {
        super(n);
    }

    public Object clone() {
        DSequence s = (DSequence)super.clone();
        s.varTemplate = new Vector();
        int i = 0;
        while (i < this.varTemplate.size()) {
            BaseType bt = (BaseType)this.varTemplate.elementAt(i);
            s.varTemplate.addElement(bt.clone());
            ++i;
        }
        s.allValues = new Vector();
        int i2 = 0;
        while (i2 < this.allValues.size()) {
            Vector rowVec = (Vector)this.allValues.elementAt(i2);
            Vector<Object> newVec = new Vector<Object>();
            int j = 0;
            while (j < rowVec.size()) {
                BaseType bt = (BaseType)rowVec.elementAt(j);
                newVec.addElement(bt.clone());
                ++j;
            }
            s.allValues.addElement(newVec);
            ++i2;
        }
        return s;
    }

    public String getTypeName() {
        return "Sequence";
    }

    protected final void setLevel(int level) {
        this.level = level;
    }

    protected final int getLevel() {
        return this.level;
    }

    public int elementCount(boolean leaves) {
        if (!leaves) {
            return this.varTemplate.size();
        }
        int count = 0;
        Enumeration e = this.varTemplate.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            count += bt.elementCount(leaves);
        }
        return count;
    }

    public void addVariable(BaseType v, int part) {
        v.setParent(this);
        this.varTemplate.addElement(v);
        if (v instanceof DSequence) {
            ((DSequence)v).setLevel(this.getLevel() + 1);
        }
    }

    public final void addRow(Vector row) {
        this.allValues.addElement(row);
    }

    public final Vector getRow(int row) {
        return (Vector)this.allValues.elementAt(row);
    }

    public final void delRow(int row) {
        this.allValues.removeElementAt(row);
    }

    public int getRowCount() {
        return this.allValues.size();
    }

    public BaseType getVariable(String name) throws NoSuchVariableException {
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            String aggregate = name.substring(0, dotIndex);
            String field = name.substring(dotIndex + 1);
            BaseType aggRef = this.getVariable(aggregate);
            if (aggRef instanceof DConstructor) {
                return ((DConstructor)aggRef).getVariable(field);
            }
        } else {
            Enumeration e = this.varTemplate.elements();
            while (e.hasMoreElements()) {
                BaseType v = (BaseType)e.nextElement();
                if (!v.getName().equals(name)) continue;
                return v;
            }
        }
        throw new NoSuchVariableException("DSequence: getVariable()");
    }

    public BaseType getVar(int index) throws NoSuchVariableException {
        if (index < this.varTemplate.size()) {
            return (BaseType)this.varTemplate.elementAt(index);
        }
        throw new NoSuchVariableException("DSequence.getVariable(" + index + " - 1)");
    }

    public BaseType getVariable(int row, String name) throws NoSuchVariableException {
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            String aggregate = name.substring(0, dotIndex);
            String field = name.substring(dotIndex + 1);
            BaseType aggRef = this.getVariable(aggregate);
            if (aggRef instanceof DConstructor) {
                return ((DConstructor)aggRef).getVariable(field);
            }
        } else {
            Vector selectedRow = (Vector)this.allValues.elementAt(row);
            Enumeration e = selectedRow.elements();
            while (e.hasMoreElements()) {
                BaseType v = (BaseType)e.nextElement();
                if (!v.getName().equals(name)) continue;
                return v;
            }
        }
        throw new NoSuchVariableException("DSequence: getVariable()");
    }

    public Enumeration getVariables() {
        return this.varTemplate.elements();
    }

    public void checkSemantics(boolean all) throws BadSemanticsException {
        super.checkSemantics(all);
        Util.uniqueNames(this.varTemplate, this.getName(), this.getTypeName());
        if (all) {
            Enumeration e = this.varTemplate.elements();
            while (e.hasMoreElements()) {
                BaseType bt = (BaseType)e.nextElement();
                bt.checkSemantics(true);
            }
        }
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        os.println(space + this.getTypeName() + " {");
        Enumeration e = this.varTemplate.elements();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            bt.printDecl(os, space + "    ", true, constrained);
        }
        os.print(space + "} " + this.getName());
        if (print_semi) {
            os.println(";");
        }
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (print_decl_p) {
            this.printDecl(os, space, false);
            os.print(" = ");
        }
        os.print("{ ");
        Enumeration e1 = this.allValues.elements();
        while (e1.hasMoreElements()) {
            os.print("{ ");
            Vector v = (Vector)e1.nextElement();
            Enumeration e2 = v.elements();
            while (e2.hasMoreElements()) {
                BaseType bt = (BaseType)e2.nextElement();
                bt.printVal(os, "", false);
                if (!e2.hasMoreElements()) continue;
                os.print(", ");
            }
            os.print(" }");
            if (!e1.hasMoreElements()) continue;
            os.print(", ");
        }
        os.print(" }");
        if (print_decl_p) {
            os.println(";");
        }
    }

    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        if (sv.getMajor() < 2 || sv.getMajor() == 2 && sv.getMinor() < 15) {
            this.oldDeserialize(source, sv, statusUI);
        } else {
            byte marker;
            while (true) {
                marker = this.readMarker(source);
                if (statusUI != null) {
                    statusUI.incrementByteCount(4);
                }
                if (marker != START_OF_INSTANCE) break;
                this.deserializeSingle(source, sv, statusUI);
            }
            if (marker != END_OF_SEQUENCE) {
                throw new DataReadException("Sequence start marker not found");
            }
        }
    }

    private void oldDeserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, DataReadException {
        try {
            while (true) {
                this.deserializeSingle(source, sv, statusUI);
            }
        }
        catch (EOFException e) {
            return;
        }
    }

    private void deserializeSingle(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        Vector<Object> newInstance = new Vector<Object>();
        int i = 0;
        while (i < this.varTemplate.size()) {
            BaseType bt = (BaseType)this.varTemplate.elementAt(i);
            newInstance.addElement(bt.clone());
            ++i;
        }
        Enumeration e = newInstance.elements();
        while (e.hasMoreElements()) {
            if (statusUI != null && statusUI.userCancelled()) {
                throw new DataReadException("User cancelled");
            }
            ClientIO bt = (ClientIO)e.nextElement();
            bt.deserialize(source, sv, statusUI);
        }
        this.allValues.addElement(newInstance);
    }

    private byte readMarker(DataInputStream source) throws IOException {
        byte marker = source.readByte();
        int i = 0;
        while (i < 3) {
            byte unused = source.readByte();
            ++i;
        }
        return marker;
    }

    protected void writeMarker(DataOutputStream sink, byte marker) throws IOException {
        sink.writeByte(marker);
        sink.writeByte(0);
        sink.writeByte(0);
        sink.writeByte(0);
    }

    public void externalize(DataOutputStream sink) throws IOException {
        int i = 0;
        while (i < this.allValues.size()) {
            this.writeMarker(sink, START_OF_INSTANCE);
            Vector rowVec = (Vector)this.allValues.elementAt(i);
            int j = 0;
            while (j < rowVec.size()) {
                ClientIO bt = (ClientIO)rowVec.elementAt(j);
                bt.externalize(sink);
                ++j;
            }
            ++i;
        }
        this.writeMarker(sink, END_OF_SEQUENCE);
    }
}

