/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.SceneGraphObject;

public class MediaContainerState
extends NodeComponentState {
    private static final int URL_STRING = 0;
    private static final int URL_OBJECT = 1;
    private static final int INPUT_STREAM = 2;

    public MediaContainerState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        MediaContainer mediaContainer = (MediaContainer)this.node;
        dataOutput.writeBoolean(mediaContainer.getCacheEnable());
        if (mediaContainer.getURLString() != null) {
            dataOutput.writeInt(0);
            dataOutput.writeUTF(mediaContainer.getURLString());
            return;
        }
        if (mediaContainer.getURLObject() != null) {
            dataOutput.writeInt(1);
            dataOutput.writeUTF(mediaContainer.getURLObject().toString());
            return;
        }
        dataOutput.writeInt(2);
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        ((MediaContainer)this.node).setCacheEnable(dataInput.readBoolean());
        int n = dataInput.readInt();
        switch (n) {
            case 0: {
                ((MediaContainer)this.node).setURLString(dataInput.readUTF());
                return;
            }
            case 1: {
                try {
                    ((MediaContainer)this.node).setURLObject(new URI(dataInput.readUTF()).toURL());
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
                return;
            }
        }
    }

    protected SceneGraphObject createNode() {
        return new MediaContainer();
    }
}

