/*
 * Decompiled with CFR 0.152.
 */
package NCTR.util.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.util.List;
import javax.swing.Icon;

public class MultiIcon
implements Icon {
    public static final int ALIGNMENT_HORIZONTAL = 1;
    public static final int ALIGNMENT_VERTICAL = 2;
    public static final int ALIGNMENT_STACKED = 3;
    private int gap = 3;
    private Icon[] icons;
    private int alignment;
    private int width = 0;
    private int height = 0;

    public MultiIcon() {
        this(1);
    }

    public MultiIcon(int alignment) {
        this.alignment = alignment;
    }

    public MultiIcon(List<Icon> icons) {
        this(1);
        for (Icon icon : icons) {
            this.addIcon(icon);
        }
    }

    public int getIconCount() {
        if (this.icons == null) {
            return 0;
        }
        return this.icons.length;
    }

    public Icon getIconAt(int index) {
        return this.icons[index];
    }

    public void replaceIconAt(int index, Icon newIcon) {
        this.icons[index] = newIcon;
        this.width = this.calculateIconWidth();
        this.height = this.calculateIconHeight();
    }

    public void addIcon(Icon icon) {
        if (icon == null) {
            return;
        }
        if (this.icons == null) {
            this.icons = new Icon[]{icon};
        } else {
            Icon[] newIcons = new Icon[this.icons.length + 1];
            System.arraycopy(this.icons, 0, newIcons, 0, this.icons.length);
            newIcons[newIcons.length - 1] = icon;
            this.icons = newIcons;
        }
        this.width = this.calculateIconWidth();
        this.height = this.calculateIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.icons == null) {
            return;
        }
        if (this.alignment == 2) {
            int yIcon = y;
            int i = 0;
            while (i < this.icons.length) {
                Icon icon = this.icons[i];
                int xIcon = x + (this.width - icon.getIconWidth()) / 2;
                icon.paintIcon(c, g, xIcon, yIcon);
                yIcon += icon.getIconHeight() + this.gap;
                ++i;
            }
        } else if (this.alignment == 3) {
            int i = 0;
            while (i < this.icons.length) {
                Icon icon = this.icons[i];
                int xIcon = x + (this.width - icon.getIconWidth()) / 2;
                int yIcon = y + (this.width - icon.getIconHeight()) / 2;
                icon.paintIcon(c, g, xIcon, yIcon);
                ++i;
            }
        } else {
            assert (this.alignment == 1);
            int xIcon = x;
            int i = 0;
            while (i < this.icons.length) {
                Icon icon = this.icons[i];
                int yIcon = y + (this.height - icon.getIconHeight()) / 2;
                icon.paintIcon(c, g, xIcon, yIcon);
                xIcon += icon.getIconWidth() + this.gap;
                ++i;
            }
        }
    }

    public int calculateIconWidth() {
        if (this.icons == null) {
            return 0;
        }
        if (this.alignment == 1) {
            int width = 0;
            int i = 0;
            while (i < this.icons.length) {
                width += this.icons[i].getIconWidth();
                ++i;
            }
            return width += this.gap * (this.icons.length - 1);
        }
        int width = 0;
        int i = 0;
        while (i < this.icons.length) {
            width = Math.max(width, this.icons[i].getIconHeight());
            ++i;
        }
        return width;
    }

    public int calculateIconHeight() {
        if (this.icons == null) {
            return 0;
        }
        if (this.alignment == 2) {
            int height = 0;
            int i = 0;
            while (i < this.icons.length) {
                height += this.icons[i].getIconWidth();
                ++i;
            }
            return height += this.gap * (this.icons.length - 1);
        }
        int height = 0;
        int i = 0;
        while (i < this.icons.length) {
            height = Math.max(height, this.icons[i].getIconHeight());
            ++i;
        }
        return height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

