/*
 * Decompiled with CFR 0.152.
 */
package NCTR.util.math.la;

import NCTR.util.IntPair;
import NCTR.util.math.la.Maths;
import NCTR.util.math.la.Matrix;
import java.io.Serializable;
import java.util.HashMap;

public class SingularValueDecomposition
implements Serializable {
    private double[][] U;
    private double[][] V;
    private SparseMatrix sparseV;
    private double[] s;
    private int m;
    private int n;

    public SingularValueDecomposition(Matrix Arg) {
        this(Arg, InputDataTreatment.COPY, false);
    }

    public SingularValueDecomposition(Matrix Arg, InputDataTreatment input_data_trt, boolean want_sparse_v) {
        int i;
        double t;
        int k;
        int j;
        boolean want_v = false;
        double[][] A = input_data_trt == InputDataTreatment.COPY ? Arg.getArrayCopy() : Arg.getArray();
        this.m = Arg.getRowDimension();
        this.n = Arg.getColumnDimension();
        int nu = Math.min(this.m, this.n);
        this.s = new double[Math.min(this.m + 1, this.n)];
        this.U = new double[this.m][nu];
        this.V = want_v ? new double[this.n][this.n] : null;
        this.sparseV = want_sparse_v ? new SparseMatrix(this.n, this.n, 0.001f) : null;
        double[] e = new double[this.n];
        double[] work = new double[this.m];
        boolean wantu = true;
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        int k2 = 0;
        while (k2 < Math.max(nct, nrt)) {
            int i2;
            int i3;
            if (k2 < nct) {
                this.s[k2] = 0.0;
                i3 = k2;
                while (i3 < this.m) {
                    this.s[k2] = Maths.hypot(this.s[k2], A[i3][k2]);
                    ++i3;
                }
                if (this.s[k2] != 0.0) {
                    if (A[k2][k2] < 0.0) {
                        this.s[k2] = -this.s[k2];
                    }
                    i3 = k2;
                    while (i3 < this.m) {
                        double[] dArray = A[i3];
                        int n = k2;
                        dArray[n] = dArray[n] / this.s[k2];
                        ++i3;
                    }
                    double[] dArray = A[k2];
                    int n = k2;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.s[k2] = -this.s[k2];
            }
            j = k2 + 1;
            while (j < this.n) {
                if (k2 < nct & this.s[k2] != 0.0) {
                    double t2 = 0.0;
                    i2 = k2;
                    while (i2 < this.m) {
                        t2 += A[i2][k2] * A[i2][j];
                        ++i2;
                    }
                    t2 = -t2 / A[k2][k2];
                    i2 = k2;
                    while (i2 < this.m) {
                        double[] dArray = A[i2];
                        int n = j;
                        dArray[n] = dArray[n] + t2 * A[i2][k2];
                        ++i2;
                    }
                }
                e[j] = A[k2][j];
                ++j;
            }
            if (wantu & k2 < nct) {
                i3 = k2;
                while (i3 < this.m) {
                    this.U[i3][k2] = A[i3][k2];
                    ++i3;
                }
            }
            if (k2 < nrt) {
                e[k2] = 0.0;
                i3 = k2 + 1;
                while (i3 < this.n) {
                    e[k2] = Maths.hypot(e[k2], e[i3]);
                    ++i3;
                }
                if (e[k2] != 0.0) {
                    if (e[k2 + 1] < 0.0) {
                        e[k2] = -e[k2];
                    }
                    i3 = k2 + 1;
                    while (i3 < this.n) {
                        int n = i3++;
                        e[n] = e[n] / e[k2];
                    }
                    int n = k2 + 1;
                    e[n] = e[n] + 1.0;
                }
                e[k2] = -e[k2];
                if (k2 + 1 < this.m & e[k2] != 0.0) {
                    i3 = k2 + 1;
                    while (i3 < this.m) {
                        work[i3] = 0.0;
                        ++i3;
                    }
                    j = k2 + 1;
                    while (j < this.n) {
                        int i4 = k2 + 1;
                        while (i4 < this.m) {
                            int n = i4;
                            work[n] = work[n] + e[j] * A[i4][j];
                            ++i4;
                        }
                        ++j;
                    }
                    j = k2 + 1;
                    while (j < this.n) {
                        double t3 = -e[j] / e[k2 + 1];
                        i2 = k2 + 1;
                        while (i2 < this.m) {
                            double[] dArray = A[i2];
                            int n = j;
                            dArray[n] = dArray[n] + t3 * work[i2];
                            ++i2;
                        }
                        ++j;
                    }
                }
                if (want_v) {
                    i3 = k2 + 1;
                    while (i3 < this.n) {
                        this.V[i3][k2] = e[i3];
                        ++i3;
                    }
                }
                if (want_sparse_v) {
                    i3 = k2 + 1;
                    while (i3 < this.n) {
                        this.sparseV.set(i3, k2, e[i3]);
                        ++i3;
                    }
                }
            }
            ++k2;
        }
        int p = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.s[nct] = A[nct][nct];
        }
        if (this.m < p) {
            this.s[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        if (wantu) {
            j = nct;
            while (j < nu) {
                int i5 = 0;
                while (i5 < this.m) {
                    this.U[i5][j] = 0.0;
                    ++i5;
                }
                this.U[j][j] = 1.0;
                ++j;
            }
            k = nct - 1;
            while (k >= 0) {
                int i6;
                if (this.s[k] != 0.0) {
                    int j2 = k + 1;
                    while (j2 < nu) {
                        t = 0.0;
                        i = k;
                        while (i < this.m) {
                            t += this.U[i][k] * this.U[i][j2];
                            ++i;
                        }
                        t = -t / this.U[k][k];
                        i = k;
                        while (i < this.m) {
                            double[] dArray = this.U[i];
                            int n = j2;
                            dArray[n] = dArray[n] + t * this.U[i][k];
                            ++i;
                        }
                        ++j2;
                    }
                    i6 = k;
                    while (i6 < this.m) {
                        this.U[i6][k] = -this.U[i6][k];
                        ++i6;
                    }
                    this.U[k][k] = 1.0 + this.U[k][k];
                    i6 = 0;
                    while (i6 < k - 1) {
                        this.U[i6][k] = 0.0;
                        ++i6;
                    }
                } else {
                    i6 = 0;
                    while (i6 < this.m) {
                        this.U[i6][k] = 0.0;
                        ++i6;
                    }
                    this.U[k][k] = 1.0;
                }
                --k;
            }
        }
        if (want_v) {
            k = this.n - 1;
            while (k >= 0) {
                if (k < nrt & e[k] != 0.0) {
                    int j3 = k + 1;
                    while (j3 < nu) {
                        t = 0.0;
                        i = k + 1;
                        while (i < this.n) {
                            t += this.V[i][k] * this.V[i][j3];
                            ++i;
                        }
                        t = -t / this.V[k + 1][k];
                        i = k + 1;
                        while (i < this.n) {
                            double[] dArray = this.V[i];
                            int n = j3;
                            dArray[n] = dArray[n] + t * this.V[i][k];
                            ++i;
                        }
                        ++j3;
                    }
                }
                int i7 = 0;
                while (i7 < this.n) {
                    this.V[i7][k] = 0.0;
                    ++i7;
                }
                this.V[k][k] = 1.0;
                --k;
            }
        }
        if (want_sparse_v) {
            k = this.n - 1;
            while (k >= 0) {
                if (k < nrt & e[k] != 0.0) {
                    int j4 = k + 1;
                    while (j4 < nu) {
                        t = 0.0;
                        i = k + 1;
                        while (i < this.n) {
                            t += this.sparseV.get(i, k) * this.sparseV.get(i, j4);
                            ++i;
                        }
                        t = -t / this.sparseV.get(k + 1, k);
                        i = k + 1;
                        while (i < this.n) {
                            double vij = this.sparseV.get(i, j4);
                            this.sparseV.set(i, j4, vij + t * this.sparseV.get(i, k));
                            ++i;
                        }
                        ++j4;
                    }
                }
                int i8 = 0;
                while (i8 < this.n) {
                    this.sparseV.set(i8, k, 0.0);
                    ++i8;
                }
                this.sparseV.set(k, k, 1.0);
                --k;
            }
        }
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        block41: while (p > 0) {
            int kase;
            int k3 = p - 2;
            while (k3 >= -1) {
                if (k3 == -1) break;
                if (Math.abs(e[k3]) <= eps * (Math.abs(this.s[k3]) + Math.abs(this.s[k3 + 1]))) {
                    e[k3] = 0.0;
                    break;
                }
                --k3;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks = p - 1;
                while (ks >= k3) {
                    if (ks == k3) break;
                    double t4 = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (Math.abs(this.s[ks]) <= eps * t4) {
                        this.s[ks] = 0.0;
                        break;
                    }
                    --ks;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i9;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    int j5 = p - 2;
                    while (j5 >= k3) {
                        t5 = Maths.hypot(this.s[j5], f);
                        cs = this.s[j5] / t5;
                        sn = f / t5;
                        this.s[j5] = t5;
                        if (j5 != k3) {
                            f = -sn * e[j5 - 1];
                            e[j5 - 1] = cs * e[j5 - 1];
                        }
                        if (want_v) {
                            i9 = 0;
                            while (i9 < this.n) {
                                t5 = cs * this.V[i9][j5] + sn * this.V[i9][p - 1];
                                this.V[i9][p - 1] = -sn * this.V[i9][j5] + cs * this.V[i9][p - 1];
                                this.V[i9][j5] = t5;
                                ++i9;
                            }
                        }
                        if (want_sparse_v) {
                            i9 = 0;
                            while (i9 < this.n) {
                                t5 = cs * this.sparseV.get(i9, j5) + sn * this.sparseV.get(i9, p - 1);
                                this.sparseV.set(i9, p - 1, -sn * this.sparseV.get(i9, j5) + cs * this.sparseV.get(i9, p - 1));
                                this.sparseV.set(i9, j5, t5);
                                ++i9;
                            }
                        }
                        --j5;
                    }
                    continue block41;
                }
                case 2: {
                    int i9;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    int j6 = k3;
                    while (j6 < p) {
                        t5 = Maths.hypot(this.s[j6], f);
                        cs = this.s[j6] / t5;
                        sn = f / t5;
                        this.s[j6] = t5;
                        f = -sn * e[j6];
                        e[j6] = cs * e[j6];
                        if (wantu) {
                            i9 = 0;
                            while (i9 < this.m) {
                                t5 = cs * this.U[i9][j6] + sn * this.U[i9][k3 - 1];
                                this.U[i9][k3 - 1] = -sn * this.U[i9][j6] + cs * this.U[i9][k3 - 1];
                                this.U[i9][j6] = t5;
                                ++i9;
                            }
                        }
                        ++j6;
                    }
                    continue block41;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[p - 1]), Math.abs(this.s[p - 2])), Math.abs(e[p - 2])), Math.abs(this.s[k3])), Math.abs(e[k3]));
                    double sp = this.s[p - 1] / scale;
                    double spm1 = this.s[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = this.s[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 | c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    int j7 = k3;
                    while (j7 < p - 1) {
                        int i10;
                        double t6 = Maths.hypot(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j7 != k3) {
                            e[j7 - 1] = t6;
                        }
                        f = cs * this.s[j7] + sn * e[j7];
                        e[j7] = cs * e[j7] - sn * this.s[j7];
                        g = sn * this.s[j7 + 1];
                        this.s[j7 + 1] = cs * this.s[j7 + 1];
                        if (want_v) {
                            i10 = 0;
                            while (i10 < this.n) {
                                t6 = cs * this.V[i10][j7] + sn * this.V[i10][j7 + 1];
                                this.V[i10][j7 + 1] = -sn * this.V[i10][j7] + cs * this.V[i10][j7 + 1];
                                this.V[i10][j7] = t6;
                                ++i10;
                            }
                        }
                        if (want_sparse_v) {
                            i10 = 0;
                            while (i10 < this.n) {
                                t6 = cs * this.sparseV.get(i10, j7) + sn * this.sparseV.get(i10, j7 + 1);
                                this.sparseV.set(i10, j7 + 1, -sn * this.sparseV.get(i10, j7) + cs * this.sparseV.get(i10, j7 + 1));
                                this.sparseV.set(i10, j7, t6);
                                ++i10;
                            }
                        }
                        t6 = Maths.hypot(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        this.s[j7] = t6;
                        f = cs * e[j7] + sn * this.s[j7 + 1];
                        this.s[j7 + 1] = -sn * e[j7] + cs * this.s[j7 + 1];
                        g = sn * e[j7 + 1];
                        e[j7 + 1] = cs * e[j7 + 1];
                        if (wantu && j7 < this.m - 1) {
                            i10 = 0;
                            while (i10 < this.m) {
                                t6 = cs * this.U[i10][j7] + sn * this.U[i10][j7 + 1];
                                this.U[i10][j7 + 1] = -sn * this.U[i10][j7] + cs * this.U[i10][j7 + 1];
                                this.U[i10][j7] = t6;
                                ++i10;
                            }
                        }
                        ++j7;
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if (this.s[k3] <= 0.0) {
                        int i11;
                        double d = this.s[k3] = this.s[k3] < 0.0 ? -this.s[k3] : 0.0;
                        if (want_v) {
                            i11 = 0;
                            while (i11 <= pp) {
                                this.V[i11][k3] = -this.V[i11][k3];
                                ++i11;
                            }
                        }
                        if (want_sparse_v) {
                            i11 = 0;
                            while (i11 <= pp) {
                                this.sparseV.set(i11, k3, -this.sparseV.get(i11, k3));
                                ++i11;
                            }
                        }
                    }
                    while (k3 < pp) {
                        int i12;
                        if (this.s[k3] >= this.s[k3 + 1]) break;
                        double t7 = this.s[k3];
                        this.s[k3] = this.s[k3 + 1];
                        this.s[k3 + 1] = t7;
                        if (want_v && k3 < this.n - 1) {
                            i12 = 0;
                            while (i12 < this.n) {
                                t7 = this.V[i12][k3 + 1];
                                this.V[i12][k3 + 1] = this.V[i12][k3];
                                this.V[i12][k3] = t7;
                                ++i12;
                            }
                        }
                        if (want_sparse_v && k3 < this.n - 1) {
                            i12 = 0;
                            while (i12 < this.n) {
                                t7 = this.sparseV.get(i12, k3 + 1);
                                this.sparseV.set(i12, k3 + 1, this.sparseV.get(i12, k3));
                                this.sparseV.set(i12, k3, t7);
                                ++i12;
                            }
                        }
                        if (wantu && k3 < this.m - 1) {
                            i12 = 0;
                            while (i12 < this.m) {
                                t7 = this.U[i12][k3 + 1];
                                this.U[i12][k3 + 1] = this.U[i12][k3];
                                this.U[i12][k3] = t7;
                                ++i12;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
    }

    public Matrix getU() {
        return new Matrix(this.U, this.m, Math.min(this.m, this.n));
    }

    public Matrix getV() {
        return this.V != null ? new Matrix(this.V, this.n, this.n) : null;
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public Matrix getS() {
        Matrix X = new Matrix(this.n, this.n);
        double[][] S = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                S[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        int cols = Math.min(this.n, this.s.length);
        int i2 = 0;
        while (i2 < cols) {
            S[i2][i2] = this.s[i2];
            ++i2;
        }
        return X;
    }

    public double norm2() {
        return this.s[0];
    }

    public double cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public int rank() {
        double eps = Math.pow(2.0, -52.0);
        double tol = (double)Math.max(this.m, this.n) * this.s[0] * eps;
        int r = 0;
        int i = 0;
        while (i < this.s.length) {
            if (this.s[i] > tol) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    public Matrix scores() {
        int rows = this.U.length;
        int cols = Math.min(this.s.length, this.n);
        Matrix ret = new Matrix(rows, cols);
        double[][] array = ret.getArray();
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                array[i][j] = j < this.U[0].length ? this.U[i][j] * this.s[j] : 0.0;
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public SparseMatrix getSparseV() {
        return this.sparseV;
    }

    public static enum InputDataTreatment {
        MODIFY_IN_PLACE,
        COPY;

    }

    public static class SparseMatrix {
        int numRows;
        int numCols;
        HashMap<IntPair, Double> rcData;

        public SparseMatrix(int rows, int cols, float expected_nonzero_fraction) {
            this.numRows = rows;
            this.numCols = cols;
            int hash_capacity = Math.max((int)(expected_nonzero_fraction * (float)(rows * cols)), 100);
            this.rcData = new HashMap(hash_capacity);
        }

        public double get(int i, int j) {
            Double val = this.rcData.get(new IntPair(i, j));
            if (val == null) {
                return 0.0;
            }
            return val;
        }

        public void set(int i, int j, double val) {
            if (val == 0.0) {
                this.rcData.remove(new IntPair(i, j));
            } else {
                this.rcData.put(new IntPair(i, j), val);
            }
        }

        public int getNumRows() {
            return this.numRows;
        }

        public int getNumCols() {
            return this.numCols;
        }

        public int getNonZeroCount() {
            return this.rcData.size();
        }
    }
}

