/*
 * Decompiled with CFR 0.152.
 */
package NCTR.util;

import java.io.Reader;
import java.io.StreamTokenizer;

public class XbmParser {
    private static final int GET_WIDTH = 0;
    private static final int GET_HEIGHT = 1;
    private static final int GET_START = 2;
    private static final int GET_BYTES = 3;
    private StreamTokenizer tokenizer;
    private int width = 0;
    private int height = 0;
    private int[] bitmap = null;

    public XbmParser(Reader r) {
        this.tokenizer = new StreamTokenizer(r);
        this.tokenizer.slashStarComments(true);
        this.tokenizer.ordinaryChar(47);
    }

    public boolean parse() {
        try {
            this.parseInput();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getBitmap() {
        return this.bitmap;
    }

    private void parseInput() throws Exception {
        int state = 0;
        int token = -1;
        int index = 0;
        token = this.tokenizer.nextToken();
        while (token != -1) {
            switch (state) {
                case 0: {
                    if (token != -2) break;
                    this.width = (int)this.tokenizer.nval;
                    state = 1;
                    break;
                }
                case 1: {
                    if (token != -2) break;
                    this.height = (int)this.tokenizer.nval;
                    state = 2;
                    break;
                }
                case 2: {
                    if (token != 123) break;
                    this.resetTokenizer();
                    this.bitmap = new int[this.width * this.height / 8];
                    state = 3;
                    break;
                }
                case 3: {
                    if (token == -3) {
                        if (this.tokenizer.sval.length() <= 2 || this.tokenizer.sval.charAt(0) != '0' || this.tokenizer.sval.charAt(1) != 'x' && this.tokenizer.sval.charAt(1) != 'x') break;
                        try {
                            int val = Integer.parseInt(this.tokenizer.sval.substring(2), 16);
                            this.bitmap[index++] = val;
                        }
                        catch (Exception e) {
                            token = -1;
                        }
                        break;
                    }
                    if (token != 125) break;
                    token = -1;
                }
            }
            token = this.tokenizer.nextToken();
        }
        if (this.width == 0 || this.height == 0 || index != this.width * this.height / 8) {
            throw new Exception();
        }
    }

    private void resetTokenizer() {
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(97, 102);
        this.tokenizer.wordChars(65, 70);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(120, 120);
        this.tokenizer.wordChars(88, 88);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.slashStarComments(true);
    }
}

