/*
 * Decompiled with CFR 0.152.
 */
package NCTR.util;

import NCTR.util.Func;
import NCTR.util.ListUtilities;
import java.util.Collection;
import java.util.List;

public class StringUtilities {
    public static Func<String, String> quoteF = new Func<String, String>(){

        @Override
        public String apply(String s) {
            return "\"" + s + "\"";
        }
    };

    public static boolean stringsEqualOrBothNull(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
    }

    public static int countOccurrences(char c, String s) {
        int count = 0;
        int ix = s.length() - 1;
        while (ix >= 0) {
            if (s.charAt(ix) == c) {
                ++count;
            }
            --ix;
        }
        return count;
    }

    public static String stripQuotes(String s) {
        if (s != null && s.length() >= 2 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String replaceCharWithString(String input_str, char char_to_repl, String repl_str) {
        StringBuilder buf = new StringBuilder(input_str.length());
        int orig_len = input_str.length();
        int i = 0;
        while (i < orig_len) {
            char c = input_str.charAt(i);
            if (c != char_to_repl) {
                buf.append(c);
            } else if (repl_str != null) {
                buf.append(repl_str);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String escapeQuotesForSQL(String str) {
        int ix;
        if (str != null && (ix = str.indexOf(39)) != -1) {
            int orig_len = str.length();
            StringBuffer str_buf = new StringBuffer(orig_len);
            str_buf.append(str.substring(0, ++ix));
            str_buf.append('\'');
            while (ix < orig_len) {
                char ch = str.charAt(ix);
                if (ch == '\'') {
                    str_buf.append("''");
                } else {
                    str_buf.append(ch);
                }
                ++ix;
            }
            str = str_buf.toString();
        }
        return str;
    }

    public static String withoutNonAsciiChars(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        int len = str.length();
        int ix = 0;
        while (ix < len) {
            char ch = str.charAt(ix);
            if ((float)ch <= 7.0f) {
                buf.append(ch);
            }
            ++ix;
        }
        return buf.toString();
    }

    public static String globPatternToRegexp(String glob_pattern, boolean add_wildcards_at_ends) {
        String re = glob_pattern.replaceAll("([()\\[\\].+?|])", "\\$1");
        re = re.replaceAll("\\*", ".*");
        if (add_wildcards_at_ends) {
            if (!re.startsWith(".*")) {
                re = ".*" + re;
            }
            if (!re.endsWith(".*")) {
                re = String.valueOf(re) + ".*";
            }
        }
        return re;
    }

    public static String stringFrom(Collection<?> items) {
        return StringUtilities.stringFrom(items, ",", null, null, null);
    }

    public static String stringFrom(Collection<?> items, String sep) {
        return StringUtilities.stringFrom(items, sep, null, null, null);
    }

    public static String stringFrom(Collection<?> items, String sep, String items_prefix) {
        return StringUtilities.stringFrom(items, sep, items_prefix, null, null);
    }

    public static <E> String stringFrom(List<E> items, String sep, String null_rep, Func<E, String> f) {
        List<String> l = ListUtilities.map(f, items);
        return StringUtilities.stringFrom(l, sep, null, null, null_rep);
    }

    public static String stringFrom(Collection<?> items, String sep, String items_prefix, String items_suffix, String null_rep) {
        StringBuilder buf = new StringBuilder(10 * items.size());
        boolean past_first = false;
        for (Object item : items) {
            if (item == null && null_rep == null) continue;
            if (!past_first) {
                past_first = true;
            } else {
                buf.append(sep);
            }
            if (item != null) {
                String item_str = item.toString();
                if (items_prefix != null) {
                    if (items_prefix.indexOf("$el") != -1) {
                        buf.append(items_prefix.replaceAll("\\$el", item_str));
                    } else {
                        buf.append(items_prefix);
                    }
                }
                buf.append(item_str);
                if (items_suffix == null) continue;
                if (items_suffix.indexOf("$el") != -1) {
                    buf.append(items_suffix.replaceAll("\\$el", item_str));
                    continue;
                }
                buf.append(items_suffix);
                continue;
            }
            buf.append(null_rep);
        }
        return buf.toString();
    }

    public static String removeExtension(String filename) {
        int dot_ix = filename.lastIndexOf(".");
        return dot_ix != -1 ? filename.substring(0, dot_ix) : filename;
    }

    public static String escapeForHTML(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        boolean last_char_was_blank = false;
        int len = string.length();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (last_char_was_blank) {
                    last_char_was_blank = false;
                    sb.append("&nbsp;");
                } else {
                    last_char_was_blank = true;
                    sb.append(' ');
                }
            } else {
                last_char_was_blank = false;
                if (c == '\"') {
                    sb.append("&quot;");
                } else if (c == '&') {
                    sb.append("&amp;");
                } else if (c == '<') {
                    sb.append("&lt;");
                } else if (c == '>') {
                    sb.append("&gt;");
                } else if (c == '\n') {
                    sb.append("<br>");
                } else {
                    int ci = 0xFFFF & c;
                    if (ci < 160) {
                        sb.append(c);
                    } else {
                        sb.append("&#");
                        sb.append(ci);
                        sb.append(';');
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String toCamelCase(String name, boolean initial_cap) {
        StringBuilder name_buf = new StringBuilder();
        boolean uc_next = initial_cap;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '_') {
                uc_next = true;
            } else {
                name_buf.append(uc_next ? Character.toUpperCase(c) : Character.toLowerCase(c));
                uc_next = false;
            }
            ++i;
        }
        return name_buf.toString();
    }
}

