/*
 * Decompiled with CFR 0.152.
 */
package NCTR.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IntVector
implements Iterable<Integer>,
Cloneable {
    private int[] data;
    private int size;
    private int growthDelta;
    private float growthFactor;

    public IntVector() {
        this(1);
    }

    public IntVector(int[] ints) {
        this(ints.length, 0, 0.2f);
        this.addAll(ints);
    }

    public IntVector(IntVector other) {
        this(other.size(), 0, 0.2f);
        this.addAll(other);
    }

    public IntVector(int initial_capacity) {
        this(initial_capacity, 0, 0.2f);
    }

    public IntVector(int initial_capacity, int delta_growth, float growth_factor) {
        this.data = new int[initial_capacity];
        this.size = 0;
        this.growthDelta = delta_growth;
        this.growthFactor = growth_factor;
    }

    public void setGrowthDelta(int delta_growth) {
        this.growthDelta = delta_growth;
    }

    public void setGrowthFactor(float growth_factor) {
        this.growthFactor = growth_factor;
    }

    public static IntVector singleton(int element) {
        IntVector iv = new IntVector(1);
        iv.add(element);
        return iv;
    }

    public int get(int ix) {
        if (ix >= this.size) {
            throw new IndexOutOfBoundsException("index " + ix + ", IntVector size " + this.size);
        }
        return this.data[ix];
    }

    public void set(int ix, int val) {
        if (ix >= this.size) {
            throw new IndexOutOfBoundsException("index " + ix + ", IntVector size " + this.size);
        }
        this.data[ix] = val;
    }

    public void add(int val) {
        if (this.size >= this.data.length) {
            if ((double)this.growthFactor > 0.0) {
                this.ensureCapacity(this.size + Math.max((int)((float)this.size * this.growthFactor), 1));
            } else {
                this.ensureCapacity(this.size + this.growthDelta);
            }
        }
        this.data[this.size++] = val;
    }

    public void addAll(IntVector other) {
        if (other.size() > 0) {
            this.ensureCapacity(this.size + other.size());
            System.arraycopy(other.data, 0, this.data, this.size, other.size);
            this.size += other.size;
        }
    }

    public void addAll(int[] other) {
        if (other.length > 0) {
            this.ensureCapacity(this.size + other.length);
            System.arraycopy(other, 0, this.data, this.size, other.length);
            this.size += other.length;
        }
    }

    public void addBeforeIxVal(int ix, int val) {
        int[] new_data = new int[this.data.length > this.size ? this.data.length : this.size + 1];
        if (ix != 0) {
            System.arraycopy(this.data, 0, new_data, 0, ix);
        }
        new_data[ix] = val;
        if (ix != this.size) {
            System.arraycopy(this.data, ix, new_data, ix + 1, this.size - ix);
        }
        this.data = new_data;
        ++this.size;
    }

    public void removeAt(int ix) {
        if (ix >= this.size) {
            throw new IndexOutOfBoundsException("index " + ix + ", IntVector size " + this.size);
        }
        if (ix < this.size - 1) {
            System.arraycopy(this.data, ix + 1, this.data, ix, this.size - 1 - ix);
        }
        --this.size;
    }

    public void remove(int val) {
        int ix = this.size - 1;
        while (ix >= 0) {
            if (this.data[ix] == val) {
                this.removeAt(ix);
            }
            --ix;
        }
    }

    public boolean contains(int val) {
        return this.indexOf(val) != -1;
    }

    public int indexOf(int val) {
        int ix = 0;
        while (ix < this.size) {
            if (this.data[ix] == val) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    public int lastIndexOf(int val) {
        int ix = this.size - 1;
        while (ix >= 0) {
            if (this.data[ix] == val) {
                return ix;
            }
            --ix;
        }
        return -1;
    }

    public void clear() {
        this.size = 0;
    }

    public void clearAndDispose() {
        this.size = 0;
        this.data = new int[0];
    }

    public void ensureCapacity(int new_capacity) {
        if (this.data.length < new_capacity) {
            int[] new_data = new int[new_capacity];
            System.arraycopy(this.data, 0, new_data, 0, this.size);
            this.data = new_data;
        }
    }

    public void setSize(int new_size) {
        this.ensureCapacity(new_size);
        this.size = new_size;
    }

    public int getSize() {
        return this.size;
    }

    public int size() {
        return this.size;
    }

    public int[] toArray() {
        int[] ret_val = new int[this.size];
        System.arraycopy(this.data, 0, ret_val, 0, this.size);
        return ret_val;
    }

    public Object clone() {
        try {
            Object ret_val = super.clone();
            ((IntVector)ret_val).data = (int[])this.data.clone();
            return ret_val;
        }
        catch (CloneNotSupportedException e) {
            System.err.println(e);
            return null;
        }
    }

    public IntVector duplicate() {
        return this.duplicate(0);
    }

    public IntVector duplicate(int additional_capacity) {
        IntVector new_copy = new IntVector(this.size + additional_capacity);
        new_copy.size = this.size;
        System.arraycopy(this.data, 0, new_copy.data, 0, this.size);
        return new_copy;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        boolean past_first = false;
        for (int val : this) {
            if (past_first) {
                buf.append(",");
            } else {
                past_first = true;
            }
            buf.append(val);
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iter();
    }

    protected class Iter
    implements Iterator<Integer> {
        int nextIx = 0;
        int lastRetIx = -1;

        protected Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.nextIx != IntVector.this.size();
        }

        @Override
        public Integer next() {
            try {
                int val = IntVector.this.get(this.nextIx);
                this.lastRetIx = this.nextIx++;
                return new Integer(val);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRetIx == -1) {
                throw new IllegalStateException();
            }
            IntVector.this.removeAt(this.lastRetIx);
            if (this.lastRetIx < this.nextIx) {
                --this.nextIx;
            }
            this.lastRetIx = -1;
        }
    }
}

