/*
 * Decompiled with CFR 0.152.
 */
package NCTR.graph.SciGraph;

class Vector {
    public double x = 0.0;
    public double y = 0.0;
    public double z = 0.0;

    public Vector() {
    }

    public Vector(double d, double d1, double d2) {
        this.x = d;
        this.y = d1;
        this.z = d2;
    }

    public Vector(Vector vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
    }

    public double dotProduct(double x1, double y1, double z1) {
        return this.x * x1 + this.y * y1 + this.z * z1;
    }

    public double dotProduct(Vector vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector normalize() {
        double d = this.norm();
        return new Vector(this.x / d, this.y / d, this.z / d);
    }

    public Vector add(Vector vec) {
        return new Vector(this.x + vec.x, this.y + vec.y, this.z + vec.z);
    }

    public Vector substract(Vector vec) {
        return new Vector(this.x - vec.x, this.y - vec.y, this.z - vec.z);
    }

    public void assignDiff(Vector a, Vector b) {
        this.x = a.x - b.x;
        this.y = a.y - b.y;
        this.z = a.z - b.z;
    }

    public Vector scalarMult(double d) {
        return new Vector(d * this.x, d * this.y, d * this.z);
    }

    public Vector scalarDivide(double d) {
        return new Vector(this.x / d, this.y / d, this.z / d);
    }

    public Vector crossProduct(Vector vec) {
        return new Vector(this.y * vec.z - this.z * vec.y, this.z * vec.x - this.x * vec.z, this.x * vec.y - this.y * vec.x);
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public String toString() {
        String xs = "" + this.x;
        String ys = "" + this.y;
        String zs = "" + this.z;
        if (this.x == 0.0) {
            xs = "0";
        }
        if (this.y == 0.0) {
            ys = "0";
        }
        if (this.z == 0.0) {
            zs = "0";
        }
        return "Vector: (" + xs + "," + ys + "," + zs + ")";
    }
}

