/*
 * Decompiled with CFR 0.152.
 */
package NCTR.graph.SciGraph;

import NCTR.graph.SciGraph.SgGraphItem;
import NCTR.graph.SciGraph.Vector;
import java.awt.Color;

public class SgGrid<K, L>
extends SgGraphItem<K, L> {
    public static final Color OldLace = new Color(253, 245, 230, 255);
    public static final Color Snow = new Color(255, 250, 250, 255);
    public static final Color GhostWhite = new Color(248, 248, 255, 255);
    public static final Color FloralWhite = new Color(255, 250, 240, 255);
    public static final Color LightYellow = new Color(255, 255, 224, 255);
    public static final Color Azure = new Color(240, 255, 255, 255);
    public static final Color AliceBlue = new Color(240, 248, 255, 255);
    public static final Color HoneyDew = new Color(240, 255, 240, 255);
    public static final Color Linen = new Color(250, 240, 230, 255);
    public static final Color WhiteSmoke = new Color(245, 245, 245, 255);
    String[] colorNames = new String[]{"OldLace", "Snow", "GhostWhite", "FloralWhite", "Azure", "AliceBlue", "HoneyDew", "Linen", "WhiteSmoke"};
    Color[] colorChoices = new Color[]{OldLace, Snow, GhostWhite, FloralWhite, Azure, AliceBlue, HoneyDew, Linen, WhiteSmoke};
    int nextColor = 0;
    private int plane = 0;
    private double[] gridMax = new double[]{0.0, 0.0, 0.0};
    private double[] gridMin = new double[]{0.0, 0.0, 0.0};
    private Color defaultColor = OldLace;
    static final Vector ORIGIN = new Vector(Double.NaN, Double.NaN, Double.NaN);

    @Override
    public boolean isData() {
        return false;
    }

    public SgGrid(int _plane) {
        this.plane = _plane;
        this.gridMin[0] = -0.4;
        this.gridMin[1] = -0.4;
        this.gridMin[2] = -0.4;
        this.isSurface = false;
        this.visible = true;
        this.curveWidth = 2;
        this.absoluteWidth = false;
        this.stepH = 10;
        this.stepV = 10;
        this.selected = true;
        this.curveColor = new Color(0, 0, 0, 255);
        this.setSurfaceColor(this.defaultColor);
    }

    public void useSurfaceColor(boolean flag) {
        if (flag) {
            ++this.nextColor;
            if (this.nextColor >= this.colorChoices.length) {
                this.nextColor = 0;
            }
            this.setSurfaceColor(this.colorChoices[this.nextColor]);
            System.out.println(this.colorNames[this.nextColor]);
        } else {
            this.setSurfaceColor(null);
        }
    }

    @Override
    public void setSurfaceColor(Color c) {
        if (c == null) {
            this.fillSurface = false;
            this.surfaceColor = null;
        } else {
            this.fillSurface = true;
            this.defaultColor = c;
            int alpha = c.getAlpha();
            if (alpha > 204) {
                alpha = 204;
            }
            this.surfaceColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        this.parseFunction();
    }

    @Override
    public String generateTestCase(String dataType) {
        return "new SgGrid" + dataType + "(" + this.plane + ")";
    }

    @Override
    public void setLocation(double x, double y, double z) {
        this.setGridMin(x, y, z);
    }

    public void setGridMin(double minX, double minY, double minZ) {
        this.gridMin[0] = minX;
        this.gridMin[1] = minY;
        this.gridMin[2] = minZ;
        this.parseFunction();
    }

    public void setGridMax(double maxX, double maxY, double maxZ) {
        this.gridMax[0] = maxX;
        this.gridMax[1] = maxY;
        this.gridMax[2] = maxZ;
        this.parseFunction();
    }

    @Override
    public void parseFunction() {
        int s2;
        int s1;
        this.coords = new Vector[this.stepH][this.isSurface ? 1 : this.stepV];
        switch (this.plane) {
            default: {
                s1 = 0;
                s2 = 1;
                break;
            }
            case 1: {
                s1 = 2;
                s2 = 1;
                break;
            }
            case 2: {
                s1 = 2;
                s2 = 0;
            }
        }
        double[] scale = new double[]{this.gridMax[0] - this.gridMin[0], this.gridMax[1] - this.gridMin[1], this.gridMax[2] - this.gridMin[2]};
        int i = 0;
        while (i < this.stepH) {
            double d = (float)i / (float)(this.stepH - 1);
            int j = 0;
            while (j < (this.isSurface ? 1 : this.stepV)) {
                double z;
                double y;
                double x;
                double d1 = (float)j / (float)(this.stepV - 1);
                double u = d * scale[s1];
                double v = d1 * scale[s2];
                switch (this.plane) {
                    default: {
                        x = u + this.gridMin[0];
                        y = v + this.gridMin[1];
                        z = 0.0 + this.gridMin[2];
                        break;
                    }
                    case 1: {
                        x = 0.0 + this.gridMin[0];
                        y = v + this.gridMin[1];
                        z = u + this.gridMin[2];
                        break;
                    }
                    case 2: {
                        x = v + this.gridMin[0];
                        y = 0.0 + this.gridMin[1];
                        z = u + this.gridMin[2];
                    }
                }
                try {
                    this.coords[i][j] = new Vector(x, y, z);
                }
                catch (Exception exception) {
                    this.coords[i][j] = ORIGIN;
                }
                ++j;
            }
            ++i;
        }
        this.allPartsList = null;
    }
}

