/*
 * Decompiled with CFR 0.152.
 */
package NCTR.graph.SciGraph;

import NCTR.graph.SciGraph.SciGraph;
import NCTR.graph.SciGraph.SgGraphItemPart;
import NCTR.graph.SciGraph.SgLine;
import NCTR.graph.SciGraph.SgPlate;
import NCTR.graph.SciGraph.Utils;
import NCTR.graph.SciGraph.Vector;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.LinkedList;

public abstract class SgGraphItem<K, L> {
    protected boolean visible = true;
    protected K id = null;
    protected boolean selected = false;
    protected double xLoc = 0.0;
    protected double yLoc = 0.0;
    protected double zLoc = 0.0;
    boolean isSurface = false;
    int curveWidth = 2;
    boolean absoluteWidth = false;
    protected int stepH = 11;
    protected int stepV = 11;
    public boolean fillSurface = true;
    protected Color curveColor = Color.BLACK;
    protected Color surfaceColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    protected Vector[][] coords = null;
    protected LinkedList<SgGraphItemPart> allPartsList = null;

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean flag) {
        this.visible = flag;
    }

    public K getID() {
        return this.id;
    }

    public void setID(K _id) {
        this.id = _id;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean flag) {
        this.selected = flag;
        if (this.allPartsList != null) {
            for (SgGraphItemPart elementCurve : this.allPartsList) {
                if (!(elementCurve instanceof SgPlate)) continue;
                ((SgPlate)elementCurve).setNoLines(!this.selected);
            }
        }
    }

    public boolean isData() {
        return true;
    }

    public void setLocation(double x, double y, double z) {
        this.xLoc = x;
        this.yLoc = y;
        this.zLoc = z;
        this.parseFunction();
    }

    public double getX() {
        return this.xLoc;
    }

    public double getY() {
        return this.yLoc;
    }

    public double getZ() {
        return this.zLoc;
    }

    public Color getSurfaceColor() {
        return this.surfaceColor;
    }

    public void setSurfaceColor(Color c) {
        this.surfaceColor = c;
        this.allPartsList = null;
    }

    public String toString() {
        return this.getClass().getCanonicalName();
    }

    public String generateTestCase(String dataType) {
        String className = this.getClass().getCanonicalName();
        return "// incomplete code -- " + className + ".generateTestCase(String dataType) needs to be defined. ";
    }

    public int addAllElementsToList(SciGraph<K, L> sg) {
        int cnt = 0;
        LinkedList<SgGraphItemPart> list = new LinkedList<SgGraphItemPart>();
        int j = this.stepH;
        int k = this.stepV;
        int l = 0;
        while (l < j - 1) {
            if (this.isSurface) {
                SgLine elementcurve = new SgLine(this.coords[l][0], this.coords[l + 1][0], this.curveColor, this.curveWidth, this.absoluteWidth);
                list.add(elementcurve);
                ++cnt;
            } else {
                int i1 = 0;
                while (i1 < k - 1) {
                    if (this.fillSurface) {
                        SgPlate elementrect = new SgPlate(this.coords[l][i1], this.coords[l + 1][i1], this.coords[l + 1][i1 + 1], this.coords[l][i1 + 1], this.curveColor, this.surfaceColor, !this.selected);
                        list.add(elementrect);
                        ++cnt;
                    } else {
                        SgLine elementcurve1 = new SgLine(this.coords[l][i1], this.coords[l + 1][i1], this.curveColor, 0, true);
                        list.add(elementcurve1);
                        ++cnt;
                        elementcurve1 = new SgLine(this.coords[l][i1], this.coords[l][i1 + 1], this.curveColor, 0, true);
                        list.add(elementcurve1);
                        ++cnt;
                        if (l == j - 2) {
                            elementcurve1 = new SgLine(this.coords[l + 1][i1 + 1], this.coords[l + 1][i1], this.curveColor, 0, true);
                            list.add(elementcurve1);
                            ++cnt;
                        }
                        if (i1 == k - 2) {
                            elementcurve1 = new SgLine(this.coords[l + 1][i1 + 1], this.coords[l][i1 + 1], this.curveColor, 0, true);
                            list.add(elementcurve1);
                            ++cnt;
                        }
                    }
                    ++i1;
                }
            }
            ++l;
        }
        this.allPartsList = list;
        return cnt;
    }

    public void setTransparency(double transparant) {
        if (this.allPartsList == null) {
            return;
        }
        for (SgGraphItemPart elementCurve : this.allPartsList) {
            elementCurve.setTransparency(transparant);
        }
    }

    public void recalcVisible(SciGraph<K, L> sg) {
        if (this.allPartsList == null) {
            this.addAllElementsToList(sg);
        }
        for (SgGraphItemPart elementCurve : this.allPartsList) {
            elementCurve.recalcVisible(sg);
        }
    }

    public int addVisibleElementsToList(SciGraph<K, L> sg, LinkedList<SgGraphItemPart> linkedlist) {
        int cnt = 0;
        if (!this.visible) {
            return cnt;
        }
        if (this.allPartsList == null) {
            this.addAllElementsToList(sg);
        }
        for (SgGraphItemPart elementCurve : this.allPartsList) {
            if (!elementCurve.isRenderable()) continue;
            linkedlist.add(elementCurve);
            ++cnt;
        }
        return cnt;
    }

    public void paintAsWireframe(SciGraph<K, L> sg, Graphics2D graphics2d) {
        if (!this.visible) {
            return;
        }
        if (!this.isSurface && this.fillSurface) {
            graphics2d.setColor(Utils.blendColors(Color.BLACK, this.surfaceColor, 0.5));
        } else {
            graphics2d.setColor(Utils.blendColors(Color.BLACK, this.curveColor, 0.5));
        }
        if (this.isSurface) {
            int k = 0;
            while (k < this.stepH - 1) {
                sg.draw3DLine(graphics2d, this.coords[k][0], this.coords[k + 1][0]);
                ++k;
            }
        } else {
            int l = 0;
            while (l == 0 || l < this.stepH) {
                int i1 = 0;
                while (i1 < this.stepV) {
                    if (i1 < this.coords[l].length - 1) {
                        sg.draw3DLine(graphics2d, this.coords[l][i1], this.coords[l][i1 + 1]);
                    }
                    if (l < this.coords.length - 1) {
                        sg.draw3DLine(graphics2d, this.coords[l][i1], this.coords[l + 1][i1]);
                    }
                    ++i1;
                }
                ++l;
            }
        }
    }

    public void randomInitialize() {
        this.stepH = 31;
        this.stepV = 31;
        this.surfaceColor = Color.MAGENTA;
        this.parseFunction();
    }

    public abstract void parseFunction();
}

