/*
 * Decompiled with CFR 0.152.
 */
package NCTR.graph.SciGraph;

import NCTR.graph.SciGraph.JColor;
import NCTR.graph.SciGraph.SciGraph;
import NCTR.graph.SciGraph.SgGraphItemPart;
import NCTR.graph.SciGraph.SgLine;
import NCTR.graph.SciGraph.SgString;
import NCTR.graph.SciGraph.Utils;
import NCTR.graph.SciGraph.Vector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class SgGraphAxes {
    private final Vector[] axisVectors = new Vector[]{new Vector(1.0, 0.0, 0.0), new Vector(0.0, 1.0, 0.0), new Vector(0.0, 0.0, 1.0)};
    private boolean[] shown = new boolean[]{true, true, true};
    private double[] axisMin = new double[]{0.0, 0.0, 0.0};
    private double[] axisMax = new double[]{1.0, 1.0, 1.0};
    private Color color = null;
    private int width = 1;
    private boolean useTicks = true;
    private String[] axisLabels = new String[]{"X", "Y", "Z"};
    private JCheckBox[] axisShown = null;
    private JSpinner[] spnAxesMin = null;
    private JSpinner[] spnAxesMax = null;
    private JColor axesColor = null;
    private JSpinner spnAxesIncr = null;
    private JSpinner spnAxesTicks = null;
    private JSpinner spnAxesWidth = null;
    protected LinkedList<SgGraphItemPart> allPartsList = null;

    public SgGraphAxes() {
        this.color = Color.blue;
    }

    public boolean isAxisShown() {
        return this.shown[0] | this.shown[1] | this.shown[2];
    }

    public void setAxesLabels(String x, String y, String z) {
        this.axisLabels[0] = x;
        this.axisLabels[1] = y;
        this.axisLabels[2] = z;
    }

    public void setUseAxesTicks(boolean flag) {
        this.useTicks = flag;
        this.addAllElementsToList();
    }

    public void setAxesMin(double minX, double minY, double minZ) {
        this.axisMin[0] = minX;
        this.axisMin[1] = minY;
        this.axisMin[2] = minZ;
    }

    public void setAxesMax(double maxX, double maxY, double maxZ) {
        this.axisMax[0] = maxX;
        this.axisMax[1] = maxY;
        this.axisMax[2] = maxZ;
    }

    public void setShowAxis(boolean flag) {
        int i = 0;
        while (i < 3) {
            this.shown[i] = flag;
            ++i;
        }
    }

    public void paintAsWireframe(SciGraph<?, ?> sg, Graphics2D graphics2d) {
        graphics2d.setColor(Utils.blendColors(this.color, Color.WHITE, 0.75));
        int i = 0;
        while (i < 3) {
            if (this.shown[i]) {
                double min = this.axisMin[i];
                double max = this.axisMax[i];
                sg.draw3DLine(graphics2d, this.axisVectors[i].scalarMult(min), this.axisVectors[i].scalarMult(max));
            }
            ++i;
        }
    }

    private Container createAxisExtents() {
        Box box = new Box(1);
        int i = 0;
        while (i < 3) {
            int j = i != 0 ? 3 - i : 0;
            Box box1 = new Box(0);
            box1.add(new JLabel(this.axisLabels[j]));
            this.axisShown[j] = new JCheckBox();
            box1.add(this.axisShown[j]);
            box1.add(Box.createHorizontalStrut(5));
            this.spnAxesMin[j] = new JSpinner(new SpinnerNumberModel(0.0, -5000.0, 5000.0, 0.1));
            box1.add(Utils.labeledComponent("Min:", this.spnAxesMin[j], true));
            box1.add(Box.createHorizontalStrut(5));
            this.spnAxesMax[j] = new JSpinner(new SpinnerNumberModel(1.0, -5000.0, 5000.0, 0.1));
            box1.add(Utils.labeledComponent("Max:", this.spnAxesMax[j], true));
            box1.setAlignmentX(1.0f);
            box.add(box1);
            ++i;
        }
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        return box;
    }

    private Container createAxisControls() {
        this.axisShown = new JCheckBox[3];
        this.spnAxesMin = new JSpinner[3];
        this.spnAxesMax = new JSpinner[3];
        this.axesColor = new JColor(50, 20);
        this.spnAxesWidth = new JSpinner(new SpinnerNumberModel(2, 1, 3, 1));
        this.spnAxesIncr = new JSpinner(new SpinnerNumberModel(0.1, 0.0, 500.0, 0.01));
        this.spnAxesTicks = new JSpinner(new SpinnerNumberModel(0.1, 0.0, 5000.0, 0.05));
        JPanel jpanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(0, 5, 3, 5);
        gridbagconstraints.gridwidth = 1;
        gridbagconstraints.gridy = 0;
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.fill = 2;
        jpanel.add((Component)Utils.labeledComponent("Axis color:", this.axesColor, true), gridbagconstraints);
        jpanel.add((Component)Utils.labeledComponent("Line width:", this.spnAxesWidth, true), gridbagconstraints);
        gridbagconstraints.gridy = 1;
        jpanel.add((Component)Utils.labeledComponent("Step density:", this.spnAxesIncr, true), gridbagconstraints);
        jpanel.add((Component)Utils.labeledComponent("Tick density:", this.spnAxesTicks, true), gridbagconstraints);
        gridbagconstraints.gridy = 2;
        gridbagconstraints.gridwidth = 0;
        jpanel.add((Component)this.createAxisExtents(), gridbagconstraints);
        jpanel.setBorder(BorderFactory.createTitledBorder("Axis Settings"));
        return jpanel;
    }

    public Container createAxisPane() {
        JPanel jpanel = new JPanel(new GridBagLayout());
        jpanel.add(this.createAxisControls());
        return jpanel;
    }

    public void addAxesItems(LinkedList<SgGraphItemPart> linkedlist) {
        if (this.allPartsList == null) {
            this.addAllElementsToList();
        }
        for (SgGraphItemPart element : this.allPartsList) {
            linkedlist.add(element);
        }
    }

    public void recalcVisible(SciGraph<?, ?> sg) {
        if (this.allPartsList == null) {
            this.addAllElementsToList();
        }
        for (SgGraphItemPart elementCurve : this.allPartsList) {
            elementCurve.recalcVisible(sg);
        }
    }

    public double numRound(double d, double incr) {
        if (incr > 100.0) {
            d = (double)Math.round(d / 100.0) * 100.0;
        } else if (incr > 10.0) {
            d = (double)Math.round(d / 10.0) * 10.0;
        } else if (incr > 1.0) {
            d = Math.round(d);
        } else if (incr > 0.1) {
            d = (double)Math.round(d * 10.0) / 10.0;
        } else if (incr > 0.01) {
            d = (double)Math.round(d * 100.0) / 100.0;
        } else if (incr > 0.001) {
            d = (double)Math.round(d * 1000.0) / 1000.0;
        }
        return d;
    }

    public void addAllElementsToList() {
        LinkedList<SgGraphItemPart> list = new LinkedList<SgGraphItemPart>();
        int i = 0;
        while (i < 3) {
            if (this.shown[i]) {
                Vector vec = this.axisVectors[i];
                double min = this.axisMin[i];
                double max = this.axisMax[i];
                double incr = (max - min) / 64.0;
                double d = min;
                while (d < max) {
                    list.add(new SgLine(vec.scalarMult(d), vec.scalarMult(d + incr), this.color, this.width, true));
                    d += incr;
                }
                if (this.useTicks) {
                    double tIncr = (max - min) / 8.0;
                    double d2 = min;
                    while (d2 < max) {
                        if ((d2 = this.numRound(d2, tIncr)) != 0.0) {
                            String s = NumberFormat.getInstance().format(d2);
                            list.add(new SgString(s, vec.scalarMult(d2), this.color, vec));
                        }
                        d2 += tIncr;
                    }
                }
                Vector vec1 = this.axisVectors[i != 0 ? 0 : 2];
                list.add(new SgLine(vec.scalarMult(max), vec.scalarMult(max * 0.97).substract(vec1.scalarMult(0.03)), this.color, this.width, true));
                list.add(new SgLine(vec.scalarMult(max), vec.scalarMult(max * 0.97).add(vec1.scalarMult(0.03)), this.color, this.width, true));
                if (this.useTicks) {
                    list.add(new SgString(this.axisLabels[i], vec.scalarMult(max * 1.05), this.color, null));
                } else {
                    list.add(new SgString(String.valueOf(this.axisLabels[i]) + " " + this.numRound(max, incr), vec.scalarMult(max * 1.05), this.color, null));
                    list.add(new SgString(" " + this.numRound(min, incr), vec.scalarMult(min), this.color, null));
                }
            }
            ++i;
        }
        this.allPartsList = list;
    }
}

