/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.AppFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClUtils;
import NCTR.app.arraytrack.vs2.analysis.clustering.ColumnHeaderRenderer;
import NCTR.app.arraytrack.vs2.analysis.clustering.FileFilters;
import NCTR.app.arraytrack.vs2.analysis.clustering.HeaderListener;
import NCTR.app.arraytrack.vs2.analysis.clustering.MyTableCellRenderer;
import NCTR.app.arraytrack.vs2.analysis.clustering.MyTableModel;
import NCTR.app.arraytrack.vs2.analysis.clustering.TableFrame_this_internalFrameAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.TableHeader;
import NCTR.app.arraytrack.vs2.analysis.clustering.TableListener;
import NCTR.app.arraytrack.vs2.analysis.clustering.TablemouseMotionAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class TableFrame
extends JInternalFrame {
    static int openFrameCount = 1;
    MyTableModel m_dm;
    AppFrame m_appFrame;
    String m_FileName = "";
    TableListener tableListener;
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable jTable;

    public TableFrame(AppFrame appFrame, MyTableModel dm) {
        super("Table", true, true, true, true);
        this.m_appFrame = appFrame;
        this.setTitle("Table" + openFrameCount++);
        this.m_dm = dm;
        this.m_appFrame.getTitle().equals("Principal Component Analysis");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setSizeLocation() {
        int[] loc = this.m_appFrame.getSubWindowLocaton();
        this.setSize(loc[0], loc[1]);
        this.setLocation(loc[2], loc[3]);
        this.m_appFrame.desktop.add(this);
        this.setVisible(true);
        Dimension ss = this.getMinimumSize();
        if (ss.height != AppFrame.m_yOffset) {
            AppFrame.m_xOffset = AppFrame.m_yOffset = this.getMinimumSize().height;
        }
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException x) {
            System.out.println(x.getMessage());
        }
    }

    private void jbInit() throws Exception {
        this.setFrameIcon(this.m_appFrame.imgTable);
        this.jScrollPane1.setBorder(null);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.addInternalFrameListener(new TableFrame_this_internalFrameAdapter(this));
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jTable = new JTable(this.m_dm);
        ((DefaultTableCellRenderer)this.jTable.getDefaultRenderer(String.class)).setHorizontalAlignment(4);
        MyTableCellRenderer rowRenderer = new MyTableCellRenderer();
        this.jTable.setDefaultRenderer(TableHeader.class, rowRenderer);
        this.jTable.setAutoResizeMode(0);
        this.jTable.getTableHeader().setReorderingAllowed(false);
        ColumnHeaderRenderer colRenderer = new ColumnHeaderRenderer();
        TableColumnModel model = this.jTable.getColumnModel();
        int n = this.jTable.getColumnCount();
        int i = 1;
        while (i < n) {
            model.getColumn(i).setHeaderRenderer(colRenderer);
            ++i;
        }
        JTableHeader header = this.jTable.getTableHeader();
        header.addMouseListener(new HeaderListener(header, colRenderer, this));
        this.tableListener = new TableListener(this.jTable, rowRenderer, colRenderer, this);
        this.jTable.addMouseListener(this.tableListener);
        this.jTable.addMouseMotionListener(new TablemouseMotionAdapter(this.jTable, colRenderer));
        this.jScrollPane1.getViewport().add((Component)this.jTable, null);
        this.setSizeLocation();
    }

    public TableListener getTableListener() {
        return this.tableListener;
    }

    public JPopupMenu getPopupMenu() {
        return this.tableListener.getPopupMenu();
    }

    public void SaveAsData() {
        JFileChooser chooser = new JFileChooser(AppFrame.last_user_path);
        chooser.addChoosableFileFilter(FileFilters.getDataFileFilter());
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        String fileName = chooser.getSelectedFile().getPath();
        AppFrame.last_user_path = chooser.getSelectedFile().getParentFile();
        String ext = ClUtils.getExtension(fileName);
        if (ext == null) {
            fileName = String.valueOf(fileName) + ".txt";
        }
        this.m_FileName = fileName;
        this.setTitle(fileName);
        this.m_dm.writeTableToFile(fileName);
        JOptionPane.showMessageDialog(this, "Done!", "Save data", -1);
    }

    public void SaveData() {
        String fileName = "";
        if (this.m_FileName.equals("") || ClUtils.getExtension(this.m_FileName).equals("xls")) {
            this.SaveAsData();
            return;
        }
        fileName = this.m_FileName;
        this.m_dm.writeTableToFile(fileName);
        JOptionPane.showMessageDialog(this, "Done!", "Save data", -1);
    }

    void this_internalFrameActivated(InternalFrameEvent e) {
        this.m_appFrame.jClustering.setEnabled(true);
        this.m_appFrame.jSaveFile.setEnabled(true);
        this.m_appFrame.jButton_PCA.setEnabled(true);
        this.m_appFrame.jButton_TransposeTable.setEnabled(true);
        this.m_appFrame.jButton_Kmeans.setEnabled(true);
    }

    void this_internalFrameClosed() {
        if (this.m_appFrame.IsTableSelected()) {
            return;
        }
        this.m_appFrame.jClustering.setEnabled(false);
        this.m_appFrame.jSaveFile.setEnabled(false);
        this.m_appFrame.jButton_PCA.setEnabled(false);
        this.m_appFrame.jButton_Kmeans.setEnabled(false);
        this.m_appFrame.jButton_TransposeTable.setEnabled(false);
    }
}

