/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.PCAResults;
import NCTR.util.math.la.Matrix;
import org.netlib.lapack.Dgesvd;
import org.netlib.lapack.Dsyev;
import org.netlib.util.intW;

public class PCAEngine {
    static final double eps = 2.2204E-16;

    public PCAResults doPCA(double[][] data, String[] row_labels, String[] orig_coord_names, boolean standardize_data) throws Exception {
        this.fillNaNsWithAvgDataVal(data, row_labels);
        if (standardize_data) {
            this.standardizeData(data);
        } else {
            this.centerizeData(data);
        }
        Decomp decomp = data.length > data[0].length ? this.doSVD(data) : this.doEVD(data);
        return new PCAResults(new Matrix(decomp.scores), row_labels, new Matrix(decomp.loadings), orig_coord_names, decomp.eigenvalues);
    }

    void centerizeData(double[][] data) {
        int rows = data.length;
        int cols = data[0].length;
        int i = 0;
        while (i < cols) {
            double avg = 0.0;
            int j = 0;
            while (j < rows) {
                avg += data[j][i];
                ++j;
            }
            avg /= (double)rows;
            j = 0;
            while (j < rows) {
                double[] dArray = data[j];
                int n = i;
                dArray[n] = dArray[n] - avg;
                ++j;
            }
            ++i;
        }
    }

    void fillNaNsWithAvgDataVal(double[][] data, String[] row_labels) throws Exception {
        int j = 0;
        while (j < data.length) {
            double sum = 0.0;
            int count = 0;
            int i = 0;
            while (i < data[0].length) {
                if (!Double.isNaN(data[j][i])) {
                    sum += data[j][i];
                    ++count;
                }
                ++i;
            }
            if (count < data[0].length) {
                if (count == 0) {
                    throw new Exception("No data available for identifier \"" + row_labels[j] + "\".  Please de-select this identifier and try again.");
                }
                sum /= (double)count;
                i = 0;
                while (i < data[0].length) {
                    if (Double.isNaN(data[j][i])) {
                        data[j][i] = sum;
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    private Decomp doSVD(double[][] data) {
        int j;
        Decomp decomp = new Decomp();
        int M = data.length;
        int N = data[0].length;
        double[] x = new double[M * N];
        int k = 0;
        double div = Math.sqrt(M - 1);
        int i = 0;
        while (i < N) {
            int j2 = 0;
            while (j2 < M) {
                x[k++] = data[j2][i] / div;
                ++j2;
            }
            ++i;
        }
        int min_M_N = Math.min(M, N);
        int lwork = Math.max(3 * min_M_N + Math.max(M, N), 5 * min_M_N);
        int lda = Math.max(1, M);
        int ldu = 1;
        int ldvt = 1;
        int offset = 0;
        double[] work = new double[lwork];
        double[] U = null;
        double[] S = new double[min_M_N];
        double[] VT = null;
        intW info = new intW(-1);
        Dgesvd.dgesvd((String)"N", (String)"O", (int)M, (int)N, (double[])x, (int)offset, (int)lda, (double[])S, (int)offset, U, (int)offset, (int)ldu, VT, (int)offset, (int)ldvt, (double[])work, (int)offset, (int)lwork, (intW)info);
        if (info.val != 0) {
            throw new RuntimeException("SVD routine returned error code " + info);
        }
        int c = 0;
        double tot = (double)Math.max(M, N) * S[0] * S[0] * 2.2204E-16;
        int i2 = 0;
        while (i2 < S.length) {
            if (S[i2] > tot) {
                ++c;
            }
            ++i2;
        }
        decomp.eigenvalues = new double[c];
        i2 = 0;
        while (i2 < c) {
            decomp.eigenvalues[i2] = S[i2] * S[i2];
            ++i2;
        }
        decomp.loadings = new double[N][c];
        i2 = 0;
        while (i2 < N) {
            j = 0;
            while (j < c) {
                decomp.loadings[i2][j] = x[i2 * M + j];
                ++j;
            }
            ++i2;
        }
        decomp.scores = new double[M][c];
        i2 = 0;
        while (i2 < M) {
            j = 0;
            while (j < c) {
                decomp.scores[i2][j] = 0.0;
                int m = 0;
                while (m < N) {
                    double[] dArray = decomp.scores[i2];
                    int n = j;
                    dArray[n] = dArray[n] + data[i2][m] * decomp.loadings[m][j];
                    ++m;
                }
                ++j;
            }
            ++i2;
        }
        return decomp;
    }

    private double[] covarianceMatrix(double[][] data) {
        int rows = data.length;
        int cols = data[0].length;
        double[] cov = new double[rows * rows];
        int N = rows - 1;
        int r = 0;
        while (r < rows) {
            int c = r;
            while (c < rows) {
                int index = c * rows + r;
                cov[index] = 0.0;
                int i = 0;
                while (i < cols) {
                    int n = index;
                    cov[n] = cov[n] + data[r][i] * data[c][i];
                    ++i;
                }
                int n = index;
                cov[n] = cov[n] / (double)N;
                ++c;
            }
            ++r;
        }
        return cov;
    }

    private Decomp doEVD(double[][] data) {
        int r;
        Decomp decomp = new Decomp();
        int N = data.length;
        int offset = 0;
        int lda = Math.max(1, N);
        int lwork = Math.max(1, 3 * N - 1);
        double[] work = new double[lwork];
        double[] w = new double[N];
        double[] x = this.covarianceMatrix(data);
        intW info = new intW(-1);
        Dsyev.dsyev((String)"V", (String)"U", (int)N, (double[])x, (int)offset, (int)lda, (double[])w, (int)offset, (double[])work, (int)offset, (int)lwork, (intW)info);
        if (info.val != 0) {
            throw new RuntimeException("SVD routine returned error code " + info);
        }
        int cc = 0;
        double tol = (double)N * w[N - 1] * 2.2204E-16;
        int i = 0;
        while (i < N) {
            if (w[i] > tol) {
                cc = i;
                break;
            }
            ++i;
        }
        cc = N - cc;
        decomp.eigenvalues = new double[cc];
        i = 0;
        while (i < cc) {
            decomp.eigenvalues[i] = w[N - i - 1];
            ++i;
        }
        double[][] p = new double[cc][N];
        int i2 = 0;
        while (i2 < cc) {
            int j = 0;
            while (j < N) {
                p[i2][j] = x[(N - i2 - 1) * N + j];
                ++j;
            }
            ++i2;
        }
        x = null;
        int row = data[0].length;
        double[] div = new double[cc];
        double tmp = Math.sqrt(N - 1);
        int i3 = 0;
        while (i3 < cc) {
            div[i3] = tmp * Math.sqrt(decomp.eigenvalues[i3]);
            ++i3;
        }
        decomp.loadings = new double[row][cc];
        int c = 0;
        while (c < cc) {
            r = 0;
            while (r < row) {
                decomp.loadings[r][c] = 0.0;
                int i4 = 0;
                while (i4 < N) {
                    double[] dArray = decomp.loadings[r];
                    int n = c;
                    dArray[n] = dArray[n] + data[i4][r] * p[c][i4];
                    ++i4;
                }
                double[] dArray = decomp.loadings[r];
                int n = c;
                dArray[n] = dArray[n] / div[c];
                ++r;
            }
            ++c;
        }
        decomp.scores = new double[N][cc];
        int nNum = data[0].length;
        r = 0;
        while (r < N) {
            int c2 = 0;
            while (c2 < cc) {
                decomp.scores[r][c2] = 0.0;
                int i5 = 0;
                while (i5 < nNum) {
                    double[] dArray = decomp.scores[r];
                    int n = c2;
                    dArray[n] = dArray[n] + data[r][i5] * decomp.loadings[i5][c2];
                    ++i5;
                }
                ++c2;
            }
            ++r;
        }
        return decomp;
    }

    private void standardizeData(double[][] data) {
        int rows = data.length;
        int cols = data[0].length;
        int i = 0;
        while (i < cols) {
            double avg = 0.0;
            int j = 0;
            while (j < rows) {
                avg += data[j][i];
                ++j;
            }
            avg /= (double)rows;
            double sd = 0.0;
            double tmp = 0.0;
            int j2 = 0;
            while (j2 < rows) {
                tmp = data[j2][i] - avg;
                sd += tmp * tmp;
                ++j2;
            }
            sd = Math.sqrt(sd / (double)(rows - 1));
            j2 = 0;
            while (j2 < rows) {
                data[j2][i] = sd == 0.0 ? 0.0 : (data[j2][i] - avg) / sd;
                ++j2;
            }
            ++i;
        }
    }

    public static class Decomp {
        double[] eigenvalues = null;
        double[][] scores = null;
        double[][] loadings = null;
    }
}

