/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.MainSwatchPanel;
import NCTR.app.arraytrack.vs2.analysis.clustering.QuickpickSwatchPanel;
import NCTR.app.arraytrack.vs2.analysis.clustering.RecentSwatchPanel;
import NCTR.app.arraytrack.vs2.analysis.clustering.SwatchPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class MySwatchChooserPanel
extends AbstractColorChooserPanel {
    SwatchPanel swatchPanel;
    RecentSwatchPanel recentSwatchPanel;
    QuickpickSwatchPanel quickpickSwatchPanel;
    MouseListener mainSwatchListener;
    MouseListener recentSwatchListener;
    MouseListener quickpickSwatchListener;
    private static String recentStr = UIManager.getString("ColorChooser.swatchesRecentText");

    public MySwatchChooserPanel() {
        this.setInheritsPopupMenu(true);
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString("ColorChooser.swatchesNameText");
    }

    @Override
    public int getMnemonic() {
        return this.getInt("ColorChooser.swatchesMnemonic", -1);
    }

    private int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return this.getInt("ColorChooser.swatchesDisplayedMnemonicIndex", -1);
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
    }

    @Override
    protected void buildChooser() {
        JPanel superHolder = new JPanel(new BorderLayout());
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.putClientProperty("AccessibleName", this.getDisplayName());
        this.swatchPanel.setInheritsPopupMenu(true);
        this.recentSwatchPanel = new RecentSwatchPanel();
        this.recentSwatchPanel.putClientProperty("AccessibleName", recentStr);
        this.quickpickSwatchPanel = new QuickpickSwatchPanel();
        this.quickpickSwatchPanel.putClientProperty("AccessibleName", "Quick pick:");
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.recentSwatchListener = new RecentSwatchListener();
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        this.recentSwatchPanel.setInheritsPopupMenu(true);
        this.quickpickSwatchListener = new QuickpickSwatchListener();
        this.quickpickSwatchPanel.addMouseListener(this.quickpickSwatchListener);
        this.quickpickSwatchPanel.setInheritsPopupMenu(true);
        JPanel mainHolder = new JPanel(new BorderLayout());
        CompoundBorder border = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        mainHolder.setBorder(border);
        mainHolder.add((Component)this.swatchPanel, "Center");
        superHolder.add((Component)mainHolder, "North");
        JPanel recentHolder = new JPanel(new BorderLayout());
        recentHolder.setBorder(border);
        recentHolder.setInheritsPopupMenu(true);
        recentHolder.add((Component)this.recentSwatchPanel, "Center");
        JPanel r1 = new JPanel(new BorderLayout());
        r1.add((Component)new JLabel("  Recent:"), "North");
        JPanel r0 = new JPanel();
        r0.add(recentHolder);
        recentHolder.setAlignmentX(1.0f);
        r1.add((Component)r0, "South");
        JPanel quickpickHolder = new JPanel(new BorderLayout());
        quickpickHolder.setBorder(border);
        quickpickHolder.setInheritsPopupMenu(true);
        quickpickHolder.add((Component)this.quickpickSwatchPanel, "Center");
        JPanel q1 = new JPanel(new BorderLayout());
        q1.add((Component)new JLabel("  Quick pick:"), "North");
        JPanel q0 = new JPanel();
        q0.add(quickpickHolder);
        quickpickHolder.setAlignmentX(1.0f);
        q1.add((Component)q0, "South");
        JPanel two = new JPanel();
        two.add(r1);
        JPanel p0 = new JPanel();
        p0.setPreferredSize(new Dimension(10, 20));
        two.add(p0);
        two.add(q1);
        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(100, 10));
        superHolder.add((Component)p, "Center");
        superHolder.add((Component)two, "South");
        superHolder.setInheritsPopupMenu(true);
        this.add(superHolder);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.recentSwatchPanel.removeMouseListener(this.recentSwatchListener);
        this.quickpickSwatchPanel.removeMouseListener(this.quickpickSwatchListener);
        this.swatchPanel = null;
        this.recentSwatchPanel = null;
        this.quickpickSwatchPanel = null;
        this.mainSwatchListener = null;
        this.recentSwatchListener = null;
        this.removeAll();
    }

    @Override
    public void updateChooser() {
    }

    class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        MainSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = MySwatchChooserPanel.this.swatchPanel.getColorForLocation(e.getX(), e.getY());
            MySwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
            MySwatchChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
        }
    }

    class QuickpickSwatchListener
    extends MouseAdapter
    implements Serializable {
        QuickpickSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = MySwatchChooserPanel.this.quickpickSwatchPanel.getColorForLocation(e.getX(), e.getY());
            MySwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
            MySwatchChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
        }
    }

    class RecentSwatchListener
    extends MouseAdapter
    implements Serializable {
        RecentSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = MySwatchChooserPanel.this.recentSwatchPanel.getColorForLocation(e.getX(), e.getY());
            MySwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

