/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.AppFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClUtils;
import NCTR.app.arraytrack.vs2.analysis.clustering.FileFilters;
import NCTR.app.arraytrack.vs2.analysis.clustering.ImageFrame_this_internalFrameAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyVetoException;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.InternalFrameEvent;

class ImageFrame
extends JInternalFrame {
    static int openFrameCount = 1;
    AppFrame m_appFrame;
    String m_FileName;
    JScrollPane jScrollPane1 = new JScrollPane();
    Border border1;
    ImagePanel jPanel_img = new ImagePanel();
    BufferedImage m_Image = null;
    int m_width;
    int m_height;
    File last_user_path = null;

    public ImageFrame(AppFrame appFrame) {
        super("Image", true, true, true, true);
        this.m_appFrame = appFrame;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTitle("Image" + openFrameCount++);
    }

    private void setSizeLocation() {
        int[] loc = this.m_appFrame.getSubWindowLocaton();
        this.setSize(loc[0], loc[1]);
        this.setLocation(loc[2], loc[3]);
        this.m_appFrame.desktop.add(this);
        this.setVisible(true);
        Dimension ss = this.getMinimumSize();
        if (ss.height != AppFrame.m_yOffset) {
            AppFrame.m_xOffset = AppFrame.m_yOffset = this.getMinimumSize().height;
        }
        try {
            if (this.m_Image != null) {
                this.jPanel_img.setPreferredSize(new Dimension(this.m_Image.getWidth(), this.m_Image.getHeight()));
                this.jPanel_img.revalidate();
            }
            this.setSelected(true);
        }
        catch (PropertyVetoException x) {
            System.out.println(x.getMessage());
        }
    }

    private void jbInit() throws Exception {
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.addInternalFrameListener(new ImageFrame_this_internalFrameAdapter(this));
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jPanel_img, null);
        this.setSizeLocation();
    }

    public void SaveData() {
        if (this.m_FileName.equals("")) {
            this.SaveAsData();
        } else {
            this.writeImage(this.m_FileName);
        }
    }

    private void writeImage(String fileName) {
        try {
            File file = new File(fileName);
            String ext = ClUtils.getExtension(file);
            ImageIO.write((RenderedImage)this.m_Image, ext, file);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void SaveAsData() {
        String fileName = null;
        JFileChooser chooser = new JFileChooser(this.last_user_path);
        chooser.addChoosableFileFilter(FileFilters.getImageFileFilter());
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        fileName = chooser.getSelectedFile().getPath();
        this.last_user_path = chooser.getSelectedFile().getParentFile();
        String ext = ClUtils.getExtension(fileName);
        if (ext == null) {
            fileName = String.valueOf(fileName) + ".png";
        }
        this.writeImage(fileName);
        this.m_FileName = fileName;
        this.setTitle(fileName);
    }

    public void LoadImage(String fileName) {
        try {
            File file = new File(fileName);
            this.m_Image = ImageIO.read(file);
            this.m_FileName = fileName;
            this.setTitle(fileName);
            if (this.m_Image != null) {
                this.jPanel_img.setPreferredSize(new Dimension(this.m_Image.getWidth(), this.m_Image.getHeight()));
                this.jPanel_img.revalidate();
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    void this_internalFrameActivated(InternalFrameEvent e) {
        this.m_appFrame.jButton_PCA.setEnabled(false);
        this.m_appFrame.jButton_TransposeTable.setEnabled(false);
    }

    class ImagePanel
    extends JPanel {
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (ImageFrame.this.m_Image != null) {
                ((Graphics2D)g).drawImage(ImageFrame.this.m_Image, 0, 0, null, null);
            }
        }
    }
}

