/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.AppFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClUtils;
import NCTR.app.arraytrack.vs2.analysis.clustering.PcaFrame;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codec.TIFFField;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class HighResImage {
    static final double dpi_default = 72.0;
    static final String resizeMSG = "The image size is too big.\nPlease apply \"Fit to Height\" first.";
    public static final String SAVEHIGNRESIMAGE = "Save As High Resolution Image (tiff)";

    private static BufferedImage createHighResImage(BufferedImage img, int dpi) throws IOException {
        BufferedImage bufferedImage = null;
        try {
            double scale = (double)dpi / 72.0;
            int w_new = (int)((double)img.getWidth() * scale);
            int h_new = (int)((double)img.getHeight() * scale);
            bufferedImage = new BufferedImage(w_new, h_new, img.getType());
            Graphics2D g2 = bufferedImage.createGraphics();
            AffineTransform xform = AffineTransform.getScaleInstance(scale, scale);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(img, xform, null);
            g2.dispose();
        }
        catch (OutOfMemoryError ex) {
            throw new IOException(resizeMSG);
        }
        return bufferedImage;
    }

    public static void saveTiff(BufferedImage img, int dpi, File file) throws IOException {
        if (img == null) {
            return;
        }
        try {
            BufferedImage bufferedImage = HighResImage.createHighResImage(img, dpi);
            FileOutputStream os = new FileOutputStream(file);
            TIFFEncodeParam encodeParam = new TIFFEncodeParam();
            int XRES_TAG = 282;
            int YRES_TAG = 283;
            int INCH_TAG = 296;
            long[] xResolutionArray = new long[]{dpi, 1L};
            long[] yResolutionArray = new long[]{dpi, 1L};
            long[] null_value = new long[2];
            TIFFField xRes = new TIFFField(282, 5, 1, new long[][]{xResolutionArray, null_value});
            TIFFField yRes = new TIFFField(283, 5, 1, new long[][]{yResolutionArray, null_value});
            TIFFField unit_Inch = new TIFFField(296, 3, 1, new char[]{'2'});
            encodeParam.setExtraFields(new TIFFField[]{xRes, yRes, unit_Inch});
            ImageEncoder encoder = ImageCodec.createImageEncoder("TIFF", os, encodeParam);
            encoder.encode(bufferedImage);
            os.close();
        }
        catch (OutOfMemoryError ex) {
            throw new IOException(resizeMSG);
        }
    }

    public static void SaveHighResImage(Component parent, BufferedImage img) {
        JFileChooser chooser = new JFileChooser(AppFrame.last_user_path);
        int returnVal = chooser.showSaveDialog(parent);
        if (returnVal == 0) {
            String fileName = chooser.getSelectedFile().getPath();
            AppFrame.last_user_path = chooser.getSelectedFile().getParentFile();
            String ext = ClUtils.getExtension(fileName);
            if (ext == null || ext == "") {
                fileName = String.valueOf(fileName) + ".tif";
            }
            try {
                HighResImage.saveTiff(img, 300, new File(fileName));
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(parent, resizeMSG);
            }
        }
    }

    public static BufferedImage pca3DScreenCapture(PcaFrame parent, JPanel panel) throws IOException {
        BufferedImage screenShot = null;
        try {
            Robot robot = new Robot();
            Rectangle rect = panel.getBounds();
            Point pt2 = parent.getRootPane().getLocation();
            Point pt1 = parent.getLocation();
            Rectangle rc = new Rectangle(pt1.x + pt2.x + 2, pt1.y + pt2.y + 2, rect.width, rect.height);
            screenShot = robot.createScreenCapture(rc);
        }
        catch (AWTException ex) {
            throw new IOException(ex.getMessage());
        }
        return screenShot;
    }
}

