/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.BoolPoint;
import NCTR.app.arraytrack.vs2.analysis.clustering.Cluster;
import NCTR.app.arraytrack.vs2.analysis.clustering.DrawNode;
import NCTR.app.arraytrack.vs2.analysis.clustering.GoThroughTree;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.util.HashMap;
import java.util.Stack;
import java.util.StringTokenizer;

public class ClusterTreeNode {
    static final int INITCOORDINATE = 0;
    static final int OUTPUTTREE = 1;
    static final int SETTREECOLOR = 2;
    static final int DRAWTREE = 3;
    static final int SELECTTREE = 4;
    static final int SETSTATE = 5;
    static final int GETLEAFNO = 6;
    static final int SETLEAFNO = 7;
    static final int SETPENWIDTH = 8;
    static final int GETMINEXP = 9;
    static final int ADJUSTTREE = 10;
    static final int SETVALUE = 11;
    static final int INITSAMPLECOLOR = 12;
    static final int[] m_xPoints = new int[3];
    static final int[] m_yPoints = new int[3];
    static int m_count = 0;
    static int m_gap = 16;
    static boolean m_bLogExp = false;
    static double m_minExp = 0.0;
    static double m_maxExp = 0.0;
    static int m_treeHeight = 100;
    static int m_leafHeight = 6;
    static boolean m_bLeftAlignment = false;
    static Font m_Font = null;
    static boolean m_bLabel = true;
    static int m_ExtentOfLabel = 0;
    static DrawNode m_drawNode = null;
    int[] m_set = null;
    float m_value = Float.NaN;
    float m_DisOfCombine = Float.MAX_VALUE;
    ClusterTreeNode m_left = null;
    ClusterTreeNode m_right = null;
    ClusterTreeNode m_parent = null;
    int m_nNoOfNode = -1;
    int m_nNumOfLeftLeaf = 1;
    int m_nNumOfRightLeaf = 0;
    float m_penWidth = 1.0f;
    boolean m_bSelected = false;
    Point m_NodeCoordinate = new Point(0, 0);
    Color m_color = Color.black;
    static int[] m_vertex = new int[4];

    public ClusterTreeNode() {
    }

    public ClusterTreeNode(int No, ClusterTreeNode parent) {
        this.m_nNoOfNode = No;
        this.m_parent = parent;
    }

    public ClusterTreeNode(int No, float value, float dis) {
        this.m_nNoOfNode = No;
        this.m_value = value;
        this.m_DisOfCombine = dis;
    }

    public ClusterTreeNode(int No, float value) {
        this.m_nNoOfNode = No;
        this.m_value = value;
    }

    public ClusterTreeNode(int No, float value, ClusterTreeNode left, ClusterTreeNode right) {
        this.m_nNoOfNode = No;
        this.m_value = value;
        this.m_left = left;
        this.m_right = right;
        if (this.m_left != null) {
            this.m_nNumOfLeftLeaf = this.m_left.m_nNumOfLeftLeaf + this.m_left.m_nNumOfRightLeaf;
            this.m_nNumOfRightLeaf = this.m_right.m_nNumOfLeftLeaf + this.m_right.m_nNumOfRightLeaf;
        }
    }

    private void InitialCoordinate() {
        double tmp;
        this.m_NodeCoordinate.y = this.m_left != null ? (this.m_left.m_NodeCoordinate.y + this.m_right.m_NodeCoordinate.y) / 2 : m_gap * ++m_count - m_gap / 2;
        if (m_bLogExp) {
            double mm = Math.log(m_minExp + 1.0);
            tmp = (Math.log(this.m_DisOfCombine + 1.0f) - mm) / (Math.log(m_maxExp + 1.0) - mm);
        } else {
            tmp = ((double)this.m_DisOfCombine - m_minExp) / (m_maxExp - m_minExp);
        }
        this.m_NodeCoordinate.x = (int)(tmp * (double)(m_treeHeight - m_leafHeight) + (double)m_leafHeight);
    }

    private void DrawNode() {
        if (this.m_parent != null) {
            int n = ClusterTreeNode.m_xPoints[0] = this.m_left != null ? this.m_left.m_NodeCoordinate.x : 0;
            if (this.m_NodeCoordinate.y >= m_vertex[2] && this.m_NodeCoordinate.y <= m_vertex[3] || this.m_parent.m_NodeCoordinate.y >= m_vertex[2] && this.m_parent.m_NodeCoordinate.y <= m_vertex[3]) {
                ClusterTreeNode.m_xPoints[1] = this.m_NodeCoordinate.x;
                ClusterTreeNode.m_yPoints[1] = this.m_NodeCoordinate.y;
                ClusterTreeNode.m_xPoints[2] = this.m_NodeCoordinate.x;
                ClusterTreeNode.m_yPoints[2] = this.m_parent.m_NodeCoordinate.y;
                ClusterTreeNode.m_yPoints[0] = this.m_NodeCoordinate.y;
                ClusterTreeNode.m_drawNode.m_g2.setColor(this.m_bSelected ? Color.cyan : this.m_color);
                ClusterTreeNode.m_drawNode.m_g2.setStroke(new BasicStroke(this.m_penWidth));
                ClusterTreeNode.m_drawNode.m_g2.drawPolyline(m_xPoints, m_yPoints, 3);
                if (m_bLabel && this.m_left == null && ClusterTreeNode.m_drawNode.m_label[this.m_nNoOfNode] != null && ClusterTreeNode.m_drawNode.m_label[this.m_nNoOfNode].length() > 0) {
                    FontRenderContext frc = ClusterTreeNode.m_drawNode.m_g2.getFontRenderContext();
                    TextLayout layout = new TextLayout(ClusterTreeNode.m_drawNode.m_label[this.m_nNoOfNode], m_Font, frc);
                    Rectangle2D rect = layout.getBounds();
                    int x = m_bLeftAlignment ? -m_ExtentOfLabel : m_xPoints[0] - (int)rect.getWidth() - 1;
                    int y = m_yPoints[0] - (int)rect.getHeight() / 2;
                    ClusterTreeNode.m_drawNode.m_g2.drawString(ClusterTreeNode.m_drawNode.m_label[this.m_nNoOfNode], x, y + (int)rect.getHeight());
                }
            }
        }
    }

    public static ClusterTreeNode PostOrderTree(ClusterTreeNode root, int method, Object operation) {
        if (root == null) {
            return null;
        }
        m_count = 0;
        double angle = -1.5707963267948966;
        if ((method == 0 || method == 3 || method == 4) && operation instanceof DrawNode) {
            m_drawNode = (DrawNode)operation;
            if (method == 3) {
                ClusterTreeNode.m_drawNode.m_g2.translate(ClusterTreeNode.m_drawNode.m_point.x, ClusterTreeNode.m_drawNode.m_point.y);
                ClusterTreeNode.m_vertex[0] = ClusterTreeNode.m_drawNode.m_view.x;
                ClusterTreeNode.m_vertex[1] = ClusterTreeNode.m_drawNode.m_view.x + ClusterTreeNode.m_drawNode.m_view.width;
                ClusterTreeNode.m_vertex[2] = ClusterTreeNode.m_drawNode.m_view.y;
                ClusterTreeNode.m_vertex[3] = ClusterTreeNode.m_drawNode.m_view.y + ClusterTreeNode.m_drawNode.m_view.height;
                if (ClusterTreeNode.m_drawNode.m_bHoriz) {
                    ClusterTreeNode.m_drawNode.m_g2.rotate(angle);
                }
            }
        }
        Stack<GoThroughTree> tree = new Stack<GoThroughTree>();
        GoThroughTree node = new GoThroughTree();
        node.SubTree = root;
        tree.push(node);
        while (!tree.empty()) {
            node = (GoThroughTree)tree.peek();
            if (node.bVisited) {
                switch (method) {
                    case 0: {
                        node.SubTree.InitialCoordinate();
                        break;
                    }
                    case 12: {
                        if (node.SubTree.m_left != null) break;
                        HashMap colorMap = (HashMap)operation;
                        node.SubTree.m_color = (Color)colorMap.get(new Integer(node.SubTree.m_nNoOfNode));
                        break;
                    }
                    case 1: {
                        BufferedWriter out = (BufferedWriter)operation;
                        try {
                            StringTokenizer t;
                            out.write(String.valueOf(Integer.toString(node.SubTree.m_nNoOfNode)) + " ");
                            out.write(String.valueOf(Integer.toString(node.SubTree.m_nNumOfLeftLeaf)) + " ");
                            out.write(String.valueOf(Integer.toString(node.SubTree.m_nNumOfRightLeaf)) + " ");
                            out.write(String.valueOf(Double.toString(node.SubTree.m_value)) + " ");
                            out.write(String.valueOf(Integer.toString(Cluster.ColorToInt(node.SubTree.m_color))) + " ");
                            out.write(String.valueOf(Double.toString(node.SubTree.m_penWidth)) + " ");
                            out.write(String.valueOf(Double.toString(node.SubTree.m_DisOfCombine)) + " ");
                            out.write(String.valueOf(Cluster.BooleanToString(node.SubTree.m_bSelected)) + " ");
                            out.write(String.valueOf(Integer.toString(node.SubTree.m_NodeCoordinate.x)) + " ");
                            out.write(String.valueOf(Integer.toString(node.SubTree.m_NodeCoordinate.y)) + " ");
                            if (node.SubTree != null) {
                                t = new StringTokenizer(node.SubTree.toString(), "@");
                                t.nextToken();
                                out.write(String.valueOf(Long.valueOf(t.nextToken(), 16).toString()) + " ");
                            } else {
                                out.write("-1 ");
                            }
                            if (node.SubTree.m_parent != null) {
                                t = new StringTokenizer(node.SubTree.m_parent.toString(), "@");
                                t.nextToken();
                                out.write(String.valueOf(Long.valueOf(t.nextToken(), 16).toString()) + "\n");
                                break;
                            }
                            out.write("-1\n");
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                        }
                        break;
                    }
                    case 2: {
                        node.SubTree.m_color = (Color)operation;
                        break;
                    }
                    case 3: {
                        node.SubTree.DrawNode();
                        ++m_count;
                        break;
                    }
                    case 4: {
                        BoolPoint t1 = (BoolPoint)operation;
                        ClusterTreeNode Tree = node.SubTree.FindSelectRoot(t1.m_bHoriz, t1.m_point);
                        if (Tree == null) break;
                        return Tree;
                    }
                    case 5: {
                        BoolPoint t3 = (BoolPoint)operation;
                        node.SubTree.m_bSelected = t3.m_bHoriz;
                        break;
                    }
                    case 6: {
                        if (node.SubTree.m_left != null) break;
                        int[] t2 = (int[])operation;
                        t2[ClusterTreeNode.m_count++] = node.SubTree.m_nNoOfNode;
                        break;
                    }
                    case 7: {
                        if (node.SubTree.m_left != null) break;
                        ++m_count;
                        node.SubTree.m_nNoOfNode = node.SubTree.m_nNoOfNode;
                        break;
                    }
                    case 8: {
                        node.SubTree.m_penWidth = ((Float)operation).intValue();
                        break;
                    }
                    case 9: {
                        if (!((double)node.SubTree.m_DisOfCombine < m_minExp)) break;
                        m_minExp = node.SubTree.m_DisOfCombine;
                        break;
                    }
                    case 11: {
                        float[] value = (float[])operation;
                        if (node.SubTree.m_left == null) {
                            node.SubTree.m_value = value[node.SubTree.m_nNoOfNode];
                            break;
                        }
                        node.SubTree.m_value = (node.SubTree.m_left.m_value * (float)node.SubTree.m_nNumOfLeftLeaf + node.SubTree.m_right.m_value * (float)node.SubTree.m_nNumOfRightLeaf) / (float)(node.SubTree.m_nNumOfLeftLeaf + node.SubTree.m_nNumOfRightLeaf);
                        break;
                    }
                    case 10: {
                        if (node.SubTree.m_left == null || !(node.SubTree.m_left.m_value > node.SubTree.m_right.m_value)) break;
                        ClusterTreeNode tmp = node.SubTree.m_left;
                        node.SubTree.m_left = node.SubTree.m_right;
                        node.SubTree.m_right = tmp;
                    }
                }
                tree.pop();
                continue;
            }
            ((GoThroughTree)tree.peek()).bVisited = true;
            if (node.SubTree.m_right == null) continue;
            GoThroughTree t1 = new GoThroughTree();
            t1.SubTree = node.SubTree.m_right;
            tree.push(t1);
            t1 = new GoThroughTree();
            t1.SubTree = node.SubTree.m_left;
            tree.push(t1);
        }
        if (method == 3) {
            if (ClusterTreeNode.m_drawNode.m_bHoriz) {
                ClusterTreeNode.m_drawNode.m_g2.rotate(-angle);
            }
            ClusterTreeNode.m_drawNode.m_g2.translate(-ClusterTreeNode.m_drawNode.m_point.x, -ClusterTreeNode.m_drawNode.m_point.y);
        }
        return null;
    }

    private ClusterTreeNode FindSelectRoot(boolean bHoriz, Point point) {
        if (this.m_left != null ? this.m_left.m_NodeCoordinate.y < point.y && this.m_right.m_NodeCoordinate.y > point.y && point.x < this.m_NodeCoordinate.x && point.x > this.m_left.m_NodeCoordinate.x : this.m_NodeCoordinate.y - 8 < point.y && this.m_NodeCoordinate.y + 8 > point.y && this.m_NodeCoordinate.x > point.x) {
            return this;
        }
        if (this.m_parent == null && this.m_left != null && this.m_left.m_NodeCoordinate.y < point.y && this.m_right.m_NodeCoordinate.y > point.y && point.x > this.m_left.m_NodeCoordinate.x) {
            return this;
        }
        return null;
    }

    public static ClusterTreeNode Copy(ClusterTreeNode root) {
        if (root == null) {
            return null;
        }
        ClusterTreeNode Tmp = new ClusterTreeNode();
        Tmp.m_nNoOfNode = root.m_nNoOfNode;
        Tmp.m_nNumOfLeftLeaf = root.m_nNumOfLeftLeaf;
        Tmp.m_nNumOfRightLeaf = root.m_nNumOfRightLeaf;
        Tmp.m_color = root.m_color;
        Tmp.m_DisOfCombine = root.m_DisOfCombine;
        Tmp.m_bSelected = root.m_bSelected;
        Tmp.m_NodeCoordinate = (Point)root.m_NodeCoordinate.clone();
        Tmp.m_penWidth = root.m_penWidth;
        Tmp.m_left = ClusterTreeNode.Copy(root.m_left);
        Tmp.m_right = ClusterTreeNode.Copy(root.m_right);
        if (Tmp.m_left != null) {
            Tmp.m_left.m_parent = Tmp;
        }
        if (Tmp.m_right != null) {
            Tmp.m_right.m_parent = Tmp;
        }
        return Tmp;
    }
}

