/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.analysis.clustering.Algorithm;
import NCTR.app.arraytrack.vs2.analysis.clustering.AppFrame;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClUtils;
import NCTR.app.arraytrack.vs2.analysis.clustering.Cluster;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClusterDlg_jCheckBox_ColLabel_itemAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClusterDlg_jCheckBox_NormalizeData_itemAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClusterDlg_jCheckBox_SortByValue_itemAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClusterDlg_jComboBox_Linkage_itemAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClusterDlg_jComboBox_Metric_itemAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.ClusterDlg_jComboBox_RowLable_itemAdapter;
import NCTR.app.arraytrack.vs2.analysis.clustering.TableFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ClusterDlg
extends JDialog
implements ActionListener,
ListSelectionListener {
    static final String MAXCOLOR = "Max Color";
    static final String MINCOLOR = "Min Color";
    static final String MEDIANLOWCOLOR = "Median Low Color";
    static final String MEDIANUPCOLOR = "Median Up Color";
    static final String SINGLECLUSTER = "Single Cluster";
    static final String DUALCLUSTER = "Dual Cluster";
    static final String COLORIMAGE = "Heat Map";
    AppFrame m_appFrame = null;
    JPanel jPanel1 = new JPanel(new BorderLayout());
    JPanel jPanel2 = new JPanel(new BorderLayout());
    JPanel jPanel3 = new JPanel(new GridLayout(5, 1, 0, 1));
    JPanel jPanel4 = new JPanel(new GridLayout(3, 1, 0, 1));
    JPanel jPanel5 = new JPanel(new GridLayout(1, 3, 3, 0));
    JPanel jPanel6 = new JPanel(new BorderLayout());
    JPanel jPanel7 = new JPanel(new GridLayout(8, 1, 0, 1));
    JPanel jPanel8 = new JPanel(new BorderLayout());
    JPanel jPanel10 = new JPanel(new FlowLayout());
    JPanel jPanel11 = new JPanel(new BorderLayout());
    JPanel jPanel_LinkageType = new JPanel();
    JPanel jPanel_Metric = new JPanel();
    JPanel jPanel_ShowLegend = new ShowLegendPanel();
    JPanel jPanel14 = new JPanel(new GridLayout(8, 1, 0, 1));
    JComboBox jComboBox_Metric = new JComboBox();
    JComboBox jComboBox_Linkage = new JComboBox();
    JComboBox jComboBox_RowLable = new JComboBox();
    JComboBox jComboBox_MedianUp = new JComboBox();
    JComboBox jComboBox_MedianLow = new JComboBox();
    JComboBox jComboBox_MaxLimit = new JComboBox();
    JComboBox jComboBox_MinLimit = new JComboBox();
    JCheckBox jCheckBox_NormalizeData = new JCheckBox();
    JCheckBox jCheckBox_SortByValue = new JCheckBox();
    JRadioButton jRadioButton_ColorImage = new JRadioButton();
    JRadioButton jRadioButton_DualCluster = new JRadioButton();
    JRadioButton jRadioButton_SingleCluster = new JRadioButton();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JButton jButton_OK = new JButton("OK");
    JButton jButton_Cancel = new JButton("Cancel");
    JButton jButton_MinColor = new JButton();
    JButton jButton_MedianLowColor = new JButton();
    JButton jButton_MedianUpColor = new JButton();
    JButton jButton_MaxColor = new JButton();
    JScrollPane jScrollPane1 = new JScrollPane();
    DefaultListModel listModel = new DefaultListModel();
    JList jList_Columns = new JList(this.listModel);
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    JLabel jLabel_Metric = new JLabel();
    JLabel jLabel_Option = new JLabel();
    JLabel jLabel_MinLimit = new JLabel();
    JLabel jLabel_MedianUp = new JLabel();
    JLabel jLabel_MaxLimit = new JLabel();
    JLabel jLabel_MedianLow = new JLabel();
    JLabel jLabel7 = new JLabel();
    JLabel jLabel8 = new JLabel();
    JLabel jLabel9 = new JLabel();
    JLabel jLabel10 = new JLabel();
    JLabel jLabel11 = new JLabel();
    Color m_MaximumColor = Color.red;
    Color m_MedianUpColor = Color.white;
    Color m_MedianLowColor = Color.white;
    Color m_MinimumColor = Color.blue;
    int m_Method;
    int m_Metric;
    int m_Dissimilarity;
    int m_nRowLabel = 0;
    boolean m_bSortValue;
    boolean m_bNormalize;
    boolean m_bHeader = true;
    boolean m_bGeneSearch = false;
    TableFrame m_table = null;
    JCheckBox jCheckBox_ColLabel = new JCheckBox();
    List<String>[] m_GroupColNames = null;

    private void setControlState1(boolean state) {
        this.jComboBox_MaxLimit.setEnabled(state);
        this.jComboBox_MedianUp.setEnabled(state);
        this.jComboBox_MedianLow.setEnabled(state);
        this.jComboBox_MinLimit.setEnabled(state);
        this.jButton_MaxColor.setEnabled(state);
        this.jButton_MedianUpColor.setEnabled(state);
        this.jButton_MedianLowColor.setEnabled(state);
        this.jButton_MinColor.setEnabled(state);
        this.jLabel_MaxLimit.setEnabled(state);
        this.jLabel_MedianUp.setEnabled(state);
        this.jLabel_MedianLow.setEnabled(state);
        this.jLabel_MinLimit.setEnabled(state);
        this.jPanel_ShowLegend.repaint();
    }

    private void setControlState2(boolean state) {
        this.jLabel_Option.setEnabled(state);
        this.jLabel_Metric.setEnabled(state);
        this.jComboBox_Metric.setEnabled(state);
        this.jComboBox_Linkage.setEnabled(state);
        if (!state) {
            this.titledBorder1.setTitleColor(Color.lightGray);
            this.titledBorder2.setTitleColor(Color.lightGray);
        } else {
            this.titledBorder1.setTitleColor(Color.black);
            this.titledBorder2.setTitleColor(Color.black);
        }
        this.repaint();
    }

    public ClusterDlg(Frame parent, TableFrame table) throws HeadlessException {
        super(parent);
        this.m_appFrame = (AppFrame)parent;
        this.m_table = table;
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Distance");
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "LinkageType");
        this.setTitle("Hierarchical Cluster Analysis(HCA)");
        this.setResizable(true);
        this.jRadioButton_ColorImage.setText(COLORIMAGE);
        this.jRadioButton_ColorImage.addActionListener(this);
        this.jRadioButton_DualCluster.setText(DUALCLUSTER);
        this.jRadioButton_DualCluster.addActionListener(this);
        this.jRadioButton_SingleCluster.setText(SINGLECLUSTER);
        this.jRadioButton_SingleCluster.addActionListener(this);
        this.jButton_OK.addActionListener(this);
        this.jButton_Cancel.addActionListener(this);
        this.jPanel11.setDebugGraphicsOptions(0);
        this.jLabel_Metric.setText("Metric:");
        this.jLabel_Option.setText("Option:");
        this.jLabel_MinLimit.setEnabled(true);
        this.jLabel_MinLimit.setText("Min Limit:");
        this.jLabel_MedianUp.setEnabled(true);
        this.jLabel_MedianUp.setText("Median Up:");
        this.jLabel_MaxLimit.setEnabled(true);
        this.jLabel_MaxLimit.setText("Max Limit:");
        this.jLabel_MedianLow.setEnabled(true);
        this.jLabel_MedianLow.setRequestFocusEnabled(true);
        this.jLabel_MedianLow.setText("Median Low:");
        this.jScrollPane1.setMinimumSize(new Dimension(29, 29));
        this.jScrollPane1.setPreferredSize(new Dimension(130, 61));
        this.jScrollPane1.setRequestFocusEnabled(true);
        this.jPanel7.setPreferredSize(new Dimension(83, 221));
        this.jPanel_Metric.setBorder(this.titledBorder1);
        this.jPanel_LinkageType.setBorder(this.titledBorder2);
        this.jPanel4.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Method Selection"));
        this.jCheckBox_NormalizeData.setText("Auto scale data");
        this.jCheckBox_NormalizeData.addItemListener(new ClusterDlg_jCheckBox_NormalizeData_itemAdapter(this));
        this.jCheckBox_SortByValue.setText("Cluster Sorted By Value");
        this.jCheckBox_SortByValue.addItemListener(new ClusterDlg_jCheckBox_SortByValue_itemAdapter(this));
        this.jComboBox_MaxLimit.setEnabled(true);
        this.jComboBox_MaxLimit.setInputVerifier(null);
        this.jComboBox_MaxLimit.setVerifyInputWhenFocusTarget(true);
        this.jComboBox_MaxLimit.setEditable(true);
        this.jComboBox_MedianUp.setEnabled(true);
        this.jComboBox_MedianUp.setEditable(true);
        this.jComboBox_MedianLow.setEnabled(true);
        this.jComboBox_MedianLow.setEditable(true);
        this.jComboBox_MinLimit.setEnabled(true);
        this.jComboBox_MinLimit.setEditable(true);
        this.jButton_MinColor.setEnabled(true);
        this.jButton_MinColor.setText("Color...");
        this.jButton_MinColor.setActionCommand(MINCOLOR);
        this.jButton_MinColor.addActionListener(this);
        this.jButton_MedianLowColor.setEnabled(true);
        this.jButton_MedianLowColor.setText("Color...");
        this.jButton_MedianLowColor.setActionCommand(MEDIANLOWCOLOR);
        this.jButton_MedianLowColor.addActionListener(this);
        this.jButton_MedianUpColor.setEnabled(true);
        this.jButton_MedianUpColor.setText("Color...");
        this.jButton_MedianUpColor.setActionCommand(MEDIANUPCOLOR);
        this.jButton_MedianUpColor.addActionListener(this);
        this.jButton_MaxColor.setEnabled(true);
        this.jButton_MaxColor.setText("Color...");
        this.jButton_MaxColor.setActionCommand(MAXCOLOR);
        this.jButton_MaxColor.addActionListener(this);
        this.jLabel7.setPreferredSize(new Dimension(9, 12));
        this.jLabel7.setText("   ");
        this.jLabel8.setPreferredSize(new Dimension(69, 12));
        this.jLabel8.setText("    ");
        this.jLabel9.setPreferredSize(new Dimension(69, 14));
        this.jLabel9.setText("   ");
        this.jLabel10.setPreferredSize(new Dimension(69, 14));
        this.jLabel10.setRequestFocusEnabled(true);
        this.jLabel10.setText("    ");
        this.jPanel_ShowLegend.setPreferredSize(new Dimension(20, 10));
        this.jLabel11.setText("Row Label:");
        this.jComboBox_Metric.addItemListener(new ClusterDlg_jComboBox_Metric_itemAdapter(this));
        this.jComboBox_Linkage.addItemListener(new ClusterDlg_jComboBox_Linkage_itemAdapter(this));
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        this.jCheckBox_ColLabel.setSelected(this.m_bHeader);
        this.jCheckBox_ColLabel.setText("Header In First Row");
        this.jCheckBox_ColLabel.addItemListener(new ClusterDlg_jCheckBox_ColLabel_itemAdapter(this));
        this.jComboBox_RowLable.addItemListener(new ClusterDlg_jComboBox_RowLable_itemAdapter(this));
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jPanel3, "West");
        this.jPanel3.add((Component)this.jCheckBox_ColLabel, null);
        this.jPanel3.add((Component)this.jCheckBox_SortByValue, null);
        this.jPanel3.add((Component)this.jCheckBox_NormalizeData, null);
        this.jPanel3.add((Component)this.jLabel11, null);
        this.jPanel3.add((Component)this.jComboBox_RowLable, null);
        this.jPanel1.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jRadioButton_DualCluster, null);
        this.jPanel4.add((Component)this.jRadioButton_ColorImage, null);
        this.jPanel1.add((Component)this.jPanel11, "East");
        this.jPanel11.add((Component)this.jPanel_Metric, "North");
        this.jPanel_Metric.add((Component)this.jLabel_Metric, null);
        this.jPanel_Metric.add((Component)this.jComboBox_Metric, null);
        this.jPanel11.add((Component)this.jPanel_LinkageType, "Center");
        this.jPanel_LinkageType.add((Component)this.jLabel_Option, null);
        this.jPanel_LinkageType.add((Component)this.jComboBox_Linkage, null);
        this.jPanel2.add((Component)this.jPanel10, "Center");
        this.jPanel10.add((Component)this.jButton_OK, null);
        this.jPanel10.add((Component)this.jButton_Cancel, null);
        this.buttonGroup1.add(this.jRadioButton_SingleCluster);
        this.buttonGroup1.add(this.jRadioButton_DualCluster);
        this.buttonGroup1.add(this.jRadioButton_ColorImage);
        this.getContentPane().add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.jPanel6, null);
        this.jPanel6.add((Component)this.jScrollPane1, "West");
        this.jScrollPane1.getViewport().add((Component)this.jList_Columns, null);
        this.jPanel5.add((Component)this.jPanel7, null);
        this.jPanel7.add((Component)this.jLabel_MaxLimit, null);
        this.jPanel7.add((Component)this.jComboBox_MaxLimit, null);
        this.jPanel7.add((Component)this.jLabel_MedianUp, null);
        this.jPanel7.add((Component)this.jComboBox_MedianUp, null);
        this.jPanel7.add((Component)this.jLabel_MedianLow, null);
        this.jPanel7.add((Component)this.jComboBox_MedianLow, null);
        this.jPanel7.add((Component)this.jLabel_MinLimit, null);
        this.jPanel7.add((Component)this.jComboBox_MinLimit, null);
        this.jPanel5.add((Component)this.jPanel8, null);
        this.jPanel8.add((Component)this.jPanel14, "Center");
        this.jPanel14.add((Component)this.jLabel10, null);
        this.jPanel14.add((Component)this.jButton_MaxColor, null);
        this.jPanel14.add((Component)this.jLabel9, null);
        this.jPanel14.add((Component)this.jButton_MedianUpColor, null);
        this.jPanel14.add((Component)this.jLabel8, null);
        this.jPanel14.add((Component)this.jButton_MedianLowColor, null);
        this.jPanel14.add((Component)this.jLabel7, null);
        this.jPanel14.add((Component)this.jButton_MinColor, null);
        this.jPanel8.add((Component)this.jPanel_ShowLegend, "East");
        this.jComboBox_MaxLimit.addItem("Maximum");
        this.jComboBox_MinLimit.addItem("Minimum");
        this.jComboBox_MedianUp.addItem("Median");
        this.jComboBox_MedianLow.addItem("Median");
        this.jButton_MaxColor.setForeground(this.m_MaximumColor);
        this.jButton_MedianUpColor.setForeground(this.m_MedianUpColor);
        this.jButton_MedianLowColor.setForeground(this.m_MedianLowColor);
        this.jButton_MinColor.setForeground(this.m_MinimumColor);
        this.jComboBox_Metric.addItem("Manhattan");
        this.jComboBox_Metric.addItem("Euclidean");
        this.jComboBox_Metric.addItem("1 - r");
        this.jComboBox_Linkage.addItem("Single");
        this.jComboBox_Linkage.addItem("Complete");
        this.jComboBox_Linkage.addItem("Average");
        this.jComboBox_Linkage.addItem("Centroid");
        this.jComboBox_Linkage.addItem("Median");
        this.jComboBox_Linkage.addItem("Ward's");
        int col = this.m_table.m_dm.getColumnCount();
        this.jList_Columns.addListSelectionListener(this);
        this.jComboBox_RowLable.addItem("Row Label");
        this.listModel.addElement("<All>");
        int i = 1;
        while (i < col) {
            String name = this.m_table.m_dm.getColumnName(i);
            this.listModel.addElement(name);
            this.jComboBox_RowLable.addItem(name);
            ++i;
        }
        this.m_Method = AppFrame.m_method;
        this.m_Metric = AppFrame.m_metric;
        this.m_Dissimilarity = AppFrame.m_Dissimilarity;
        this.m_bSortValue = AppFrame.m_bSortValue;
        this.m_bNormalize = AppFrame.m_bNormalize;
        this.jRadioButton_DualCluster.setSelected(this.m_Method == 1);
        this.jRadioButton_SingleCluster.setSelected(this.m_Method == 0);
        this.jCheckBox_NormalizeData.setSelected(this.m_bNormalize);
        this.jComboBox_Metric.setSelectedIndex(this.m_Metric);
        this.jCheckBox_SortByValue.setSelected(this.m_bSortValue);
        this.jRadioButton_ColorImage.setSelected(this.m_Method == 2);
        this.jComboBox_Linkage.setSelectedIndex(this.m_Dissimilarity);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("OK")) {
            this.jButton_OK_actionPerformed();
        } else if (cmd.equals("Cancel")) {
            this.dispose();
        } else if (cmd.equals(MAXCOLOR)) {
            Color color = JColorChooser.showDialog(this, "Choose Maximum Value's Color", new Color(0, 255, 0));
            if (color != null) {
                this.m_MaximumColor = color;
                ((JButton)e.getSource()).setForeground(this.m_MaximumColor);
                this.jPanel_ShowLegend.repaint();
            }
        } else if (cmd.equals(MINCOLOR)) {
            Color color = JColorChooser.showDialog(this, "Choose Minimum Value's Color", new Color(0, 255, 0));
            if (color != null) {
                this.m_MinimumColor = color;
                ((JButton)e.getSource()).setForeground(this.m_MinimumColor);
                this.jPanel_ShowLegend.repaint();
            }
        } else if (cmd.equals(MEDIANLOWCOLOR)) {
            Color color = JColorChooser.showDialog(this, "Choose Median Low Value's Color", new Color(0, 255, 0));
            if (color != null) {
                this.m_MedianLowColor = color;
                ((JButton)e.getSource()).setForeground(this.m_MedianLowColor);
                this.jPanel_ShowLegend.repaint();
            }
        } else if (cmd.equals(MEDIANUPCOLOR)) {
            Color color = JColorChooser.showDialog(this, "Choose Median Up Value's Color", new Color(0, 255, 0));
            if (color != null) {
                this.m_MedianUpColor = color;
                ((JButton)e.getSource()).setForeground(this.m_MedianUpColor);
                this.jPanel_ShowLegend.repaint();
            }
        } else if (cmd.equals(SINGLECLUSTER)) {
            this.m_Method = 0;
            this.setControlState1(false);
            this.setControlState2(true);
        } else if (cmd.equals(DUALCLUSTER)) {
            this.m_Method = 1;
            this.setControlState1(true);
            this.setControlState2(true);
        } else if (cmd.equals(COLORIMAGE)) {
            this.m_Method = 2;
            this.setControlState1(true);
            this.setControlState2(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.jList_Columns.getSelectedIndex() == 0) {
            this.jList_Columns.clearSelection();
            this.m_nRowLabel = this.jComboBox_RowLable.getSelectedIndex();
            Vector<Integer> vV = new Vector<Integer>();
            int c = this.m_table.m_dm.getColumnCount() - 1;
            int i = 0;
            while (i < c) {
                vV.add(new Integer(i + 1));
                ++i;
            }
            i = 0;
            while (i < vV.size()) {
                if (vV.get(i).equals(new Integer(this.m_nRowLabel))) {
                    vV.remove(i);
                }
                ++i;
            }
            int[] in = new int[vV.size()];
            int i2 = 0;
            while (i2 < in.length) {
                in[i2] = (Integer)vV.get(i2);
                ++i2;
            }
            this.jList_Columns.setSelectedIndices(in);
        }
    }

    public void jButton_OK_actionPerformed() {
        Color[] color;
        int[] indices = this.jList_Columns.getSelectedIndices();
        int cols = indices.length;
        int rows = this.m_table.m_dm.getRowCount();
        if (this.m_bHeader) {
            --rows;
        }
        if (cols * rows < 3) {
            ClUtils.ErrorMessage("Please select data correctly!");
            return;
        }
        this.m_nRowLabel = this.jComboBox_RowLable.getSelectedIndex();
        String[] rLabel = new String[rows];
        String[] cLabel = new String[cols];
        float[][] data = new float[rows][cols];
        if (this.m_bHeader) {
            int spotIDCol = -1;
            int i = 0;
            while (i < this.m_table.m_dm.getColumnCount()) {
                if (((String)this.m_table.m_dm.getValueAt(0, i)).equals("SPOTID")) {
                    spotIDCol = i;
                    break;
                }
                ++i;
            }
            if (spotIDCol >= 0) {
                Object[] spots = new SpotCol[rows];
                int i2 = 0;
                while (i2 < rows) {
                    String str = this.m_table.m_dm.getValueAt(i2 + 1, spotIDCol).toString().trim();
                    if (str.length() == 0) {
                        str = "-1";
                    }
                    spots[i2] = new SpotCol(Integer.parseInt(str), i2);
                    ++i2;
                }
                Arrays.sort(spots);
                int idx = 0;
                while (idx < spots.length) {
                    int row = ((SpotCol)spots[idx]).row_ID + 1;
                    rLabel[idx] = (String)this.m_table.m_dm.getValueAt(row, this.m_nRowLabel);
                    int j = 0;
                    while (j < cols) {
                        try {
                            data[idx][j] = Float.parseFloat((String)this.m_table.m_dm.getValueAt(row, indices[j]));
                        }
                        catch (Exception ex) {
                            data[idx][j] = Float.NaN;
                        }
                        ++j;
                    }
                    ++idx;
                }
                i2 = 0;
                while (i2 < cols) {
                    cLabel[i2] = (String)this.m_table.m_dm.getValueAt(0, indices[i2]);
                    ++i2;
                }
            } else {
                i = 0;
                while (i < rows) {
                    rLabel[i] = (String)this.m_table.m_dm.getValueAt(i + 1, this.m_nRowLabel);
                    int j = 0;
                    while (j < cols) {
                        try {
                            data[i][j] = Float.parseFloat((String)this.m_table.m_dm.getValueAt(i + 1, indices[j]));
                        }
                        catch (Exception ex) {
                            data[i][j] = Float.NaN;
                        }
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < cols) {
                    cLabel[i] = (String)this.m_table.m_dm.getValueAt(0, indices[i]);
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < rows) {
                rLabel[i] = (String)this.m_table.m_dm.getValueAt(i, this.m_nRowLabel);
                int j = 0;
                while (j < cols) {
                    try {
                        data[i][j] = Float.parseFloat((String)this.m_table.m_dm.getValueAt(i, indices[j]));
                    }
                    catch (Exception ex) {
                        data[i][j] = Float.NaN;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < cols) {
                cLabel[i] = this.m_table.m_dm.getColumnName(indices[i]);
                ++i;
            }
        }
        try {
            this.processNaNData(data);
        }
        catch (Exception ex) {
            ClUtils.ErrorMessage(ex.getMessage());
            return;
        }
        Cluster tree = new Cluster();
        tree.setFlaged(AppFrame.m_bUseFlagData);
        AppFrame.m_bUseFlagData = false;
        double[] limit = new double[4];
        if (this.m_bNormalize) {
            data = this.NormalizeData(data);
        }
        if (this.jComboBox_MaxLimit.getSelectedItem().equals("Maximum")) {
            limit[1] = Algorithm.GetMaxInArray(data);
        } else {
            try {
                limit[1] = Double.parseDouble((String)this.jComboBox_MaxLimit.getSelectedItem());
            }
            catch (Exception ex) {
                limit[1] = Algorithm.GetMaxInArray(data);
            }
        }
        if (this.jComboBox_MinLimit.getSelectedItem().equals("Minimum")) {
            limit[0] = Algorithm.GetMinInArray(data);
        } else {
            try {
                limit[0] = Double.parseDouble((String)this.jComboBox_MinLimit.getSelectedItem());
            }
            catch (Exception ex) {
                limit[0] = Algorithm.GetMinInArray(data);
            }
        }
        float[] tmp = new float[rows * cols];
        int k = 0;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                tmp[k++] = data[i][j];
                ++j;
            }
            ++i;
        }
        limit[2] = limit[3] = (double)Algorithm.Median_quickSelect(tmp);
        double t1 = Double.NaN;
        double t2 = Double.NaN;
        if (!this.jComboBox_MedianLow.getSelectedItem().equals("Median")) {
            try {
                t1 = Double.parseDouble((String)this.jComboBox_MedianLow.getSelectedItem());
            }
            catch (Exception ex) {
                t1 = limit[2];
            }
        }
        if (!this.jComboBox_MedianUp.getSelectedItem().equals("Median")) {
            try {
                t2 = Double.parseDouble((String)this.jComboBox_MedianUp.getSelectedItem());
            }
            catch (Exception ex) {
                t2 = limit[3];
            }
        }
        if (t2 > t1) {
            limit[2] = t1;
            limit[3] = t2;
        }
        if (tree.ClusteringAnalysis(data, rLabel, cLabel, this.m_Method, this.m_Metric, this.m_Dissimilarity, this.m_bSortValue, this.m_bNormalize, limit, color = new Color[]{this.m_MinimumColor, this.m_MedianUpColor, this.m_MedianUpColor, this.m_MaximumColor}, this.m_table, this.m_appFrame, this.m_GroupColNames)) {
            tree.start();
        }
        this.dispose();
    }

    public void setGroupInfo(List<String>[] grp_col_names) {
        this.m_GroupColNames = grp_col_names;
    }

    private float[][] NormalizeData(float[][] data) {
        int cols = data[0].length;
        int rows = data.length;
        float[] avg = new float[cols];
        int col = 0;
        while (col < cols) {
            double sum = 0.0;
            int count = 0;
            int row = 0;
            while (row < rows) {
                if (!Float.isNaN(data[row][col])) {
                    sum += (double)data[row][col];
                    ++count;
                }
                ++row;
            }
            avg[col] = (float)(sum / (double)count);
            ++col;
        }
        float[] Std = new float[cols];
        int col2 = 0;
        while (col2 < cols) {
            double sum = 0.0;
            int count = 0;
            int row = 0;
            while (row < rows) {
                if (!Float.isNaN(data[row][col2])) {
                    double tmp = data[row][col2] - avg[col2];
                    sum += tmp * tmp;
                    ++count;
                }
                ++row;
            }
            if (count > 1) {
                Std[col2] = (float)Math.sqrt(sum / (double)(count - 1));
                if ((double)Std[col2] < 1.0E-20) {
                    Std[col2] = 1.0f;
                }
            } else {
                Std[col2] = 1.0f;
            }
            ++col2;
        }
        float[][] Ret = new float[rows][cols];
        int col3 = 0;
        while (col3 < cols) {
            int row = 0;
            while (row < rows) {
                Ret[row][col3] = !Double.isNaN(data[row][col3]) ? (data[row][col3] - avg[col3]) / Std[col3] : Float.NaN;
                ++row;
            }
            ++col3;
        }
        return Ret;
    }

    private void processNaNData(float[][] data) throws Exception {
        int j = 0;
        while (j < data[0].length) {
            double sum = 0.0;
            int count = 0;
            int i = 0;
            while (i < data.length) {
                if (!Float.isNaN(data[i][j]) && !Float.isInfinite(data[i][j])) {
                    sum += (double)data[i][j];
                    ++count;
                }
                ++i;
            }
            if (count == 0) {
                throw new Exception("Too many null values in data!");
            }
            sum /= (double)count;
            i = 0;
            while (i < data.length) {
                if (Float.isNaN(data[i][j]) || Float.isInfinite(data[i][j])) {
                    data[i][j] = (float)sum;
                }
                ++i;
            }
            ++j;
        }
    }

    void jCheckBox_SortByValue_itemStateChanged(ItemEvent e) {
        this.m_bSortValue = e.getStateChange() == 1;
    }

    void jCheckBox_NormalizeData_itemStateChanged(ItemEvent e) {
        this.m_bNormalize = e.getStateChange() == 1;
    }

    void jComboBox_Metric_itemStateChanged(ItemEvent e) {
        this.m_Metric = e.getItem().equals("Manhattan") ? 0 : (e.getItem().equals("Euclidean") ? 1 : 2);
    }

    void jComboBox_Linkage_itemStateChanged(ItemEvent e) {
        this.jComboBox_Metric.setEnabled(true);
        if (e.getItem().equals("Single")) {
            this.m_Dissimilarity = 0;
        } else if (e.getItem().equals("Complete")) {
            this.m_Dissimilarity = 1;
        } else if (e.getItem().equals("Average")) {
            this.m_Dissimilarity = 2;
        } else if (e.getItem().equals("Centroid")) {
            this.m_Dissimilarity = 3;
        } else if (e.getItem().equals("Median")) {
            this.m_Dissimilarity = 4;
        } else {
            this.jComboBox_Metric.setSelectedItem("Euclidean");
            this.m_Dissimilarity = 5;
            this.jComboBox_Metric.setEnabled(false);
        }
    }

    void jCheckBox_ColLabel_itemStateChanged(ItemEvent e) {
        this.m_bHeader = e.getStateChange() == 1;
    }

    void jComboBox_RowLable_itemStateChanged(ItemEvent e) {
        this.m_nRowLabel = this.jComboBox_RowLable.getSelectedIndex();
        if (this.jList_Columns.isSelectedIndex(this.m_nRowLabel)) {
            int[] index = this.jList_Columns.getSelectedIndices();
            int[] in = new int[index.length - 1];
            int k = 0;
            int i = 0;
            while (i < index.length) {
                if (index[i] != this.m_nRowLabel) {
                    in[k++] = index[i];
                }
                ++i;
            }
            this.jList_Columns.setSelectedIndices(in);
        }
    }

    class ShowLegendPanel
    extends JPanel {
        ShowLegendPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(ClusterDlg.this.m_MaximumColor);
            if (ClusterDlg.this.m_Method != 0) {
                int w = (int)this.getSize().getWidth() - 2;
                int h = (int)this.getSize().getHeight();
                int delt = h / 3;
                int xStart = 2;
                if (ClusterDlg.this.m_MedianUpColor.toString().compareTo(ClusterDlg.this.m_MedianLowColor.toString()) != 0) {
                    GradientPaint gp = new GradientPaint(xStart, 0.0f, ClusterDlg.this.m_MaximumColor, xStart, delt, ClusterDlg.this.m_MedianUpColor);
                    ((Graphics2D)g).setPaint(gp);
                    g.fillRect(xStart, 0, w, delt);
                    gp = new GradientPaint(xStart, delt, ClusterDlg.this.m_MedianUpColor, xStart, delt + delt, ClusterDlg.this.m_MedianLowColor);
                    ((Graphics2D)g).setPaint(gp);
                    g.fillRect(xStart, delt, w, delt);
                    gp = new GradientPaint(xStart, delt + delt, ClusterDlg.this.m_MedianLowColor, xStart, h, ClusterDlg.this.m_MinimumColor);
                    ((Graphics2D)g).setPaint(gp);
                    g.fillRect(xStart, delt + delt, w, delt);
                } else {
                    delt = h / 2;
                    GradientPaint gp = new GradientPaint(xStart, 0.0f, ClusterDlg.this.m_MaximumColor, xStart, delt, ClusterDlg.this.m_MedianUpColor);
                    ((Graphics2D)g).setPaint(gp);
                    g.fillRect(xStart, 0, w, delt);
                    gp = new GradientPaint(xStart, delt, ClusterDlg.this.m_MedianUpColor, xStart, delt + delt, ClusterDlg.this.m_MinimumColor);
                    ((Graphics2D)g).setPaint(gp);
                    g.fillRect(xStart, delt, w, delt);
                }
            }
        }
    }

    public class SpotCol
    implements Comparable {
        public int spot_id;
        public int row_ID;

        public SpotCol(int spotid, int rowID) {
            this.spot_id = spotid;
            this.row_ID = rowID;
        }

        public int compareTo(Object obj) {
            SpotCol tmp = (SpotCol)obj;
            if (this.spot_id < tmp.spot_id) {
                return -1;
            }
            if (this.spot_id > tmp.spot_id) {
                return 1;
            }
            return 0;
        }
    }
}

