/*
 * Decompiled with CFR 0.152.
 */
package NCTR.app.arraytrack.vs2.analysis.clustering;

import NCTR.app.arraytrack.vs2.ParsedExpressionValue;
import NCTR.app.arraytrack.vs2.analysis.clustering.MySwatchChooserPanel;
import NCTR.util.FileUtilities;
import NCTR.util.IntVector;
import NCTR.util.RowColLabeledTabularData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class ClUtils {
    public static final String cluster = "cls";
    public static final String jpeg = "jpeg";
    public static final String jpg = "jpg";
    public static final String gif = "gif";
    public static final String tiff = "tiff";
    public static final String tif = "tif";
    public static final String png = "png";
    public static final String text = "txt";
    public static final String dat = "dat";
    public static final String Excel = "xls";
    public static final String Excel2007 = "xlsx";
    public static final String Cell = "cel";
    public static final String kmeans = "kms";
    public static final String Model = "model";
    public static final int EOF = -1;

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getExtension(String fileName) {
        String ext = null;
        String s = fileName;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = ClUtils.class.getClassLoader().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public static String getName(String fileName) {
        int i = fileName.lastIndexOf(46);
        String ret = "";
        ret = i > 0 && i < fileName.length() - 1 ? fileName.substring(0, i) : fileName;
        return ret;
    }

    public static void ErrorMessage(final String error) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(null, error, "Error", 0);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, error, "Error", 0);
                }
            });
        }
    }

    public static void fillNaNsWithAvgDataVal(double[][] data) {
        int j = 0;
        while (j < data.length) {
            double sum = 0.0;
            int count = 0;
            int i = 0;
            while (i < data[0].length) {
                if (!Double.isNaN(data[j][i]) && !Double.isInfinite(data[j][i])) {
                    sum += data[j][i];
                    ++count;
                }
                ++i;
            }
            if (count < data[0].length) {
                sum = count == 0 ? 0.0 : (sum /= (double)count);
                i = 0;
                while (i < data[0].length) {
                    if (Double.isNaN(data[j][i]) || Double.isInfinite(data[j][i])) {
                        data[j][i] = sum;
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public static void Message(final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            JOptionPane.showMessageDialog(null, message, "For Your Information", 1);
            System.out.println(message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, message, "For Your Information", 1);
                }
            });
        }
    }

    public static JColorChooser createColorChooser() {
        JColorChooser chooser = new JColorChooser();
        AbstractColorChooserPanel[] oldPanels = chooser.getChooserPanels();
        int i = 0;
        while (i < oldPanels.length) {
            String clsName = oldPanels[i].getClass().getName();
            if (clsName.equals("javax.swing.colorchooser.DefaultSwatchChooserPanel")) {
                chooser.removeChooserPanel(oldPanels[i]);
            }
            ++i;
        }
        oldPanels[0] = new MySwatchChooserPanel();
        chooser.setChooserPanels(oldPanels);
        return chooser;
    }

    public static RowColLabeledTabularData loadTabularData(String file, int row_label_cnum, int[] data_cnums, boolean col_hdrs_line_present) throws IOException {
        String[] row_labels_array;
        String line;
        String[] col_hdrs;
        ArrayList<String> row_labels = row_label_cnum > 0 ? new ArrayList<String>(5000) : null;
        ArrayList<double[]> data = new ArrayList<double[]>(5000);
        char delim = '\t';
        String delims = String.valueOf(delim);
        IntVector data_cixs = new IntVector(data_cnums.length);
        int i = 0;
        while (i < data_cnums.length) {
            data_cixs.add(data_cnums[i] - 1);
            ++i;
        }
        int row_label_cix = row_label_cnum - 1;
        BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
        if (col_hdrs_line_present) {
            col_hdrs = new String[data_cnums.length];
            String hdrs_line = FileUtilities.nextNonBlankLineFrom(rdr);
            StringTokenizer col_hdrs_tkr = new StringTokenizer(hdrs_line, delims, true);
            int cix = 0;
            while (col_hdrs_tkr.hasMoreTokens()) {
                String tok = col_hdrs_tkr.nextToken();
                if (tok.length() == 1 && tok.charAt(0) == delim) {
                    ++cix;
                    continue;
                }
                int data_cix_ix = data_cixs.indexOf(cix);
                if (data_cix_ix < 0) continue;
                col_hdrs[data_cix_ix] = tok;
            }
        } else {
            col_hdrs = null;
        }
        while ((line = FileUtilities.nextNonBlankLineFrom(rdr)) != null) {
            int cix = 0;
            String tok = null;
            String row_label = null;
            double[] data_row = new double[data_cnums.length];
            Arrays.fill(data_row, Double.NaN);
            StringTokenizer tkr = new StringTokenizer(line, delims, true);
            while (tkr.hasMoreTokens()) {
                tok = tkr.nextToken();
                if (tok.length() == 1 && tok.charAt(0) == delim) {
                    ++cix;
                    continue;
                }
                if (cix == row_label_cix) {
                    row_label = tok.trim();
                    continue;
                }
                int data_cix_ix = data_cixs.indexOf(cix);
                if (data_cix_ix < 0) continue;
                try {
                    data_row[data_cix_ix] = ParsedExpressionValue.fromString(tok).getExpressionValue();
                    if (!Double.isInfinite(data_row[data_cix_ix])) continue;
                    data_row[data_cix_ix] = Double.NaN;
                }
                catch (NumberFormatException nfe) {
                    data_row[data_cix_ix] = Double.NaN;
                }
            }
            if (row_labels != null) {
                row_labels.add(row_label);
            }
            data.add(data_row);
        }
        Object data_array = new double[data.size()][];
        data_array = (double[][])data.toArray((T[])data_array);
        if (row_labels != null) {
            row_labels_array = new String[row_labels.size()];
            row_labels_array = row_labels.toArray(row_labels_array);
        } else {
            row_labels_array = null;
        }
        return new RowColLabeledTabularData((double[][])data_array, row_labels_array, col_hdrs);
    }

    public static Vector<Vector<String>> readTxtIntoVector(File file) {
        Vector list = null;
        try {
            int separator = 9;
            String ext = ClUtils.getExtension(file);
            if (ext != null && ext.equals("csv")) {
                separator = 44;
            }
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = null;
            list = new Vector();
            while ((line = in.readLine()) != null) {
                Vector<String> row = new Vector<String>();
                int from = 0;
                int to = 0;
                while ((to = line.indexOf(separator, from)) != -1) {
                    row.add(line.substring(from, to));
                    from = to + 1;
                }
                row.add(line.substring(from));
                list.add(row);
            }
            in.close();
        }
        catch (Exception ex) {
            list = null;
            ClUtils.Message(ex.toString());
        }
        catch (Error er) {
            list = null;
            ClUtils.Message(er.toString());
        }
        return list;
    }
}

